#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/land.c,v 2.2 1995/08/16 05:25:51 empire Exp $";
#endif /* not lint */

/*
 * land.c
 *
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "land.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"
#include "optlist.h"

land()
{
	int	nunits;
	struct	nstr_item ni;
	struct	lndstr land;
	int	vec[I_MAX+1];
	s_char	*mission_short_name();

	if (!snxtitem(&ni, EF_LAND, player->argp[1]))
		return RET_SYN;

	nunits = 0;
	while (nxtitem(&ni, (s_char *)&land)) {
		if (land.lnd_own == 0)
			continue;
		if (!player->owner && !player->god)
			continue;
		if (land.lnd_type < 0 || land.lnd_type > lnd_maxno) {
			pr("bad unit type %d (#%d)\n",
				land.lnd_type, ni.cur);
			continue;
		}
		count_land_planes(&land);

		if (nunits++ == 0) {
			if (player->god)
				pr("own ");
pr("   # unit type             x,y   a  eff fort  mu food");
			if (opt_FUEL)	
				pr(" fuel");
			pr(" tech retr rad");
			pr(" xl");
			pr(" ship\n");
		}
		if (player->god)
			pr("%3d ", land.lnd_own);
		pr("%4d ", ni.cur);
		pr("%-16.16s ", lchr[land.lnd_type].l_name);
		prxy("  %4d,%-4d", land.lnd_x, land.lnd_y, player->cnum);
		pr("%c", land.lnd_army);
		pr("%4d%%", land.lnd_effic);
		pr("%5d", land.lnd_harden);
		pr("%4d", land.lnd_mobil);
		getvec(VT_ITEM, vec, (s_char *)&land, EF_LAND);
		pr("%5d", vec[I_FOOD]);
		if (opt_FUEL)
			pr("%5d",land.lnd_fuel);
		pr("%5d ", land.lnd_tech);
		pr("%3d%%", land.lnd_retreat);
		pr("%4d", land.lnd_rad_max);
		pr("%3d",land.lnd_nxlight);
		if (land.lnd_ship >= 0)
			pr("%5d\n",land.lnd_ship);
		else
			pr("\n");
	}
	if (nunits == 0) {
		if (player->argp[1])
			pr("%s: No unit(s)\n", player->argp[1]);
		else
			pr("%s: No unit(s)\n", "");
		return RET_FAIL;
	}else
		pr("%d unit%s\n", nunits, splur(nunits));
	return RET_OK;
}
