;;;;;;;;;;;;;;;;;;;;;;;;;;; -*- Mode: Emacs-Lisp -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;
;; emp-batch.el -- Batch play support for Gnu Emacs Empire Tool (GEET)
;; 
;; Copyright (c) 1990 Lynn Randolph Slater, Jr
;; 
;; AFSID           : $__Header$
;; Author          : Lynn Slater
;; Created On      : Thu Nov  8 19:09:53 1990
;; Last Modified By: Lynn Slater x2048
;; Last Modified On: Thu Feb 14 19:16:37 1991
;; Update Count    : 65
;; Status          : GEET General Release 2d Patch 0
;; 
;; HISTORY
;; 3-Dec-1990		Lynn Slater x2048	
;;    Last Modified: Sun Dec  2 12:58:35 1990 #37 (Lynn Slater x2048)
;;    fire-adjust was just fire
;; 11-Nov-1990		Lynn Slater	
;;    Last Modified: Sun Nov 11 12:37:31 1990 #9 (Lynn Slater)
;;    made it with if the country is in use
;; PURPOSE
;; 	Plays batch empire, redefines debugger to print to std out
;; TABLE OF CONTENTS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The contents of this file ARE copyrighted but permission to use, modify,
;; and distribute this code is granted as described in the file
;; emp-install.el which should have been distributed with this file. These
;; terms constitute what the Free Software Foundation calls a COPYLEFT.
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(provide 'emp-batch)

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Batch Play 
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun debug (&rest debugger-args)
  "Batch debugger, just prints to stdout"
  (message "batch backtrace...")
  (let (debugger-value
	(debugger-match-data (match-data))
	(debug-on-error nil)
	(debug-on-quit nil)
	(debugger-buffer (let ((default-major-mode 'fundamental-mode))
			   (generate-new-buffer "*Backtrace*")))
	(debugger-old-buffer (current-buffer))
	(debugger-step-after-exit nil)
	;; Don't keep reading from an executing kbd macro!
	(executing-macro nil)
	(cursor-in-echo-area nil))
    (unwind-protect
	(save-excursion
	  (save-window-excursion
	    (pop-to-buffer debugger-buffer)
	    (erase-buffer)
	    (let ((standard-output (current-buffer))
		  (print-escape-newlines t)
		  (print-length 50))
	      (backtrace))
	    (goto-char (point-min))
	    ;;(debugger-mode)
	    (delete-region (point)
			   (progn
			     (forward-sexp 8)
			     (forward-line 1)
			     (point)))
	    (cond ((memq (car debugger-args) '(lambda debug))
		   (insert "Entering:\n")
		   (if (eq (car debugger-args) 'debug)
		       (progn
			 (backtrace-debug 4 t)
			 (delete-char 1)
			 (insert ?*)
			 (beginning-of-line))))
		  ((eq (car debugger-args) 'exit)
		   (insert "Return value: ")
		   (setq debugger-value (nth 1 debugger-args))
		   (prin1 debugger-value (current-buffer))
		   (insert ?\n)
		   (delete-char 1)
		   (insert ? )
		   (beginning-of-line))
		  ((eq (car debugger-args) 'error)
		   (insert "Signalling: ")
		   (prin1 (nth 1 debugger-args) (current-buffer))
		   (insert ?\n))
		  ((eq (car debugger-args) t)
		   (insert "Beginning evaluation of function call form:\n"))
		  (t
		   (prin1 (if (eq (car debugger-args) 'nil)
			      (cdr debugger-args) debugger-args)
			  (current-buffer))
		   (insert ?\n)))
	    (message "")
	    (beginning-of-buffer)
	    (while (not (eobp))
	      (message "%s" (buffer-substring (point)
					      (progn (end-of-line) (point))))
	      (forward-line 1)
	      )
	    (message "Quiting emacs because of the error on %s"
		     (current-time-string))
	    (kill-emacs 1)
	    ))
      ;; So that users do not try to execute debugger commands
      ;;  in an invalid context
      (kill-buffer debugger-buffer)
      (catch 'foo
	(let ((d debugger-match-data))
	  (while d
	    (and (car d)
		 (null (marker-buffer (car d)))
		 ;; match-data buffer is deleted.
		 (throw 'foo nil))
	    (setq d (cdr d)))
	  (store-match-data debugger-match-data))))
    ;;(setq debug-on-next-call debugger-step-after-exit)
    debugger-value))

(defmacro build-batch-command (name body)
  (`
   (let ((debug-on-error t)
	 (empire-batch-play t)
	 )

     (require 'emp-auto)
     (require 'emp-shell)
    
     (empire-shell)
     (setq empire-save-file-name (car command-line-args-left))
     (message "         Batch GEET version %s command %s on %s"
	      GEET-Version '(, name) (current-time-string))
     (if (not (file-exists-p empire-save-file-name))
	 (progn
	   (message "Cannot find file '%s' in '%s'" empire-save-file-name
		    default-directory)
	   (kill-emacs 3)))
     (let ((empire-batch-play t))
       (restore-empire empire-save-file-name)
       (let ((trim-versions-without-asking t)
	     (kept-old-versions 1)
	     (kept-new-versions 2)
	     (executing-macro t)	; suppress mark set
	     (normal-empire-check-hooks empire-check-hooks)
	     (normal-empire-dump-hooks empire-dump-hooks)
	     (normal-empire-automatically-execute-commands
	      empire-automatically-execute-commands)
	     (normal-empire-interaction-verbosity empire-interaction-verbosity)
	     (empire-interaction-verbosity nil) ; must reset
	     empire-check-hooks empire-dump-hooks
	     msg
	     )
	 ;; enable only those hooks not known be be no-ops during dump read
	 (mapcar '(lambda (hook)
		    (if (not (member hook '(check-dist
					    check-food
					    check-spare
					    check-plague
					    check-security)))
			(setq empire-check-hooks
			      (cons hook empire-check-hooks))))
		 normal-empire-check-hooks)
	 (mapcar '(lambda (hook)
		    (if (not (member hook '(empire-dump-check-some-progress
					    empire-dump-check-all-progress
					    empire-dump-check-work)))
			(setq empire-dump-hooks
			      (cons hook empire-dump-hooks))))
		 normal-empire-dump-hooks)
	 (setq empire-dump-hooks (nreverse empire-dump-hooks))
	 (setq empire-check-hooks (nreverse empire-check-hooks))

	 ;;(message "")
	 ;;(message "Check hooks are %s" empire-check-hooks)
	 ;;(message "Dump hooks are %s" empire-dump-hooks)
	 ;;(message "Verbosity level is %s" empire-interaction-verbosity)

	 ;; Log in
	 (let (
	       ;;(empire-message-client-replies t) ; show login as it happens
	       )
	   (insert (setq empire-last-command empire-client-command))
	   (shell-send-input)
	   (setq msg
		 (catch 'client-hosed
		   (if (eq (wait-for-empire-prompt) 'country-in-use-prompt)
		       (progn
			 (message "\n*** Country in use, Exiting voluntarily at %s\n" (current-time-string))
			 (kill-emacs 2)))
		   nil
		   ))
	   (if msg			; login failed for some other reason
	       (progn
		 ;; show all the last output
		 (message "\n\n******************************************")
		 (message "** The client interaction is hosed!")
		 (message "**   %s" msg)
		 (message "******************************************\n")
		 (kill-emacs 3)
		 ))
	   )
	 

	 (map-empire)			; else no mark and show-map bombs

	 (setq msg
	       (catch 'client-hosed
		 (, body)
		 nil))
	 (if msg
	     (progn
	       ;; show all the last output
	       (message "\n\n******************************************")
	       (message "** The client interaction is hosed!")
	       (message "**   %s" msg)
	       (message "******************************************\n")
	       (message "The last output was the following:\n")
	       (switch-to-buffer empire-shell-buffer)
	       (end-of-buffer)
	       (shell-prev-command)
	       (while (not (eobp))
		 (message "Hosed Client: %s"
			  (buffer-substring (point)
					    (progn
					      (forward-line 1)
					      (1- (point)))))
		 ))
	   ;; else no hose
	   ;; logout
	   (let ((empire-message-client-replies t))
	     (send-empire-command "quit")
	     )
	   )	 
	 ))
     (let ((trim-versions-without-asking t)
	   (kept-old-versions 1)
	   (kept-new-versions 2)
	   (empire-batch-play t))	   
       (save-empire empire-save-file-name))
     (message "Done with %s on %s" empire-save-file-name (current-time-string))
     (message "")
     (message "")
     (kill-emacs t))))

(defun save-empire-batch ()
  (let ((empire-check-hooks normal-empire-check-hooks)
	(empire-dump-hooks normal-empire-dump-hooks)
	(empire-interaction-verbosity normal-empire-interaction-verbosity)
	(empire-automatically-execute-commands normal-empire-automatically-execute-commands)
	(trim-versions-without-asking t)
	(kept-old-versions 1)
	(kept-new-versions 2))
    (save-empire empire-save-file-name)))
	
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Batch Commands
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun batch-adjust (junk)
  "This runs a refresh-adjust in batch mode.  Typical invocation is
     emacs -batch -l emp-batch -adjust <empire dump file name>
   See empire-batch for an easy shell script.

  First, an empire shell is started and the value of empire-client-command
is sent as a login. If this works, a refresh-adjust is started except that
some hooks are disabled as they are known not to issue commands but instead
only provide info for a human interactive player."
  (build-batch-command
   batch-adjust
   (refresh-adjust-empire empire-save-file-name nil t)))
(setq command-switch-alist (cons (cons "-adjust" 'batch-adjust) command-switch-alist))

(defun batch-fire-adjust (junk)
  "This sinks all ships and then runs a refresh-adjust in batch mode.
Typical invocation is 
     emacs -batch -l emp-batch -fire-adjust <empire dump file name>
   See empire-batch for an easy shell script.

  First, an empire shell is started and the value of empire-client-command
is sent as a login. If this works, a refresh-adjust is started except that
some hooks are disabled as they are known not to issue commands but instead
only provide info for a human interactive player."
  (build-batch-command
   batch-fire-adjust
   (progn
     (empire-fire-all-ships)

     ;;(refresh-adjust-empire empire-save-file-name nil t)
     (switch-to-buffer empire-shell-buffer)
     (refresh-empire t)
     (save-empire-batch)
     (adjust-empire t)

     (message "")
     (empire-fire-all-ships)
     (send-empire-command-and-parse-reply "dump # ?type=f"
					  'empire-read-dump
					  t)
     )))
(setq command-switch-alist (cons (cons "-fire-adjust" 'batch-fire-adjust) command-switch-alist))

(defun batch-sink-ships (junk)
  "This sinks all ships in batch mode.
Typical invocation is 
     emacs -batch -l emp-batch -fire <empire dump file name>"
  (build-batch-command
   batch-sink-ships
   (progn 
     (empire-fire-all-ships)
     (send-empire-command-and-parse-reply "dump # ?type=f"
					  'empire-read-dump
					  t)
     )))
(setq command-switch-alist (cons (cons "-fire" 'batch-sink-ships)
				 command-switch-alist))

