#!/bin/awk -f

# Parse report and generate pbmtext commands for each country

BEGIN {
  if (scale=="") scale=1;
  FS="[ \t\n,]+";
}

/^World size is [0-9]+ by [0-9]+./ {
  width = $4 * scale;
  height= $6 * scale;
  system("ppmmake white " width " " height " | ppmtopgm | pgmtopbm >over.pbm");
}

/.*#.*name.*tech.*research.*education.*happiness.*cap-location/ {
  getline;
  while (NF>0) {
    if ($2>0 && $2<90) {
      name=substr($0,8,15);
      x= $(NF-1) * scale + width/2;
      y= $NF * scale + height/2;
      system("pbmtext \"" name "\" | pnmcrop >text.pbm");
      system("pnmfile text.pbm >text.size");
      getline < "text.size";
      close("text.size");
      h=$NF;
      w=$(NF-2);
      x -= w/2;
      y -= h/2;
      if (x<0) x=0;
      if (y<0) y=0;
      if (x+w>=width) x=width-w-1;
      if (y+h>=height) y=height-h-1;
      printf("w:%s  h:%s\n",w,h);
      system("pnmpaste text.pbm " x " " y " over.pbm > over2.pbm");
      system("cp over2.pbm over.pbm");
    }
    getline;
  }
}
