#!/bin/awk -f
#
#	parses relations and power to generate war summaries
#	You need to give it the input of relations from
#	every country (rel 1 >file ; rel 2 >>file ; ... ; wars.awk file)


function truncwhite(str,  i,j) {
  for (i=1;i<=length(str) && substr(str,i,1) ~ "[ \t\r\n]";i++) ;
  for (j=length(str);j>i && substr(str,j,1) ~ "[ \t\r\n]";j--) ;
  return (substr(str,i,j-i+1));
}

/sects/

/.+ [0-9]+ +[0-9]+%/ {
  country=truncwhite(substr($0,1,9));
  if (!(country in nation)) {
#    printf("%s == ",country);
    for (coun in nation) {
#      printf("{%s} ",coun);
      if (country==substr(coun,1,9)) {
	country=coun;
	break;
      }
    }
#    printf("%s\n",country);
  }
  power[country]=$0;
}

/^.* Diplomatic Relations Report/ {
  i=match($0,"Diplomatic Relations Report");
  source=substr($0,2,i-3);
}

/^ *[0-9]+\)/ {
  dest=truncwhite(substr($0,6,20));
  nation[dest]=truncwhite(substr($0,1,3));
  if (substr($0,28,6)=="At War") {
    if (!((dest,source) in war)) {
      war[dest,source]=1;
      war[source,dest]=1;
      if ((dest in power) && (source in power)) {
	printf("%s\n",power[source]); 
	printf("%s\n",power[dest]);
      } else printf("%s vs. %s\n",source,dest);
      printf("\n");
    }
  }
  if (substr($0,38,6)=="At War") {
    if (!((source,dest) in war)) {
      war[dest,source]=1;
      war[source,dest]=1;
      if ((dest in power) && (source in power)) {
	printf("%s\n",power[dest]); 
	printf("%s\n",power[source]);
      } else printf("%s vs. %s\n",dest,source);
      printf("\n");
    }
  }
}
