#!/bin/awk -f
#
#	Collimates countries from the country command
#

function truncwhite(str,  i,j) {
  for (i=1;i<=length(str) && substr(str,i,1) ~ "[ \t\r\n]";i++) ;
  for (j=length(str);j>i && substr(str,j,1) ~ "[ \t\r\n]";j--) ;
  return (substr(str,i,j-i+1));
}


/^ *[0-9]+/ {
  nf=split($0,a,"[\t]+");
  country[$1]=a[nf];
  status[$1]=truncwhite(a[nf-1]);
  if ($1>lastco) lastco=$1;
  stati[status[$1]]++;
}

END {
  for (stat in stati) {
    printf("\n%d %s countries:\n",stati[stat],stat);
    c=0;
    for (n=0;n<=lastco;n++) {
      if ((n in country) && status[n]==stat) {
	printf("   %-20s",country[n]);
	c++;
	if ((c%3)==0) printf("\n");
      }
    }
  }
  printf("\n");
}
