#!/bin/awk -f
#
#	Creates add commands from an empire play list.  Country names
#	are in the first 24 characters, then the password.  Email address
#	starts at character 41.
#

function truncwhite(str,  i,j) {
  for (i=1;i<=length(str) && substr(str,i,1) ~ "[ \t\r\n]";i++) ;
  for (j=length(str);j>i && substr(str,j,1) ~ "[ \t\r\n]";j--) ;
  return (substr(str,i,j-i+1));
}


{
  name=truncwhite(substr($0,1,24));
  pass=truncwhite(substr($0,25,16));
  email=truncwhite(substr($0,41));

  printf("add %d \"%s\" \"%s\" n i\n", ++n,name,pass);
}

