#include "GraphP.h"

void AssignColorField(foo,bar)
	char *foo,**bar;

	{
	  if (foo != NULL) {
	    if (*bar != NULL) {
		free(*bar);
	    }
	    *bar =(char*) malloc((strlen(foo)+1)*sizeof(char));
	       strcpy(*bar,foo);
	  }
	}

unsigned long MakeColor(wid,name)
  GraphWidget   wid;
  char          *name;
     {
     XColor   exact,close;
     Display  *disp;
     Screen   *scrn;
     int      scrnnum;

     disp = XtDisplay(wid);
     scrnnum = XDefaultScreen(disp);
     scrn = XScreenOfDisplay(disp,scrnnum);

     if (XLookupColor(disp,wid->core.colormap,name,&exact,&close) == 1) {
         if(XAllocColor(disp,wid->core.colormap,&exact)){
            return(exact.pixel);
         } else {
            return(wid->graph.foreground);
         }
     } else {
         return(wid->graph.foreground);
     }
     }

/*******************************************/
/* make a new colormap if the default is the default color map
   and nothing if the colormap is curently not the default
*******************************************/

void MakeColormap(wid)
	GraphWidget   wid;

	{
	 Display   *disp;
	 XColor    fg,bg;

         disp = XtDisplay(wid);

	 wid->core.colormap =
                 XCreateColormap(disp,XtWindow(wid),
		 DefaultVisual(disp,XDefaultScreen(disp)),AllocNone);

	}

void UnFillColorMap(w)
	GraphWidget  w;
	{
	   Display  *disp;

           disp = XtDisplay(w);
           XFreeColormap(disp,w->core.colormap);
	   MakeColormap(w);
	}

int dexp2(num)
    int   num;
    {
       int accum,i;

       accum = 2;
       for(i=1;i<num;i++){
	  accum = accum * 2;
       }
       return(accum);
    }

void ElevationFillColorMap(w)
        GraphWidget  w;
        {
           XColor   exact,close;
           Display  *disp;
           Screen   *scrn;
           int      scrnnum,depth,i,shade,ncolors;

           disp = XtDisplay(w);
           scrnnum = XDefaultScreen(disp);
           scrn = XScreenOfDisplay(disp,scrnnum);
           depth = XDefaultDepthOfScreen(XtScreen(w));

           ncolors = (int) dexp2(depth);

           shade = (int) 65535/ncolors;

           for(i=1;i<13;i++){
                exact.pixel = (unsigned long) i;
                exact.red = (unsigned short) 0;
                exact.green = exact.red;
                exact.blue = (unsigned short) i * 65535/16;
                exact.flags = DoRed | DoGreen |DoBlue;
                XAllocColor(disp,w->core.colormap,&exact);
           }

           for(i=13;i<23;i++){
                exact.pixel = (unsigned long) i;
                exact.red = (unsigned short) 0;
                exact.green = (unsigned short) (i-8) * 65535/16;
                exact.blue = (unsigned short) 0;
                exact.flags = DoRed | DoGreen |DoBlue;
                XAllocColor(disp,w->core.colormap,&exact);
           }

           for(i=23;i<28;i++){
                exact.pixel = (unsigned long) i;
                exact.red = (unsigned short) (i-15) * 65535/16;;
                exact.green = (unsigned short) 0;
                exact.blue = (unsigned short) 0;
                exact.flags = DoRed | DoGreen |DoBlue;
                XAllocColor(disp,w->core.colormap,&exact);
           }
        }

void NationFillColorMap(w)
        GraphWidget  w;
        {
           XColor   exact,close;
           Display  *disp;
           Screen   *scrn;
           int      scrnnum,depth,i,shade,ncolors,j;

           disp = XtDisplay(w);
           scrnnum = XDefaultScreen(disp);
           scrn = XScreenOfDisplay(disp,scrnnum);
           depth = XDefaultDepthOfScreen(XtScreen(w));

           ncolors = (int) dexp2(depth);

           shade = (int) 65535/ncolors;

           exact.pixel = (unsigned long) 1;
           exact.red = (unsigned short)  65535;
           exact.green = (unsigned short)65535;
           exact.blue = (unsigned short) 65535; 
           exact.flags = DoRed | DoGreen |DoBlue;
           XAllocColor(disp,w->core.colormap,&exact);

           exact.pixel = (unsigned long) 0;
           exact.red = (unsigned short)  0;
           exact.green = (unsigned short)0;
           exact.blue = (unsigned short) 0; 
           exact.flags = DoRed | DoGreen |DoBlue;
           XAllocColor(disp,w->core.colormap,&exact);

           exact.pixel = (unsigned long) 2;
           exact.red = (unsigned short)  200;
           exact.green = (unsigned short) 15000;
           exact.blue = (unsigned short) 40000; 
           exact.flags = DoRed | DoGreen |DoBlue;
           XAllocColor(disp,w->core.colormap,&exact);

           for(i=4;i<((int)(ncolors/3));i +=3){
                exact.pixel = (unsigned long) i;
                exact.red = (unsigned short) (i-ncolors/3)*shade;
                exact.green = (unsigned short) 0*shade;
                exact.blue = (unsigned short) 0*shade;
                exact.flags = DoRed | DoGreen |DoBlue;
                XAllocColor(disp,w->core.colormap,&exact);
           }
           for(i=5;i<((int)(ncolors/3));i +=3){
                exact.pixel = (unsigned long) i;
                exact.green = (unsigned short) (i-ncolors/3)*shade;
                exact.red = (unsigned short) 0*shade;
                exact.blue = (unsigned short) 0*shade;
                exact.flags = DoRed | DoGreen |DoBlue;
                XAllocColor(disp,w->core.colormap,&exact);
           }
           for(i=6;i<((int)(ncolors/3));i +=3){
                exact.pixel = (unsigned long) i;
                exact.blue = (unsigned short) (i-ncolors/3)*shade;
                exact.green = (unsigned short) 0*shade;
                exact.red = (unsigned short) 0*shade;
                exact.flags = DoRed | DoGreen |DoBlue;
                XAllocColor(disp,w->core.colormap,&exact);
           }
        }

