#ifndef lint
static char *RCSid = "$Header: /u/dhay/stan/kent/update/RCS/main.c,v 1.1 91/03/19 23:39:18 dhay Exp Locker: dhay $";
#endif

/*
 * main.c
 *
 * Thread and signal initialization
 * for empire server
 *
 * Dave Pare, 1994
 */

#include <signal.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <fcntl.h>

#include "misc.h"
#include "nat.h"
#include "file.h"
#include "player.h"
#include "lwp.h"

int	panic();
int	shutdwn();

s_char	program[] = "server";

extern	void player_accept();
extern	void player_kill_idle();
extern	void update_sched();


main(argc, argv)
	int	argc;
	s_char	**argv;
{
	long	now;
	long	hour[2];

	if (argc < 2 || strcmp(argv[1], "-d") != 0) {
		disassoc();
		signal(SIGUSR1, shutdwn);
		signal(SIGBUS, panic);
		signal(SIGSEGV, panic);
		signal(SIGILL, panic);
		signal(SIGFPE, panic);
	}
	signal(SIGPIPE, SIG_IGN);
	logerror("Empire server (pid %d) started", getpid());
	time(&now);
	srandom(now);
	setfdtablesize(32, 256);
	player_init();
	ef_init();
	init_files();
	io_init();
	gamehours(now, hour);
	lwpInitSystem(6, (char **)&player);
	lwpCreate(PP_ACCEPT, player_accept, 8192, 0, 0, 0);
	lwpCreate(PP_KILLIDLE, player_kill_idle, 8192, 0, 0, 0);
	lwpCreate(PP_SCHED, update_sched, 8192, 0, 0, 0);
	lwpReschedule();
	close_files();
	return 0;
}

init_files()
{
	ef_open(EF_NATION, O_RDWR, EFF_MEM);
	ef_open(EF_SECTOR, O_RDWR, EFF_MEM);
	ef_open(EF_SHIP, O_RDWR, EFF_MEM);
	ef_open(EF_PLANE, O_RDWR, EFF_MEM);
	ef_open(EF_LAND, O_RDWR, EFF_MEM);
	ef_open(EF_NEWS, O_RDWR, 0);
	ef_open(EF_LOAN, O_RDWR, 0);
	ef_open(EF_TREATY, O_RDWR, 0);
	ef_open(EF_NUKE, O_RDWR, 0);
	ef_open(EF_POWER, O_RDWR, 0);
	ef_open(EF_TRADE, O_RDWR, 0);
	ef_open(EF_MAP, O_RDWR, EFF_MEM);
}

close_files()
{
	ef_close(EF_NATION);
	ef_close(EF_SECTOR);
	ef_close(EF_SHIP);
	ef_close(EF_PLANE);
	ef_close(EF_LAND);
	ef_close(EF_NEWS);
	ef_close(EF_LOAN);
	ef_close(EF_TREATY);
	ef_close(EF_NUKE);
	ef_close(EF_POWER);
	ef_close(EF_TRADE);
	ef_close(EF_MAP);
}

/* we're going down.  try to close the files at least */
panic(sig)
	int	sig;
{
	signal(SIGBUS, SIG_DFL);
	signal(SIGSEGV, SIG_DFL);
	signal(SIGILL, SIG_DFL);
	signal(SIGFPE, SIG_DFL);
	logerror("server received fatal signal %d", sig);
	close_files();
	_exit();
}

/* got a USR1 -- a shutdown */
shutdwn(sig)
	int	sig;
{
	/* might want to notify players, but that would take effort */
	logerror("server shutting down on signal %d", sig);
	close_files();
	_exit();
}
