static char *RCSid = "$Header: tm_natmod.c,v 1.2 89/05/26 02:12:16 mr-frog Exp $";

/*
 * tm_natmod.c
 *
 * perform updates of important, frequently changing
 * nat fields
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "nat.h"
#include "file.h"


/*
 * argi[0]: cmd
 * argi[1]: seqno (-1)
 * argi[2]: EF_NATION
 * argi[3]: country #
 * argi[4]: offset
 * argi[5]: indx
 * argi[6]: how changed (delta, set)
 * args[7]: string arg representing new value
 */
int
natmod(buf, argi)
	s_char	*buf;
	int	argi[];
{
	struct	fixnat *fp;
	s_char	space[256];
	s_char	*args[16];
	struct	natstr *np;

	if (parse(buf, args, 0, space, 0) < 4) {
		logerror("natmod: bad string from tm: %s\n", buf);
		return 0;
	}
	if ((fp = natfield(argi[4])) == 0) {
		logerror("natmod: bad field offset %d\n", argi[4]);
		return 0;
	}
	np = getnatp(argi[3]);
	natassign(fp, SETOFF(np, fp->offset), args[7], argi[5], argi[6]);
	return 1;
}
