#ifndef lint
static char *RCSid = "$Header: /u/dhay/stan/kent/update/RCS/main.c,v 1.1 91/03/19 23:39:18 dhay Exp Locker: dhay $";
#endif

/*
 * main.c
 *
 * world update main
 *
 * Dave Pare, 1994
 */

#include "misc.h"
#include "nat.h"
#include "file.h"
#include "sect.h"
#include "player.h"
#include "lwp.h"

#include <sys/time.h>

long	money[MAXNOC];
long	pops[MAXNOC];
long	sea_money[MAXNOC];
long	lnd_money[MAXNOC];
long	air_money[MAXNOC];

/*ARGSUSED*/
void
update_main(argc, argv)
	int	argc;
	s_char	**argv;
{
	extern	int etu_per_update;
	extern	double money_res;
	int	etu = etu_per_update;
	int	n;
	int	x;
#ifdef SLOW_WAR
	int	cn,cn2,rel;
	struct	natstr *cnp;
#endif /* SLOW_WAR */
	struct	natstr *np;

	player->proc = LwpCurrent;
	player->cnum = 0;
	player->god = 1;
	/*
	 * set up all the variables which get used in the
	 * sector production routine (for producing education,
	 * happiness, and printing out the state of the nation)
	 */
	logerror("production update (%d etus)", etu);
	bzero((s_char *)pops, sizeof(pops));
	bzero((s_char *)air_money, sizeof(air_money));
	bzero((s_char *)sea_money, sizeof(sea_money));
	bzero((s_char *)lnd_money, sizeof(lnd_money));
	for (n=0; n<MAXNOC; n++) {
		money[n] = 0;
		if ((np = getnatp(n)) == (struct natstr *)0)
			continue;
		money[n] = np->nat_money;
	}
	prepare_sects(etu);
	for (x=0; x<MAXNOC; x++){
		int	y,z,sb=0,sm=0,pb=0,pm=0,lm=0,lb=0;

		if ((np = getnatp(x)) == (struct natstr *)0)
			continue;
		np->nat_money += (int) (np->nat_reserve * money_res);
		for(y=1; y<SCT_MAXDEF+8; y++) {
			for(z=0; z<SCT_MAXDEF+8; z++) {
				if (np->nat_priorities[z] == y)
					do_prod(z, etu, x, &sb, &sm, &pb, &pm,
						&lb, &lm);
			}
		}
		/* 0 is maintain, 1 is build */
		if (!sm) prod_ship(etu, x, 0);
		if (!sb) prod_ship(etu, x, 1);
		if (!pm) prod_plane(etu, x, 0);
		if (!pb) prod_plane(etu, x, 1);
		if (!lm) prod_land(etu, x, 0);
		if (!lb) prod_land(etu, x, 1);
		/* produce all sects that haven't produced yet */
		produce_sect(x, etu, -1);
	}
	finish_sects();
	prod_nat(etu);
	age_levels(etu);
	/*flushwu();*/
#ifdef SLOW_WAR
	/* Update war declarations */
	/* MOBILIZATION->SITZKRIEG->AT_WAR */
	for (cn=1; cn < MAXNOC; cn++) {
		if ((cnp = getnatp(cn)) == 0)
			break;
		for (cn2=1; cn2 < MAXNOC; cn2++) {
			if (cn2 == cn)
				continue;
			rel=getrel(cnp,cn2);
			if (rel == MOBILIZATION){
			    rel = SITZKRIEG;
			    setrel(cn,cn2,rel);
			}
			else if (rel == SITZKRIEG){
			    rel = AT_WAR;
			    setrel(cn,cn2,rel);
			}
		}
	}
#endif /* SLOW_WAR */
	mob_ship(etu);
	mob_sect(etu);
	mob_plane(etu);
	mob_land(etu);
#ifdef DEMANDUPDATE
	update_removewants();
#endif DEMANDUPDATE
	/* flush all mem file objects to disk */
	ef_flush(EF_NATION);
	ef_flush(EF_SECTOR);
	ef_flush(EF_SHIP);
	ef_flush(EF_PLANE);
	ef_flush(EF_LAND);
	logerror("End update");
	player_delete(player);
	lwpExit();
	/*NOTREACHED*/
}

do_prod(sector_type,etu,n,ship_build,ship_maint,plane_build,plane_maint,land_build,land_maint)
	int sector_type;
	int n,*ship_build,*ship_maint;
	int *plane_build,*plane_maint;
	int *land_build,*land_maint;
{
	if (sector_type == PRI_SMAINT){
		prod_ship(etu,n,0);
		*ship_maint=1;
	}
	else
	if (sector_type == PRI_SBUILD){
		prod_ship(etu,n,1);
		*ship_build=1;
	}
	else
	if (sector_type == PRI_PMAINT){
		prod_plane(etu,n,0);
		*plane_maint=1;
	}
	else
	if (sector_type == PRI_PBUILD){
		prod_plane(etu,n,1);
		*plane_build=1;
	}
	else
	if (sector_type == PRI_LMAINT){
		prod_land(etu,n,0);
		*land_maint=1;
	}
	else
	if (sector_type == PRI_LBUILD){
		prod_land(etu,n,1);
		*land_build=1;
	}
	else
		produce_sect(n,etu,sector_type);
}
