#ifndef lint
static char *RCSid = "$Header: dispatch.c,v 1.10 90/03/19 10:51:31 mr-frog Exp $";
#endif

/*
 * dispatch.c
 *
 * actually execute the command given the comline
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "com.h"
#include "user.h"
#include "tm.h"
#include "match.h"
#include "nat.h"
#include "file.h"
#include "proto.h"
#include "io.h"

dispatch(buf, redir)
	s_char	*buf;
	s_char	*redir;
{
	extern struct comstr player_coms[];
	extern int update_pending;
	extern	int nuke();
	extern	int laun();
	struct	natstr *np;
	int	(*fn)();
	int	cmd;
	int	cost;

	cmd = comtch(player->argp[0], player_coms,
		player->ncomstat, player->god);
	if (cmd < 0) {
		if (cmd == M_NOTUNIQUE)
			pr("\"%s\" is ambiguous -- ", buf);
		else {
			pr("\"%s\" is not a legal command ", buf);
			if (player->nstat != player->ncomstat)
				pr("now ");
			pr("\n");
		}
		return -1;
	}
	fn = player_coms[cmd].c_addr;
	cost = player_coms[cmd].c_cost;
	np = getnatp(player->cnum);
	if (np->nat_btu < cost && cost > 0) {
		pr("You don't have the BTU's, bozo\n");
		return 0;
	}
	if (fn == 0) {
		pr("Command not implemented\n");
		return 0;
	}
	if (update_pending) {
		pr("Update in progress...command failed\n");
		return 0;
	}
	if (redir) {
		prredir(redir);
		pr(buf);
		pr("\n");
	}
	player->running++;
	switch (fn()) {
	case RET_OK:
		player->btused += cost;
		break;
	case RET_FAIL:
		pr("command failed\n");
		player->btused += cost;
		break;
	case RET_SYN:
		pr("Usage: %s\n", player_coms[cmd].c_form);
		break;
	default:
		logerror("%s: returned bad value", player_coms[cmd].c_form);
		break;
	}
	player->running--;
	return 0;
}
