#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/common/RCS/getvar.c,v 1.4 89/05/28 17:45:50 emp-src Exp $";
#endif

/*
 * getvar.c
 *
 * getvar/putvar/getvec just call the vl_get/set/getvec code.
 * Used for manipulating variable lists.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"

int
getvar(vtype, sp, ptype)
	int	vtype;
	s_char	*sp;
	int	ptype;
{
	u_char	*vtypep;
	u_short	*vamtp;
	u_char	*nvp;
	int	amt;

	if (ef_vars(ptype, sp, &nvp, &vtypep, &vamtp) < 0) {
		logerror("getvar: ptype %d has no vars", ptype);
		return 0;
	}
	amt = vl_find(vtype, vtypep, vamtp, (int) *nvp);
	if (amt < 0) {
		logerror("getvar: vl_find returns %d, vtype %d",
			amt, vtype);
		return 0;
	}
	return amt;
}

int
getvec(class, vec, sp, ptype)
	int	class;
	int	*vec;
	s_char	*sp;
	int	ptype;
{
	u_char	*vtypep;
	u_short	*vamtp;
	u_char	*nvp;
	int	nv;

	if (ef_vars(ptype, sp, &nvp, &vtypep, &vamtp) < 0) {
		logerror("getvec: ptype %d has no vars", ptype);
		return 0;
	}
	nv = vl_getvec(vtypep, vamtp, (int)*nvp, class, vec);
	if (nv < 0) {
		logerror("vl_getvec: returns %d, ptype %d\n",
			nv, ptype);
		return 0;
	}
	return nv;
}

int
putvar(vtype, amt, sp, ptype)
	int	vtype;
	int	amt;
	s_char	*sp;
	int	ptype;
{
	u_char	*vtypep;
	u_short	*vamtp;
	u_char	*nvp;
	int	maxv;

	if (vtype < 0 || vtype > V_MAX) {
		logerror("putvar: bad vtype %d\n", vtype);
		return 0;
	}
	if ((maxv = ef_vars(ptype, sp, &nvp, &vtypep, &vamtp)) < 0) {
		logerror("putvar: ptype %d has no vars", ptype);
		return 0;
	}
	if (amt < 0)
		amt = 0;
	return vl_set(vtype, (u_int)amt, vtypep, vamtp, nvp, maxv);
}

int
putvec(class, vec, sp, ptype)
	int	class;
	int	*vec;
	s_char	*sp;
	int	ptype;
{
	u_char	*vtypep;
	u_short	*vamtp;
	u_char	*nvp;
	int	maxv,x;

	if ((maxv = ef_vars(ptype, sp, &nvp, &vtypep, &vamtp)) < 0) {
		logerror("putvec: ptype %d has no vars", ptype);
		return 0;
	}
	for(x=0;x<I_MAX;x++)
		if (vec[x] < 0)
			vec[x] = 0;
	return vl_setvec(vtypep, vamtp, nvp, maxv, class, vec);
}
