#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/wipe.c,v 1.5 89/06/11 13:30:17 mr-frog Exp $";
#endif

/*
 * wipe.c
 *
 * clear all existing distribution thresholds
 *
 * Jim Griffith (griffith@scam.Berkeley.EDU) - 01-24-89
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "item.h"
#include "file.h"

int
wipe()
{
	struct	sctstr sect;
	struct	nstr_sect nstr;
	int	vec[I_MAX+1];

	if (!snxtsct(&nstr, player->argp[1]))
		return RET_SYN;
	bzero(vec, sizeof(vec));
	while (nxtsct(&nstr, &sect)) {
		if (!player->owner)
			continue;
		putvec(VT_DIST, vec, (s_char *)&sect, EF_SECTOR);
		pr("Distribution thresholds wiped from %s\n",
			xyas(nstr.x, nstr.y, player->cnum));
		putsect(&sect);
	}
	return RET_OK;
}
