#ifndef lint
static char *RCSid = "$Header: vers.c,v 1.11 89/09/28 01:36:38 mr-frog Exp $";
#endif /* not lint */

/*
 * vers.c
 *
 * empire version (probably out of date by now!)
 *
 * from PSL Empire, 1985
 */

#include <stdio.h>
#include <time.h>
#include "gamesdef.h"
#include "misc.h"
#include "player.h"
#include "deity.h"
#include "nat.h"
#include "version.h"
#include "ship.h" 

#ifdef DRNUKE
extern float drnuke_const;
#endif /* DRNUKE */

s_char	*options[] = {
#ifdef	SHOWPLANE
			"SHOWPLANE",
#endif	SHOWPLANE
#ifdef	ORBIT
			"ORBIT",
#endif	ORBIT
#ifdef	PINPOINTMISSILE
			"PINPOINTMISSILE",
#endif	PINPOINTMISSILE
#ifdef	FALLOUT
			"FALLOUT",
#endif	FALLOUT
#ifdef	SAIL
			"SAIL",
#endif	SAIL
#ifdef	NUKEFAILDETONATE
			"NUKEFAILDETONATE",
#endif	NUKEFAILDETONATE
#ifdef	MISSINGMISSILES
			"MISSINGMISSILES",
#endif	MISSINGMISSILES
#ifdef	SHIPNAMES
			"SHIPNAMES",
#endif	SHIPNAMES
#ifdef	NEUTRON
			"NEUTRON",
#endif	NEUTRON
#ifdef	SHIPINTER
			"SHIPINTER",
#endif	SHIPINTER
#ifdef	INCARRANGE
			"INCARRANGE",
#endif	INCARRANGE
#ifdef	DEMANDUPDATE
			"DEMANDUPDATE",
#endif	DEMANDUPDATE
#ifdef	UPDATESCHED
			"UPDATESCHEDULING",
#endif	UPDATESCHED
#ifdef  EASY_BRIDGES
                        "EASY_BRIDGES",
#endif  /* EASY_BRIDGES */
#ifdef  SUPER_BARS
                        "SUPER_BARS",
#endif  /* SUPER_BARS */
#ifdef  ALL_BLEED
                        "ALL_BLEED",
#endif  /* ALL_BLEED */
#ifdef  NEWPOWER
			"NEWPOWER",
#endif  /* NEWPOWER */ 
#ifdef  GRAB_THINGS
			"GRAB_THINGS",
#endif  /* GRAB_THINGS */ 
#ifdef  DRNUKE
                        "DRNUKE",
#endif  /* DRNUKE */
#ifdef	FUEL
			"FUEL",
#endif	/* FUEL */
#ifdef	NEW_STARVE
			"NEW_STARVE",
#endif	/* NEW_STARVE */
#ifdef	NEW_WORK
			"NEW_WORK",
#endif	/* NEW_WORK */
#ifdef NOMOBCOST
			"NOMOBCOST",
#endif	/* NOMOBCOST */
#ifdef	TRADESHIPS
			"TRADESHIPS",
#endif	/* TRADESHIPS */
#ifdef	RES_POP
			"RES_POP",
#endif	/* RES_POP */
#ifdef	NOFOOD
			"NOFOOD",
#endif	NOFOOD
#ifdef	NO_PLAGUE
			"NO_PLAGUE",
#endif	/* NO_PLAGUE */

#ifdef NONUKES
			"NONUKES",
#endif /* NONUKES */
#ifdef BETTERABM
			"BETTERABM",
#endif /* BETTERAMB */
#ifdef BLITZ
			"BLITZ",
#endif /* BLITZ */
#ifdef SLOW_WAR
			"SLOW_WAR",
#endif /* SLOW_WAR */
#ifdef SNEAK_ATTACK
			"SNEAK_ATTACK",
#endif /* SNEAK_ATTACK */

			NULL
		};

vers()
{
	extern	int s_p_etu;
	extern	int etu_per_update;
	extern	int adj_update;
	extern	int m_m_p_d;
	extern	int players_at_00;
	extern	float btu_build_rate;
	extern	double fgrate, fcrate;
	extern	double eatrate, babyeat;
	extern	double obrate, uwbrate;
	extern	double bankint;
	extern	double hap_cons, edu_cons;
	extern	double money_civ, money_uw, money_mil, money_res;
	extern	float hap_avg, edu_avg, ally_factor;
	extern	float level_age_rate;
/*	extern	float easy_tech, hard_tech, tech_log_base; */
	extern	float easy_tech, tech_log_base;
	extern	int land_mob_max;
	extern	int land_grow_scale;
	extern	float land_mob_scale;
	extern	int sect_mob_max;
	extern	float sect_mob_scale;
	extern	int ship_mob_max;
	extern	float ship_mob_scale;
	extern	int ship_grow_scale;
	extern	int plane_mob_max;
	extern	float plane_mob_scale;
	extern	int plane_grow_scale;
	extern  War_Cost;

	time_t	now;
	int	i,j;

	(void) time(&now);
	pr("BSD Empire %d.%d patch level %d (KSU distribution %2.2f, Chainsaw version %2.2f)\n\n",
		EMP_VERS_MAJOR, EMP_VERS_MINOR, EMP_VERS_PATCH,
		(float)KSU_DIST, (float)CHAINSAW_DIST);
	pr("The following parameters have been set for this game:\n");
	pr("World size is %d by %d.\n", WORLD_X, WORLD_Y);
	pr("There can be up to %d countries.\n", MAXNOC);
	pr("By default, countries use %s coordinate system.\n",
		(players_at_00) ? "the deity's" : "their own");
	pr("\n");
	pr("An Empire time unit is %d second%s long.\n",
		s_p_etu, s_p_etu != 1 ? "s" : "");
	pr("Use the 'update' command to find out the time of the next update.\n");
	pr("The current time is %19.19s.\n",ctime(&now));
	pr("An update consists of %d empire time units.\n",
		etu_per_update);
	pr("Each country is allowed to be logged in %d minutes a day.\n",
		m_m_p_d);
	pr("It takes %.2f civilians to produce a BTU in one time unit.\n",
		(1.0/(btu_build_rate*100.0)));
	pr("\n");

	pr("A non-aggi, 100 fertility sector can grow %.2f food per etu.\n",
		100.0 * fgrate);
	pr("1000 civilians will harvest %.1f food per etu.\n",
			1000.0*fcrate);
	pr("1000 civilians will give birth to %.1f babies per etu.\n", 
			1000.0*obrate);
	pr("1000 uncompensated workers will give birth to %.1f babies.\n", 
			1000.0*uwbrate);
#ifdef	NOFOOD
	pr("No food is needed!!\n");
#else
	pr("In one time unit, 1000 people eat %.1f units of food.\n", 
			1000.0*eatrate);
#endif	NOFOOD
	pr("1000 babies eat %.1f units of food becoming adults.\n", 
			1000.0*babyeat);
	pr("\n");

	pr("Banks pay $%.2f in interest per 1000 gold bars per etu.\n",
		bankint*1000.0);
	pr("1000 civilians generate $%.2f, uncompensated workers $%.2f each time unit.\n", 1000.0*money_civ, 1000.0*money_uw);
	pr("1000 active military cost $%.2f, reserves cost $%.2f.\n",
		-money_mil*1000.0, -money_res*1000.0);
#ifdef SLOW_WAR
	pr("Declaring war will cost you $%i\n\n",War_Cost);
#endif
	pr("Happiness p.e. requires 1 happy stroller per %d civ.\n",
		(int) hap_cons);
	pr("Education p.e. requires 1 class of graduates per %d civ.\n",
		(int) edu_cons);
	pr("Happiness is averaged over %d time units.\n", (int)hap_avg);
	pr("Education is averaged over %d time units.\n", (int)edu_avg);
#ifndef ALL_BLEED
	pr(
	"The technology/research boost you get from your allies is %.2f%%.\n",
		100.0/ally_factor);
#else
	pr(
	"The technology/research boost you get from the world is %.2f%%.\n",
		100.0/ally_factor);
#endif /* ALL_BLEED */
	pr("Nation levels (tech etc.) decline 1%% every %d time units.\n",
		(int)(level_age_rate));

	pr("Tech Buildup is ");
/*	if (tech_log_base <= 1.0 && hard_tech == 0.0) { */
	if (tech_log_base <= 1.0 ) {
		pr("not limited\n");
	} 
	if (tech_log_base > 1.0) {
		pr("limited to logarithmic growth (base %.2f)",
			tech_log_base);
		if (easy_tech == 0.0) 
			pr(".\n");
		else
			pr(" after %0.2f.\n", easy_tech);
	} /*else {
		pr("limited to asymptotic growth towards %.2f",
			hard_tech + easy_tech);
		if (easy_tech == 0.00) 
			pr(".\n");
		else
			pr("after %.2f\n",easy_tech);
	} */

	pr("\n");
	pr("\t\t\t\tSectors\tShips\tPlanes\tUnits\n");
	pr("Maximum mobility\t\t%d\t%d\t%d\t%d\n", sect_mob_max,
		ship_mob_max, plane_mob_max, land_mob_max);
	pr("Max mob gain per update\t\t%d\t%d\t%d\t%d\n",
		(int)(sect_mob_scale*(float)etu_per_update), 
		(int)(ship_mob_scale*(float)etu_per_update), 
		(int)(plane_mob_scale*(float)etu_per_update),
		(int)(land_mob_scale*(float)etu_per_update));
	pr("Max eff gain per update\t\t--\t%d\t%d\t%d\n",
		min(ship_grow_scale*etu_per_update,100),
		min(plane_grow_scale*etu_per_update,100),
		min(land_grow_scale*etu_per_update,100));
	pr("\n");
        pr("Ships on autonavigation may use %i cargo holds per ship.\n\n",TMAX
               );
#ifdef NONUKES
	pr("Nukes are disabled.\n");
#else
#ifdef DRNUKE
	pr("In order to build a nuke, you need %1.2f times the tech level in research\n", drnuke_const);
	pr("\tExample: In order to build a 300 tech nuke, you need %d research\n\n",(int)(300.0*drnuke_const));
#endif /* DRNUKE */
#endif /* NONUKES */

	pr("\nOptions enabled in this game:\n        ");
	for (i=0,j=0; options[i] != NULL; i++) {
		j += strlen(options[i]) + 2;
		if (j > 70) {
			pr("\n        ");
			j = strlen(options[i]) + 2;
		}
		pr("%s%s",options[i],(options[i+1] == NULL) ? "" : ", ");
	}
	pr("\n\n");
	pr("The person to annoy if something goes wrong is:\n\t%s\n\t(%s).\n",
		privname, privlog);
#ifndef aix
	pr("You can get your own copy of the source %s\n",GET_SOURCE);
#endif /* aix */
	return RET_OK;
}
