#ifndef lint
static char *RCSid = "$Header: cens.c,v 1.13 89/08/04 20:10:39 jeffw Exp $";
#endif /* not lint */

/*
 * stop.c
 *
 * stop a sector from producing
 *
 * --ts 1992
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "deity.h"
#include "path.h"
#include "file.h"
#include "product.h"

static stop_hdr();

stop()
{
	struct	sctstr sect;
	int	nsect;
	struct	nstr_sect nstr;

	if (!snxtsct(&nstr, player->argp[1]))
		return RET_SYN;
	prdate();
	nsect = 0;
	while (nxtsct(&nstr, &sect)) {
		if (!player->owner)
			continue;
		if (nsect++ == 0)
			stop_hdr();
		if (player->god)
			pr("%3d ", sect.sct_own);
		prxy("%4d,%-4d", nstr.x, nstr.y, player->cnum);
		pr(" %c", dchr[sect.sct_type].d_mnem);
		if (sect.sct_newtype != sect.sct_type)
			pr("%c", dchr[sect.sct_newtype].d_mnem);
		else
			pr(" ");
		pr("%4d%%", sect.sct_effic);

		pr(" will not produce or gain efficiency.\n");
		sect.sct_off = 1;
		putsect(&sect);
	}
	if (nsect == 0) {
		if (player->argp[1])
			pr("%s: No sector(s)\n", player->argp[1]);
		else
			pr("%s: No sector(s)\n", "");
		return RET_FAIL;
	}else
		pr("%d sector%s\n", nsect, splur(nsect));
	return 0;
}

static
stop_hdr()
{
	if (player->god)
		pr("    ");
	pr("PRODUCTION STOPPAGE\n");
	if (player->god)
		pr("own ");
	pr("  sect        eff\n");
}
