#ifndef lint
static char *RCSid = "$Header: /empire/empire/EMP/player/commands/rang.c 1.0 90/12/19 02:33:10 bailey Exp $";
#endif

/*
 * rang.c
 *
 * Edit effective range of a plane.
 * Edit reaction radius of a land unit.
 *
 * Jeff Bailey
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "plane.h"
#include "land.h"
#include "nsc.h"
#include "file.h"
#include "nat.h"
#include "deity.h"

range()
{
	struct nstr_item np;
	struct plnstr plane;
	int	i;
	s_char	*p;
	s_char	buf[1024];

	if (!snxtitem(&np, EF_PLANE, player->argp[1]))
		return RET_SYN;
	while (nxtitem(&np, (s_char *)&plane)) {
		if (!player->owner || plane.pln_own == 0)
			continue;
		p = getstarg(player->argp[2],"New range? ", buf);
		if ((i = atoi(p)) < 0)
			continue;
		plane.pln_range = (plane.pln_range_max < i) ?
			plane.pln_range_max : i;
		pr("Plane %d range changed to %d\n",plane.pln_uid,
			plane.pln_range);

		putplane(plane.pln_uid,&plane);
	}

	return RET_OK;
}

lrange()
{
	struct nstr_item np;
	struct lndstr land;
	struct lchrstr *lcp;
	int	i;
	s_char	*p;
	s_char	prompt[128];
	s_char	buf[128];

	if (!snxtitem(&np, EF_LAND, player->argp[1]))
		return RET_SYN;
	while (nxtitem(&np, (s_char *)&land)) {
		if (!player->owner || land.lnd_own == 0)
			continue;
		lcp = &lchr[land.lnd_type];
		sprintf(prompt, "New range for %s #%d? ",
			lcp->l_name, land.lnd_uid);
		if ((p = getstarg(player->argp[2], prompt, buf)) == 0)
			return RET_SYN;
		if ((i = atoi(p)) < 0)
			continue;
		land.lnd_rad_max = (i < lcp->l_rad) ?
			i : lcp->l_rad;
		pr("%s #%d reaction radius changed to %d\n",lcp->l_name,
			land.lnd_uid, land.lnd_rad_max);
		putland(land.lnd_uid,&land);
	}

	return RET_OK;
}
