#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/nuke.c,v 1.5 89/09/17 21:27:50 mr-frog Exp $";
#endif /* not lint */

/*
 * nuke.c
 *
 * combines fail, deto, and nuke report
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "nuke.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "deity.h"
#include "file.h"

int
nuke()
{
	register int first_line;
	register int i;
	struct	nstr_item nstr;
	struct	nukstr nuk;

	if (!snxtitem(&nstr, EF_NUKE, player->argp[1]))
		return RET_SYN;
	first_line = 0;
	while (nxtitem(&nstr, (s_char *)&nuk)) {
		if (!player->god && !player->owner)
			continue;
		if (nuk.nuk_own == 0)
			continue;
		if (first_line++ == 0) {
			if (player->god)
				pr("own");
			pr(" nuk  x, y\n");
		}
		if (player->god)
			pr("%-3d", nuk.nuk_own);
		pr(" %3d  %-7.7s\n", nstr.cur,
			xyas(nuk.nuk_x, nuk.nuk_y, player->cnum));
		for (i = 0; i < N_MAXNUKE; i++) {
			if (nuk.nuk_types[i] > 0) {
				pr("         %d  %s\n", nuk.nuk_types[i],
				       nchr[i].n_name);
			}
		}
	}
	return RET_OK;
}
