#ifndef lint
static char *RCSid = "$Header: load.c,v 1.15 90/03/19 11:09:53 mr-frog Exp $";
#endif /* not lint */

/*
 * load.c
 *
 * load (unload) goods from a sector onto a ship
 *
 * from PSL Empire, 1985
 *
 * hacked to allow planes/missiles to be loaded onto carriers/subs
 * by David Sharnoff 1987 
 * XXX needs to be told "plane" or commodity before amount.
 */

#include "misc.h"
#include "player.h"
#include "xy.h"
#include "file.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "plane.h"	
#include "land.h"	
#include "item.h"
#include "nsc.h"
#include "nat.h"

/*
 * The values 1 and -1 are important below, don't change them.
 */
#define	LOAD	1
#define	UNLOAD	-1

int
load()
{
	register struct ichrstr *ich;
	register int item;
	register int max_amt;
	register int move_amt;
	register int ship_amt;
	register int sect_amt;
	struct shpstr ship;
	struct sctstr sect;
	struct plnstr pln;	/* for nuke subs */
	struct lndstr land;	/* for nuke subs */
	int     load_unload;
	int     ship_num;
	int     amount;
	int     is_fleet=0,is_plane, is_land;
	struct nstr_item nbst;
	s_char	p[1024];
	s_char	i[1024];
        s_char  *temp;
	int	nships;
	struct natstr *np;
	int	rel, upto=0, abs_max;
	struct nstr_item pl;
	struct nstr_item ln;
	s_char	buf[1024];

	if (!(temp = getstarg(player->argp[1], "Ship(s): ", buf)))
		return RET_SYN;
        strcpy(p,temp);
	if (!snxtitem(&nbst, EF_SHIP, p))
		return RET_SYN;
	if (isalpha(*p))
		is_fleet=1;
	nbst.flags &= ~(EFF_OWNER);
	load_unload = **player->argp == 'l' ? LOAD : UNLOAD;
	temp = getstarg(player->argp[2], "Amount or plane/unit #: ", buf);
	if (temp == 0 || *temp == 0)
		return RET_SYN;
        strcpy(p,temp);
	amount = atoi(p);
	if (amount < 0) {	/* plane/unit 0 is a valid plane number */
		/* We want to load up to this amount */
		upto = -(amount);
		load_unload = LOAD;
	}
	temp = getstarg(player->argp[3],
		"What commodity (or 'plane' or 'land'): ", buf);
	if (temp == 0 || *temp == '\0')
		return RET_SYN;
	strcpy (i,temp);

	is_plane = !strncmp(i, "plane", 5);	/* XXX */
	is_land = !strncmp(i, "land", 4);	/* XXX */

	if ((!is_plane) && (!is_land)){
		ich = whatitem(i, (s_char *)0);
		if (ich == 0) {
			pr("Bad commodity.\n");
			return RET_SYN;
		}
		if (amount == 0) {
			pr("Amount must be non-zero!\n");
			return RET_SYN;
		}
	}

	nships = 0;
	while (nxtitem(&nbst, (s_char *)&ship)) {
		if (!ship.shp_own)
			continue;
		if (!player->owner && (load_unload == UNLOAD)) {
			continue;
		}
		if (ship.shp_own != player->cnum){
			if (is_fleet)
				continue;
			np=getnatp(player->cnum);
			rel=getrel(np,ship.shp_own);
			if (rel != ALLIED)
				continue;
		}
		ship_num = ship.shp_uid;
		if (!getsect(ship.shp_x, ship.shp_y, &sect)) /* XXX */
			continue;
		if ((sect.sct_own != player->cnum) && (ship.shp_own != player->cnum))
			continue;
		if (!player->owner && (sect.sct_type != SCT_HARBR))
			continue;
		if (!sect.sct_own)
			continue;
#ifdef	SHIPNAMES
		pr("\t%s %s(#%d) at %s\n", mchr[ship.shp_type].m_name,
			ship.shp_name, ship_num, xyas(ship.shp_x, ship.shp_y,
			player->cnum));
#else
		pr("\t%s #%d at %s\n", mchr[ship.shp_type].m_name,
			ship_num, xyas(ship.shp_x, ship.shp_y, player->cnum));
#endif	SHIPNAMES
		if ((sect.sct_own != player->cnum) && (load_unload == LOAD)) {
			pr("You don't own %s \n",
				xyas(ship.shp_x, ship.shp_y, player->cnum));
			continue;
		}
		if (sect.sct_type != SCT_HARBR) {
			pr("Sector %s is not a harbor.\n",
				xyas(ship.shp_x, ship.shp_y, player->cnum));
			continue;
		}
		if (sect.sct_effic < 2) {
			pr("The harbor at %s is not 2%% efficient yet.\n",
				xyas(ship.shp_x, ship.shp_y, player->cnum));
			continue;
		}
		if (is_plane) {
		        if (!snxtitem(&pl, EF_PLANE, p))
                		return RET_SYN;

			while(nxtitem(&pl, (s_char *)&pln)) {
			
                		if (pln.pln_own != player->cnum)
                        		continue;
                		if (!(plchr[pln.pln_type].pl_flags & P_L)
                		&&  !(plchr[pln.pln_type].pl_flags & P_E)
                		&&  !(plchr[pln.pln_type].pl_flags & P_K)
                		) {
                        		pr(
        	"You can only load light planes %s %s onto ships.\n"
                			,"or helos",
                			"or xtra-light planes"
                        		);
                        		continue;
                		}
                		if (load_unload == LOAD && pln.pln_ship > -1) {
                        		pr("Plane #%d is already on ship #%d!\n",
                                		pln.pln_uid, pln.pln_ship);
                        		continue;
	                	}
                		if (load_unload == LOAD && pln.pln_land > -1) {
                        		pr("Plane #%d is already on land unit #%d!\n",
                                		pln.pln_uid, pln.pln_land);
                        		continue;
	                	}
			/* Plane sanity done */
			/* Find the right ship */
			if (load_unload == UNLOAD) {
				if (pln.pln_ship != ship.shp_uid)
					continue;
			} else if (ship.shp_x != pln.pln_x
			    	|| ship.shp_y != pln.pln_y)
				continue;

			/* ship to (plane or missle) sanity */
			if (plchr[pln.pln_type].pl_flags & P_M) {
				if (!(mchr[ship.shp_type].m_flags &
					M_MSL)) {
#ifdef	SHIPNAMES
					pr("%s %s(#%d) cannot carry missles.\n",
						mchr[ship.shp_type].m_name,
						ship.shp_name,
#else
					pr("%s #%d cannot carry missles.\n",
						mchr[ship.shp_type].m_name,
#endif	SHIPNAMES
						ship.shp_uid);
					continue;
				}
			} else if (plchr[pln.pln_type].pl_flags & P_L) {
				if (!(mchr[ship.shp_type].m_flags & M_FLY)) {
#ifdef	SHIPNAMES
					pr("%s %s(#%d) cannot carry planes.\n",
						mchr[ship.shp_type].m_name,
						ship.shp_name,
#else
					pr("%s #%d cannot carry planes.\n",
						mchr[ship.shp_type].m_name,
#endif	SHIPNAMES
						ship.shp_uid);
					continue;
				}
			} /* else cannot happen */
			/* Fit plane on ship */
                        count_planes(&ship);
			if (load_unload == LOAD){
				if (!put_plane_on_ship(&pln,&ship)){
					pr("Can't put plane %d on this ship!\n",pln.pln_uid);
					continue;
				}
				sprintf(buf, "loaded on your ship #%d at %s",
					ship.shp_uid,xyas(ship.shp_x,
					ship.shp_y, ship.shp_own));
				gift(ship.shp_own, player->cnum, (s_char *)&pln,
					EF_PLANE, buf);
				pln.pln_own = ship.shp_own;
				pln.pln_mission = 0;
				putplane(pln.pln_uid,&pln);
			}else{
				if (!take_plane_off_ship(&pln,&ship)){
					pr("Unable to take plane off ship!\n");
					logerror("load: plane %d could not be taken off ship %d\n",pln.pln_uid,ship.shp_uid);
					continue;
				}
				sprintf(buf, "unloaded in your harbor at %s",
					xyas(sect.sct_x,sect.sct_y,
					sect.sct_own));
				gift(sect.sct_own, player->cnum, (s_char *)&pln,
					EF_PLANE, buf);
				pln.pln_own = sect.sct_own;
				putplane(pln.pln_uid,&pln);
			}
			pr("%s #%d %s ship #%d.\n",
				plchr[pln.pln_type].pl_flags & P_M ?
					"Missile" : "Plane",
				pln.pln_uid,
				(load_unload==UNLOAD)?
					"unloaded from":"loaded onto",
				ship.shp_uid,
				xyas(ship.shp_x, ship.shp_y, player->cnum));
			}
			return RET_OK;
		}
		if (is_land) {
		        if (!snxtitem(&ln, EF_LAND, p))
                		return RET_SYN;

			while(nxtitem(&ln, (s_char *)&land)) {
			
                		if (land.lnd_own != player->cnum)
                        		continue;

                		if (load_unload == LOAD && land.lnd_ship > -1) {
                        		pr("Unit #%d is already on ship #%d!\n",
                                		land.lnd_uid, land.lnd_ship);
                        		continue;
	                	}
			/* Unit sanity done */
			/* Find the right ship */
			if (load_unload == UNLOAD) {
				if (land.lnd_ship != ship.shp_uid)
					continue;
			} else if (ship.shp_x != land.lnd_x
			    	|| ship.shp_y != land.lnd_y)
				continue;

			if ((!(lchr[land.lnd_type].l_flags & L_LIGHT)) &&
				(!((mchr[ship.shp_type].m_flags & M_SUPPLY) &&
				(!(mchr[ship.shp_type].m_flags & M_SUB))))){
				pr("You can only load light units onto ships,\n");
				pr("unless the ship is a non-sub supply ship.\n");
				pr("%s #%d not loaded\n", lchr[land.lnd_type].l_name, land.lnd_uid);
				continue;
			}
			/* Fit unit on ship */
                        count_units(&ship);
                        getship(ship.shp_uid,&ship);
			if (load_unload == LOAD){
				struct plnstr pi;
				struct nstr_item ni;

				if (ship.shp_nland >= mchr[ship.shp_type].m_nland){
					pr("Can't put unit %d on this ship!\n",land.lnd_uid);
					continue;
				}
				sprintf(buf, "loaded on your ship #%d at %s",
					ship.shp_uid,xyas(ship.shp_x,ship.shp_y,
					ship.shp_own));
				gift(ship.shp_own,player->cnum,(s_char *)&land,
					EF_LAND, buf);
				land.lnd_own = ship.shp_own;
				land.lnd_ship = ship.shp_uid;
				land.lnd_harden = 0;
				land.lnd_mission = 0;
				ship.shp_nland++;
				putland(land.lnd_uid,&land);
				putship(ship.shp_uid,&ship);
				snxtitem_xy(&ni,EF_PLANE,land.lnd_x,land.lnd_y);
				while (nxtitem(&ni, (s_char *)&pi)){
					if (pi.pln_flags & PLN_LAUNCHED)
						continue;
					if (pi.pln_land != land.lnd_uid)
						continue;
					sprintf(buf, "loaded on ship #%d",
						ship.shp_uid);
					gift(ship.shp_own,player->cnum,(s_char *)&pi,
						EF_PLANE, buf);
					pi.pln_own = ship.shp_own;
					pi.pln_mission = 0;
					putplane(pi.pln_uid,&pi);
				}
			}else{
				struct plnstr pi;
				struct nstr_item ni;

				sprintf(buf, "unloaded in your harbor at %s",
					xyas(sect.sct_x,sect.sct_y,
					sect.sct_own));
				gift(sect.sct_own,player->cnum,(s_char *)&land,
					EF_LAND, buf);
				land.lnd_own = sect.sct_own;
				land.lnd_ship = (-1);
				ship.shp_nland--;
				putland(land.lnd_uid,&land);
				putship(ship.shp_uid,&ship);
				snxtitem_xy(&ni,EF_PLANE,land.lnd_x,land.lnd_y);
				while (nxtitem(&ni, (s_char *)&pi)){
					if (pi.pln_flags & PLN_LAUNCHED)
						continue;
					if (pi.pln_land != land.lnd_uid)
						continue;
					sprintf(buf, "unloaded at %s",
						xyas(pi.pln_x,pi.pln_y,
						sect.sct_own));
					gift(sect.sct_own,player->cnum,(s_char *)&pi,
						EF_PLANE, buf);
					pi.pln_own = sect.sct_own;
					pi.pln_mission = 0;
					putplane(pi.pln_uid,&pi);
				}
			}
			pr("%s #%d %s ship #%d.\n",
				lchr[land.lnd_type].l_name, land.lnd_uid,
				(load_unload==UNLOAD)?
					"unloaded from":"loaded onto",
				ship.shp_uid,
				xyas(ship.shp_x, ship.shp_y, player->cnum));
			}
			return RET_OK;
		}
		item = ich->i_vtype;
		ship_amt = getvar(item, (s_char *)&ship, EF_SHIP);
		sect_amt = getvar(item, (s_char *)&sect, EF_SECTOR);
		if (sect.sct_oldown != player->cnum && item == V_CIVIL) {
			pr("%s civilians refuse to %s at %s!\n",
				load_unload == UNLOAD ? "Your" : "Foreign",
				load_unload == UNLOAD ?
					"disembark" : "board",
				xyas(sect.sct_x, sect.sct_y, player->cnum));
			continue;
		}
		if (load_unload == UNLOAD) {
			abs_max = max_amt = min(999 - sect_amt, ship_amt);
		} else {
			struct mchrstr *vbase;
			vbase = &mchr[ship.shp_type];
			abs_max = max_amt = vl_find(item, vbase->m_vtype,
				vbase->m_vamt, (int) vbase->m_nv);
			max_amt = min(sect_amt, max_amt - ship_amt);
		}
		if ((max_amt <= 0) && (upto == 0))
			continue;
		if (upto){
			move_amt = upto - ship_amt;
			if (move_amt > sect_amt)
				move_amt = sect_amt;
			if (ship_amt+move_amt > abs_max)
				move_amt = abs_max - ship_amt;
		}else
			move_amt = load_unload * min(amount, max_amt);
		if (move_amt == 0)
			continue;
		putvar(item, sect_amt - move_amt, (s_char *)&sect, EF_SECTOR);
		putvar(item, ship_amt + move_amt, (s_char *)&ship, EF_SHIP);
		/* load/unload plague */
		if (getvar(V_PSTAGE, (s_char *)&sect, EF_SECTOR) == PLG_INFECT &&
		    getvar(V_PSTAGE, (s_char *)&ship, EF_SHIP) == PLG_HEALTHY)
			putvar(V_PSTAGE, PLG_EXPOSED, (s_char *)&ship, EF_SHIP);
		if (getvar(V_PSTAGE, (s_char *)&ship, EF_SHIP) == PLG_INFECT &&
		    getvar(V_PSTAGE, (s_char *)&sect, EF_SECTOR) == PLG_HEALTHY)
			putvar(V_PSTAGE, PLG_EXPOSED, (s_char *)&sect, EF_SECTOR);

		putsect(&sect);
		putship(ship_num, &ship);
		nships++;
	}
	if (nships == 0)
		pr("No ships affected\n");
	else
		pr("%d ship%s %sloaded\n", nships, splur(nships),
			load_unload == UNLOAD ? "un" : "");
	return RET_OK;
}

int
lload()
{
	register struct ichrstr *ich;
	register int item;
	register int max_amt;
	register int move_amt;
	register int land_amt;
	register int sect_amt;
	struct lndstr land;
	struct sctstr sect;
	struct plnstr pln;	/* for nuke subs */
	int     load_unload;
	int     land_num;
	int     amount;
	int     is_plane;
	struct nstr_item nbst;
	s_char	*p;
	s_char	*i;
	int	nunits;
	int	upto=0, abs_max;
	struct nstr_item pl;
	s_char	buf[1024];

	if (!(p = getstarg(player->argp[1], "Unit(s): ", buf)))
		return RET_SYN;
	if (!snxtitem(&nbst, EF_LAND, p))
		return RET_SYN;
	load_unload = *(*player->argp+1) == 'l' ? LOAD : UNLOAD;
	p = getstarg(player->argp[2], "Amount or plane #: ", buf);
	if (p == 0 || *p == 0)
		return RET_SYN;
	if (isalpha(*p))
		is_plane=1;
	else{
	amount = atoi(p);
	if (amount < 0) {	/* plane/unit 0 is a valid plane number */
		/* We want to load up to this amount */
		upto = -(amount);
		load_unload = LOAD;
	}
	}
	i = getstarg(player->argp[3], "What commodity ('plane' for a plane): ", buf);
	if (i == 0 || i[0] == '\0')
		return RET_SYN;
	is_plane = (is_plane == 1 ? 1 : !strncmp(i, "plane", 5));/* XXX */
	if (!is_plane) {
		ich = whatitem(i, (s_char *)0);
		if (ich == 0) {
			pr("Bad commodity.\n");
			return RET_SYN;
		}
		if (amount == 0) {
			pr("Amount must be non-zero\n");
			return RET_SYN;
		}
	}
	nunits = 0;
	while (nxtitem(&nbst, (s_char *)&land)) {
		if (!player->owner)
			continue;

		land_num = land.lnd_uid;

		pr("\t%s #%d at %s\n", lchr[land.lnd_type].l_name,
			land_num, xyas(land.lnd_x, land.lnd_y, player->cnum));

		if (!getsect(land.lnd_x, land.lnd_y, &sect)) /* XXX */
			continue;

		if (sect.sct_own != land.lnd_own) {
			pr("Sector %s is not yours.\n",
				xyas(land.lnd_x, land.lnd_y, player->cnum));
			continue;
		}

		if (is_plane) {
		        if (!snxtitem(&pl, EF_PLANE, p))
                		return RET_SYN;

			while(nxtitem(&pl, (s_char *)&pln)) {
			
                		if (pln.pln_own != player->cnum)
                        		continue;

                		if (!(plchr[pln.pln_type].pl_flags & P_E)) {
pr("You can only load xlight planes onto units.\n");
                        		continue;
                		}

                		if (load_unload == LOAD && pln.pln_ship > -1) {
                        		pr("Plane #%d is already on ship #%d!\n",
                                		pln.pln_uid, pln.pln_ship);
                        		continue;
	                	}
                		if (load_unload == LOAD && pln.pln_land > -1) {
                        		pr("Plane #%d is already on unit #%d!\n",
                                		pln.pln_uid, pln.pln_land);
                        		continue;
	                	}
			/* Plane sanity done */
			/* Find the right unit */
			if (load_unload == UNLOAD) {
				if (pln.pln_land != land.lnd_uid)
					continue;
			} else if (land.lnd_x != pln.pln_x
			    	|| land.lnd_y != pln.pln_y)
				continue;

			/* unit to (plane or missle) sanity */
			if (!(lchr[land.lnd_type].l_flags & L_XLIGHT)){
				pr("%s #%d cannot carry planes.\n",
					lchr[land.lnd_type].l_name,
						land.lnd_uid);
				continue;
				}
			/* Fit plane on unit */
                        count_land_planes(&land);
			if (load_unload == LOAD){
				if (!put_plane_on_land(&pln,&land)){
					pr("Can't put plane %d on this unit!\n",pln.pln_uid);
					continue;
				}
				sprintf(buf, "loaded on your unit #%d at %s",
					land.lnd_uid, xyas(land.lnd_x,
						land.lnd_y, land.lnd_own));
				gift(land.lnd_own,player->cnum,(s_char *)&pln,
					EF_PLANE, buf);
				pln.pln_own = land.lnd_own;
				putplane(pln.pln_uid,&pln);
			}else{
				if (!take_plane_off_land(&pln,&land)){
					pr("Unable to take plane off unit!\n");
					logerror("load: plane %d could not be taken off unit %d\n",pln.pln_uid,land.lnd_uid);
					continue;
				}
				sprintf(buf, "unloaded at your sector at %s",
					xyas(sect.sct_x,sect.sct_y,
					sect.sct_own));
				gift(sect.sct_own,player->cnum,(s_char *)&pln,
					EF_PLANE, buf);
				pln.pln_own = sect.sct_own;
				putplane(pln.pln_uid,&pln);
			}
			pr("%s #%d %s unit #%d.\n",
				plchr[pln.pln_type].pl_flags & P_M ?
					"Missile" : "Plane",
				pln.pln_uid,
				(load_unload==UNLOAD)?
					"unloaded from":"loaded onto",
				land.lnd_uid,
				xyas(land.lnd_x, land.lnd_y, player->cnum));
			}
			return RET_OK;
		}
		item = ich->i_vtype;
		land_amt = getvar(item, (s_char *)&land, EF_LAND);
		sect_amt = getvar(item, (s_char *)&sect, EF_SECTOR);
		if (sect.sct_oldown != player->cnum && item == V_CIVIL) {
			pr("%s civilians refuse to %s at %s!\n",
				load_unload == UNLOAD ? "Your" : "Foreign",
				load_unload == UNLOAD ?
					"disembark" : "board",
				xyas(sect.sct_x, sect.sct_y, player->cnum));
			continue;
		}
		if (load_unload == UNLOAD) {
			abs_max = max_amt = min(999 - sect_amt, land_amt);
		} else {
			struct lchrstr *vbase;
			vbase = &lchr[land.lnd_type];
			abs_max = max_amt = vl_find(item, vbase->l_vtype,
				vbase->l_vamt, (int) vbase->l_nv);
			max_amt = min(sect_amt, max_amt - land_amt);
		}
		if ((max_amt <= 0) && (upto == 0))
			continue;
		if (upto){
			move_amt = upto - land_amt;
			if (land_amt+move_amt > abs_max)
				move_amt = abs_max - land_amt;
			if (move_amt > sect_amt)
				move_amt = sect_amt;
		}else
			move_amt = load_unload * min(amount, max_amt);
		if (move_amt == 0)
			continue;
		putvar(item, sect_amt - move_amt, (s_char *)&sect, EF_SECTOR);
		putvar(item, land_amt + move_amt, (s_char *)&land, EF_LAND);
		/* load/unload plague */
		if (getvar(V_PSTAGE, (s_char *)&sect, EF_SECTOR) == PLG_INFECT &&
		    getvar(V_PSTAGE, (s_char *)&land, EF_LAND) == PLG_HEALTHY)
			putvar(V_PSTAGE, PLG_EXPOSED, (s_char *)&land, EF_LAND);
		if (getvar(V_PSTAGE, (s_char *)&land, EF_LAND) == PLG_INFECT &&
		    getvar(V_PSTAGE, (s_char *)&sect, EF_SECTOR) == PLG_HEALTHY)
			putvar(V_PSTAGE, PLG_EXPOSED, (s_char *)&sect, EF_SECTOR);

		putsect(&sect);
		putland(land_num, &land);
		nunits++;
	}
	if (nunits == 0)
		pr("No units affected\n");
	else
		pr("%d unit%s %sloaded\n", nunits, splur(nunits),
			load_unload == UNLOAD ? "un" : "");
	return RET_OK;
}

gift(givee, giver, ptr, type, mesg)
int   givee, giver;
s_char  *ptr;
int     type;
s_char  *mesg;
{
	struct	shpstr *sp = (struct shpstr *)ptr;
	struct	plnstr *pp = (struct plnstr *)ptr;
	struct	lndstr *lp = (struct lndstr *)ptr;
	struct	mchrstr *mcp;
	struct	plchrstr *pcp;
	struct	lchrstr *lcp;
	s_char	buf[80], line[256];

	if (giver == givee)
		return;

	bzero(buf,80);
	bzero(line,256);
	switch(type){
		case EF_SHIP:	mcp = &mchr[sp->shp_type];
				sprintf(buf,"%s #%d",mcp->m_name,sp->shp_uid);
				break;
		case EF_PLANE:	pcp = &plchr[pp->pln_type];
				sprintf(buf,"%s #%d",pcp->pl_name,pp->pln_uid);
				break;
		case EF_LAND:	lcp = &lchr[lp->lnd_type];
				sprintf(buf,"%s #%d",lcp->l_name,lp->lnd_uid);
				break;
	}

	sprintf(line,"%s %s %s\n",cname(giver),buf,mesg);
	wu(0,givee,line);
}

