#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/fort.c,v 1.10 89/07/02 21:03:38 mr-frog Exp $";
#endif /* not lint */

/*
 * fort.c
 *
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "land.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"

fort()
{
	int	nunits;
	struct	nstr_item ni;
	struct	lndstr land;
	int	fort_amt, hard_amt, mob_used;
	s_char	*p;
	extern	int land_mob_max;
	s_char	buf[1024];

	if (!snxtitem(&ni, EF_LAND, player->argp[1]))
		return RET_SYN;
	p = getstarg(player->argp[2], "Amount: ", buf);
	if (p == 0 || *p == 0)
		return RET_SYN;
	fort_amt = atoi(p);
	if (fort_amt<0)
		fort_amt=0;
	if (fort_amt>land_mob_max)
		fort_amt=land_mob_max;
	nunits = 0;
	while (nxtitem(&ni, (s_char *)&land)) {
		if (!player->owner || land.lnd_own == 0)
			continue;
		if (land.lnd_type < 0 || land.lnd_type > lnd_maxno) {
			pr("bad unit type %d (#%d)\n",
				land.lnd_type, ni.cur);
			continue;
		}

		getland(land.lnd_uid,&land);
		if (land.lnd_mobil < 0)
			continue;
		nunits++;

		hard_amt= min(land.lnd_mobil,fort_amt);

		if ((land.lnd_harden + hard_amt) > 127)
			hard_amt = 127 - land.lnd_harden;

		mob_used = hard_amt;

		if (is_engineer(land.lnd_x,land.lnd_y))
			hard_amt = ((float)hard_amt * 1.5);

		if ((land.lnd_harden + hard_amt) > 127)
			hard_amt = 127 - land.lnd_harden;

		land.lnd_mission = 0;
		land.lnd_mobil -= mob_used;
		if (land.lnd_mobil < 0)
			land.lnd_mobil = 0;

		land.lnd_harden += hard_amt;
		land.lnd_harden = min(land.lnd_harden,127);

		pr("%s #%d hardened to %d\n", lchr[land.lnd_type].l_name,
			land.lnd_uid, land.lnd_harden);

		putland(land.lnd_uid,&land);
	}
	if (nunits == 0) {
		if (player->argp[1])
			pr("%s: No unit(s)\n", player->argp[1]);
		else
			pr("%s: No unit(s)\n", "");
		return RET_FAIL;
	}else
		pr("%d unit%s\n", nunits, splur(nunits));
	return RET_OK;
}

is_engineer(x,y)
int	x,y;
{
	struct	nstr_item ni;
	struct	lndstr land;

	snxtitem_xy(&ni, EF_LAND, x,y);
	while(nxtitem(&ni, (s_char *)&land)){
		if (lchr[land.lnd_type].l_flags & L_ENGINEER)
			return 1;
	}

	return 0;
}
