#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/drop.c,v 1.5 89/09/18 00:02:40 mr-frog Exp $";
#endif

/*
 * drop.c
 *
 * air-drop commodities into a sector
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "item.h"
#include "plane.h"
#include "nuke.h"
#include "xy.h"
#include "nsc.h"
#include "news.h"
#include "file.h"
#include "nat.h"
#include "path.h"

drop()
{
	int 	rel;
	s_char	*p;
	int	mission_flags;
	int	tech;
	coord	tx, ty;
	coord	ax, ay;
	int	ap_to_target;
	struct	ichrstr *ip;
	s_char	flightpath[256];
	struct	nstr_item ni_bomb;
	struct	nstr_item ni_esc;
	coord	x, y;
	struct	sctstr target;
	struct	qelem bomb_list;
	struct	qelem esc_list;
	int	wantflags;
	struct	sctstr ap_sect;
	s_char	buf[1024];

	wantflags = 0;
	if (!snxtitem(&ni_bomb, EF_PLANE, player->argp[1]))
		return RET_SYN;
	if (!snxtitem(&ni_esc, EF_PLANE, player->argp[2]))
		pr("No escorts...\n");
	if ((p = getstarg(player->argp[3], "assembly point? ", buf)) == 0 || *p == 0)
		return RET_SYN;
	if (!sarg_xy(p, &x, &y) || !getsect(x, y, &ap_sect))
		return RET_SYN;
	if (ap_sect.sct_own && ap_sect.sct_own != player->cnum) {
		pr("Assembly point not owned by you!\n");
		return RET_SYN;
	}
	ax = x;
	ay = y;
	if (getpath(flightpath, player->argp[4], ax, ay, 0, 0,
	    0, P_FLYING) == 0 || *flightpath == 0)
		return RET_SYN;
	tx = ax;
	ty = ay;
	(void) pathtoxy(flightpath, &tx, &ty, fcost);
	pr("target is %s\n", xyas(tx, ty, player->cnum));
	getsect(tx, ty, &target);

	rel = getrel(getnatp(target.sct_own), player->cnum);
	if (rel != ALLIED && target.sct_own != player->cnum && target.sct_type != SCT_WATER) {
		pr("You don't own %s!\n", xyas(tx,ty,player->cnum));
		return RET_FAIL;
	}

	if ((ip = whatitem(player->argp[5], "Drop off what? ")) == 0)
		return RET_SYN;
	ap_to_target = strlen(flightpath);
	if (*(flightpath+strlen(flightpath)-1) == 'h')
		ap_to_target--;
	pr("range to target is %d\n", ap_to_target);
	/*
	 * select planes within range
	 */
	mission_flags = 0;
	pln_sel(&ni_bomb, &bomb_list, &ap_sect, ap_to_target,
		2, wantflags, P_M|P_O);
	pln_sel(&ni_esc, &esc_list, &ap_sect, ap_to_target,
		2, P_ESC|P_F, P_M|P_O);
	/*
	 * now arm and equip the bombers, transports, whatever.
	 * tech is stored in high 16 bits of mission_flags.
	 * yuck.
	 */
	tech=0;
	mission_flags |= P_X;		/* stealth (shhh) */
	mission_flags |= P_H; /* gets turned off if not all choppers */
	mission_flags |= P_MINE;
	mission_flags = pln_arm(&bomb_list, 'd', ip, 0, mission_flags,&tech);
        if (rel != ALLIED && target.sct_own != player->cnum &&
		target.sct_type == SCT_WATER && !(mission_flags & P_MINE)) {
                pr("You don't own %s!\n", xyas(tx,ty,player->cnum));
                return RET_FAIL;
        }
	if (QEMPTY(&bomb_list)) {
		pr("No planes could be equipped for the mission.\n");
		return RET_FAIL;
	}
	mission_flags = pln_arm(&esc_list, 'd', ip, P_ESC|P_F, mission_flags,&tech);
	ac_encounter(&bomb_list,&esc_list,ax,ay,flightpath,mission_flags,0);
	if (QEMPTY(&bomb_list)) {
		pr("No planes got through fighter defenses\n");
	} else {
		getsect(tx, ty, &target);
		pln_dropoff(&bomb_list, ip, tx, ty, (s_char *)&target,
			EF_SECTOR);
	}
	pln_put(&bomb_list);
	pln_put(&esc_list);
	return RET_OK;
}
