#ifndef lint
static char *RCSid = "$Header: assa.c,v 1.18 89/11/28 11:25:48 mr-frog Exp $";
#endif /* not lint */

/*
 * assa.c
 *
 * hit the beaches!
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "ship.h"
#include "land.h"
#include "sect.h"
#include "news.h"
#include "nat.h"
#include "file.h"
#include "xy.h"
#include "treaty.h"
#include "nsc.h"
#include "mission.h"

#define CASUALTY_LUMP	3	/* How big casualty chunks should be */

static	total_attack_strength(), total_defense_strength();
static	take_attacker_casualty(), take_defender_casualty();

assa()
{
	extern	double combat_mob;
	int	troops;
	int	a_engineer=0;
	struct	sctstr sect;
	struct	sctstr from;
	struct	shpstr ship;
	struct	lndstr land;
	s_char	*BestLandPath();
	coord	x, y;
	coord	shx, shy;
	int	shnu, lump = CASUALTY_LUMP;
	natid	own;
	int	mines;
	int	mcost;
	int	a_mil;
	int	s_mil;
	int	a_dead=0, a_bodies=0;
	int	s_dead=0, s_bodies=0;
	double	def, mobcost, loss_percentage, landunitgun();
	int	taken;
	double	odds;
	double	food;
	int	vec[I_MAX+1];
	int	pvec[I_MAX+1];
	int	svec[I_MAX+1];
	int	use_fort_support, use_ship_support;
	int	use_land_support, use_plane_support;
	s_char	*p;
	float	food_per_trooper;
	int	a_units=0;	/* number of attacking units */
	int	a_total=0;	/* total attacking strength */
	int	s_total=0;	/* total defending strength */
	int	s_spy=0, a_spy=0;
	int	dist, origx,origy,dam, radius;
	double	range, range2, asupport=1.0, ssupport=1.0;
	double	af=0.0,sf=0.0, as=0.0,ss=0.0, au=0.0,su=0.0, ap=0.0,sp=0.0;
	double	techfact();
	s_char	y_or_n[80];
	int	answer;
	struct	nstr_item ni;
	struct  qelem a_list, s_list, *next;
	struct	qelem *qp;
	struct	llist *llp;
	int	new;
        int     rel, rel2, issneak;
	s_char	prompt[128];
	s_char	buf[1024];
#ifdef SLOW_WAR
        struct natstr   *natp;
#endif /* SLOW_WAR */

	if (!(p = getstarg(player->argp[1], "Sector :  ", buf)) ||
	    !sarg_xy(p, &x, &y) || !getsect(x, y, &sect))
		return RET_SYN;
	if (player->aborted){
		pr("Assault aborted.\n");
		return RET_OK;
	}
	sprintf(prompt, "Assault sector %s from ship #",
		xyas(x,y,player->cnum));
	shnu = onearg(player->argp[2], prompt);
	if (shnu < 0) {
		pr("You may only assault from one ship!\n");
		return RET_SYN;
	}
	if (!getship(shnu, &ship) || ship.shp_own != player->cnum) {
		pr("Not your ship.\n");
		return RET_FAIL;
	}
	shx = ship.shp_x;
	shy = ship.shp_y;
	if (mapdist(shx, shy, x, y) > 1) {
		pr("You'll have to get there first...\n");
		return RET_FAIL;
	}
	own = sect.sct_own;
#ifdef SLOW_WAR
        natp = getnatp(player->cnum);
        issneak = rel = getrel(natp,own);

	if (issneak == ALLIED){
		sprintf(y_or_n,"Sector is owned by %s, your ally. Attack [yn]? ",cname(sect.sct_own));
		if (!confirm(y_or_n))
			return RET_FAIL;
	}

	if (own != player->cnum)
#ifdef SNEAK_ATTACK
        if ((issneak != AT_WAR) && (own) && (sect.sct_oldown != player->cnum) &&
	    (issneak != SITZKRIEG) && (issneak != MOBILIZATION)) {
		pr("You're not at war with them!\n");
		if (!confirm("Do you really want to sneak attack [yn]? ")){
			pr("Sneak attack cancelled!\n");
			return RET_FAIL;
		}
	}

	if (player->aborted){
		pr("Assault aborted.\n");
		return RET_OK;
	}


        if ((issneak != AT_WAR) && (own) && (sect.sct_oldown != player->cnum) &&
	    ((issneak == SITZKRIEG) || (issneak == MOBILIZATION))) {
#else
        if ((issneak != AT_WAR) && (own) && (sect.sct_oldown != player->cnum)){
#endif /* SNEAK_ATTACK */
                pr("You're not at war with them!\n");
                return RET_FAIL;
        }
#endif /* SLOW_WAR */
	if (sect.sct_type <= SCT_WASTE) {
		pr("Don't bother...\n");
		return RET_FAIL;
	}

	if ((x != shx || y != shy) &&
	    (!getsect(shx, shy, &from) || from.sct_type != SCT_WATER)) {
		pr("Your ship can not attack that far inland!\n");
		return RET_FAIL;
	}

	if (own && !trechk(player->cnum, own, LANATT))
		return RET_FAIL;

	if(!getsect(x, y, &sect))
		return RET_FAIL;

	getvec(VT_ITEM, svec, (s_char *)&sect, EF_SECTOR);
	s_mil = svec[I_MILIT];
	s_bodies = s_mil;
	pr("Sector %s is a %d%% %s with approx. %d military.\n",
		xyas(x, y, player->cnum), round((int)sect.sct_effic, 10),
		dchr[sect.sct_type].d_name,
		round(s_mil, 10));

	getvec(VT_ITEM, vec, (s_char *)&ship, EF_SHIP);
	a_mil = vec[I_MILIT];

	if (own != player->cnum){
	if (s_mil && !(mchr[ship.shp_type].m_flags & M_LAND))
		a_mil /= 10;
	if (s_mil && (mchr[ship.shp_type].m_flags & M_SEMILAND)){
		a_mil *= 10;
		a_mil /= 4;
	}
	}
	sprintf(prompt, "Number of troops in assault? (max %d) ", a_mil);
	if ((troops = onearg(player->argp[3], prompt)) < 0)
		return RET_FAIL;
	troops = min(troops, a_mil);
        troops = max(troops, 0);

	a_bodies += troops;

	if (!getship(shnu, &ship) || ship.shp_own != player->cnum) {
		pr("Your ship has been lost!\n");
		return RET_FAIL;
	}

	if(!getsect(x, y, &sect))
		return RET_FAIL;

	use_fort_support=use_ship_support=1;
	use_land_support=use_plane_support=1;
	if (player->argp[4] != (s_char *)0){
		if ((player->argp[5] == (s_char *)0) ||
		    (player->argp[6] == (s_char *)0) ||
		    (player->argp[7] == (s_char *)0)) {
			pr("If any support arguments are used, all must be!\n");
			return RET_SYN;
		}

		use_fort_support=use_ship_support=0;
		use_land_support=use_plane_support=0;

		if (!(p = getstarg(player->argp[4], "Use fort support? ", buf)))
			return RET_SYN;

		if ((*p == 'y') || (*p == 'Y'))
			use_fort_support = 1;

		if (!(p = getstarg(player->argp[5], "Use ship support? ", buf)))
			return RET_SYN;

		if ((*p == 'y') || (*p == 'Y'))
			use_ship_support = 1;

		if (!(p = getstarg(player->argp[6], "Use land support? ", buf)))
			return RET_SYN;

		if ((*p == 'y') || (*p == 'Y'))
			use_land_support = 1;

		if (!(p = getstarg(player->argp[7], "Use plane support? ", buf)))
			return RET_SYN;

		if ((*p == 'y') || (*p == 'Y'))
			use_plane_support = 1;
	}

	/*
	 * NOTE: need getcom here
	 */
	food = vec[I_FOOD];
	taken = (int) (food * troops / (vec[I_MILIT] + vec[I_CIVIL]) + 0.5);
	if ((taken == food) && taken)
		taken -= 1;
	vec[I_MILIT] -= troops;
	vec[I_FOOD] -= taken;
	putvec(VT_ITEM, vec, (s_char *)&ship, EF_SHIP);
	food_per_trooper = (float) taken / troops;

	initque(&a_list);
	initque(&s_list);

	snxtitem_xy(&ni,EF_LAND,ship.shp_x,ship.shp_y);
	while(nxtitem(&ni,(s_char *)&land)){
		if (!(lchr[land.lnd_type].l_flags & L_ASSAULT))
			continue;

		if (land.lnd_own != player->cnum)
			continue;

		if (land.lnd_ship != ship.shp_uid)
			continue;

		if (land.lnd_mobil < 0){
			pr("%s #%d is out of mobility, and cannot assault\n",
				lchr[land.lnd_type].l_name, land.lnd_uid);
			continue;
		}

		resupply_all(&land);
		putland(land.lnd_uid,&land);
		if (!has_supply(&land)){
			pr("%s #%d is out of supply, and cannot attack\n",
				lchr[land.lnd_type].l_name, land.lnd_uid);
			continue;
		}

		sprintf(y_or_n,
			"Assault with %s #%d (%d%%) on ship #%d, in %s [n]? ",
			lchr[land.lnd_type].l_name, land.lnd_uid,
			land.lnd_effic, land.lnd_ship,
			xyas(land.lnd_x,land.lnd_y,land.lnd_own));

		answer = confirm(y_or_n);

		if (player->aborted){
			pr("Assault aborted.\n");
			/* Free up all the lists */
			for(qp=a_list.q_forw;qp!=(&a_list);qp=next){
				next = qp->q_forw;
				llp = (struct llist *)qp;
				llp->land.lnd_ship = ship.shp_uid;
				putland(llp->land.lnd_own,&llp->land);
				free(qp);
			}
			return RET_OK;
		}

		if (answer){
			extern int etu_per_update;
			extern float land_mob_scale;

			a_units++;
			if (lchr[land.lnd_type].l_flags & L_ENGINEER)
				a_engineer = 1;
			llp = (struct llist *)
			malloc(sizeof(struct llist));
			bzero(llp,sizeof(struct llist));
			llp->state = LL_OK;
			llp->x = land.lnd_x;
			llp->y = land.lnd_y;
			llp->lcp = &lchr[land.lnd_type];
			land.lnd_ship = (-1);
			if (mchr[ship.shp_type].m_flags & M_LAND){
				if (llp->lcp->l_flags & L_MARINE)
					land.lnd_mobil -= ((float)etu_per_update						*land_mob_scale*0.5);
				else
					land.lnd_mobil -= ((float)etu_per_update
						*land_mob_scale);
			}else{
				if (llp->lcp->l_flags & L_MARINE)
					land.lnd_mobil = 0;
				else
					land.lnd_mobil = (((float)etu_per_update
						*land_mob_scale)*(-1));
			}
			ship.shp_nland--;
			putland(land.lnd_uid,&land);
			bcopy((s_char *)&land,(s_char *)&llp->land,
				sizeof(struct lndstr));
			insque(&llp->queue,&a_list);
			if (spyval(&land) > a_spy)
				a_spy = spyval(&land);
			a_bodies += total_mil(&land);
		}
	}

	if ((troops == 0) && (a_units == 0)){
		pr("No military or units in assault!\n");
		return RET_FAIL;
	}

	if (lump > a_bodies)
		lump = a_bodies;

	/* If there's going to be an actual battle */
	if (own != player->cnum){

	/*
	 *  Now, find all units actually in the sector.
	 *
	 */
	snxtitem_xy(&ni,EF_LAND,sect.sct_x,sect.sct_y);
	while(nxtitem(&ni,(s_char *)&land)){
		if (land.lnd_own == 0)
			continue;

		if (land.lnd_own != sect.sct_own)
			continue;

		llp = (struct llist *)
			malloc(sizeof(struct llist));

		bzero(llp,sizeof(struct llist));
		llp->state= (has_supply(&land) ? LL_OK : LL_UNSUPPLIED);
		llp->x = land.lnd_x;
		llp->y = land.lnd_y;
		llp->lcp = &lchr[land.lnd_type];
		putland(land.lnd_uid,&land);
		bcopy((s_char *)&land,(s_char *)&llp->land,
			sizeof(struct lndstr));
		insque(&llp->queue,&s_list);
		s_total += defense_val(&land);
		if (spyval(&land) > s_spy)
			s_spy = spyval(&land);

		intelligence_report(player->cnum,&land,a_spy,
			"Scouts report enemy unit:");
		s_bodies += total_mil(&land);
	}

	def = ((double)sect.sct_effic)/ 100.0;
        def = 2.0 + ((dchr[sect.sct_type].d_dstr - 2.0) * def);

	s_total = total_defense_strength(s_mil,&s_list,ssupport,def);
	a_total = total_attack_strength(troops,&a_list,asupport);
	pr("Total attack strength = %d\n", a_total);
	pr("Initial defense strength = %d\n", s_total);

	/*
 	 *
 	 * Now, get all defending units that react to the sector to
	 * defend. All units that are within their reaction radius and
	 * not damaged below their morale value can react to the
	 * threatened sect. Once we've sent enough to counter the
	 * threat, stop sending them.
 	 *
 	 */

	snxtitem_all(&ni,EF_LAND);
	while(nxtitem(&ni,(s_char *)&land) &&
		(s_total<(int)(1.2*(float)a_total))){
		struct	sctstr asect;
		int	supply_state;
		double	move_cost;

		if (land.lnd_own == 0)
			continue;

		if (land.lnd_ship >= 0)
			continue;

		if (land.lnd_rad_max == 0)
			continue;

		/*
		 *  if they're in the sect, we
		 *  have already included them.
		 */
		if ((land.lnd_x==sect.sct_x)&&(land.lnd_y==sect.sct_y))
			continue;

		if (land.lnd_own != sect.sct_own)
			continue;

		if (land.lnd_effic <= land.lnd_retreat)
			continue;
	
		if (defense_val(&land) == 0)
			continue;
	
		/* Only supplied units can react */
		if (!(supply_state=has_supply(&land)))
			continue;

		getsect(land.lnd_x,land.lnd_y,&asect);
		dist=mapdist(land.lnd_x,land.lnd_y,
			sect.sct_x,sect.sct_y);

		/* Units on efficient headquarters can react 1 farther */
		if ((asect.sct_type==SCT_HEADQ)&&(asect.sct_effic>=60))
			radius=land.lnd_rad_max+1;
		else
			radius=land.lnd_rad_max;

		if (land.lnd_mission == MI_RESERVE)
			radius += 2;
	
		if (dist>radius)
			continue;

		p = BestLandPath(buf, &asect,&sect,&move_cost);
		if (p == (s_char *)0)
			continue;

		mobcost = land.lnd_effic * 0.01*lchr[land.lnd_type].l_spd;
		mobcost = 480.0 / (mobcost + techfact(land.lnd_effic, mobcost));
		mobcost *= (move_cost * 5.0);

		if (land.lnd_mobil < mobcost)
			continue;

		/* move to defending sector */
		getland(land.lnd_uid,&land);
		land.lnd_mobil -= ((s_char)mobcost);
		origx = land.lnd_x;
		origy = land.lnd_y;
		land.lnd_x = sect.sct_x;
		land.lnd_y = sect.sct_y;
		wu(0,land. lnd_own, "%s #%d reacts to %s.\n",
			lchr[land.lnd_type].l_name, land.lnd_uid,
			xyas(land.lnd_x,land.lnd_y,land.lnd_own));
		putland(land.lnd_uid,&land);

		if ((land.lnd_x!=sect.sct_x)||(land.lnd_y!=sect.sct_y))
			continue;

		llp = (struct llist *)
			malloc(sizeof(struct llist));
		bzero(llp,sizeof(struct llist));
		llp->state = (supply_state ? LL_OK : LL_UNSUPPLIED);
		llp->x = origx;
		llp->y = origy;
		llp->lcp = &lchr[land.lnd_type];

		putland(land.lnd_uid,&land);
		bcopy((s_char *)&land,(s_char *)&llp->land,
			sizeof(struct lndstr));
		insque(&llp->queue,&s_list);
		s_total += defense_val(&land);
		if (spyval(&land) > s_spy)
			s_spy = spyval(&land);

		intelligence_report(player->cnum,&land,a_spy,
			"Scouts sight new enemy unit:");

		s_bodies += total_mil(&land);
	}

	for (qp = a_list.q_forw; qp != (&a_list); qp = qp->q_forw){
		llp = (struct llist *)qp;
		intelligence_report(sect.sct_own,&llp->land,s_spy,
			"Scouts report attacking unit:");
	}
	s_total = total_defense_strength(s_mil,&s_list,ssupport,def);
	a_total = total_attack_strength(troops,&a_list,asupport);
	pr("Total attack strength = %d\n", a_total);
	pr("Total defense strength = %d\n", s_total);

	} else a_total = 1;

	/* Shrink update collision window */
	getsect(sect.sct_x, sect.sct_y, &sect);
	getvec(VT_ITEM, svec, (s_char *)&sect, EF_SECTOR);
	s_mil = getvar(V_MILIT, (s_char *)&sect, EF_SECTOR);
	if (own != player->cnum){

	/*
	 * Calculate support
	 */

	if (use_fort_support){
		/* attacker's forts & such */
		dam = dd(sect.sct_own, player->cnum, landdef((int)sect.sct_type),
			sect.sct_x, sect.sct_y, 0, 0);
		af = ((double)dam)/100.0;
		asupport += af;
	}

	if (use_ship_support){
		dam = sd(sect.sct_own, player->cnum, landdef((int)sect.sct_type),
			sect.sct_x, sect.sct_y, 0, 0, 0);
		as = ((double)dam)/100.0;
		asupport += as;
	}

	if (use_land_support){
		/*
		 * Now find all artillery units belonging
		 * to the attacker that can fire.
		 * Each arty unit adds +1%/damage point
		 *
		 */
	
		snxtitem_all(&ni,EF_LAND);
		while(nxtitem(&ni,(s_char *)&land)){
			if ((land.lnd_x == sect.sct_x) &&
				(land.lnd_y == sect.sct_y))
				continue;

			if (lchr[land.lnd_type].l_frg == 0)
				continue;
	
			rel = getrel(getnatp(land.lnd_own),player->cnum);
			rel2 = getrel(getnatp(land.lnd_own),sect.sct_own);
			if ((land.lnd_own != player->cnum) &&
				((rel != ALLIED) || (rel2 != AT_WAR)))
				continue;
	
			/* do we have supplies? */
			if (!has_supply(&land))
				continue;
	
			/* are we in range? */
			dist=mapdist(land.lnd_x,land.lnd_y,sect.sct_x,
				sect.sct_y);

			range=techfact((int)land.lnd_tech,
				(double)lchr[land.lnd_type].l_frg);
			range2=roundrange(range);
			if (dist>range2)
				continue;

			use_supply(&land);
			nreport(land.lnd_own, N_FIRE_L_ATTACK, sect.sct_own, 1);
			if (roll(100) > lchr[land.lnd_type].l_acc){
				au += landunitgun(land.lnd_type,land.lnd_effic)/
					200.0;
			}else{
				au += landunitgun(land.lnd_type,land.lnd_effic)/
					100.0;
			}
			if (land.lnd_own != player->cnum)
				wu(0,land.lnd_own,
					"%s #%d supported %s at %s\n",
					lchr[land.lnd_type].l_name,land.lnd_uid,
					cname(player->cnum),xyas(sect.sct_x,sect.sct_y,
					land.lnd_own));
		}
		asupport += au;
	}

	if (use_plane_support){
		/* attacker's planes */
		dam = off_support(sect.sct_x,sect.sct_y,sect.sct_own,player->cnum);
		ap = (((double)dam)/100.0);
		asupport += ap;
	}

	pr("\t\tsupport values\n");
	pr("\t\tforts\tships\tunits\tplanes\n");
	pr("attacker\t%1.2f\t%1.2f\t%1.2f\t%1.2f\n",af,as,au,ap);

	if (sect.sct_own){
		wu(0,sect.sct_own,"\t\tsupport values\n");
		wu(0,sect.sct_own,"\t\tforts\tships\tunits\tplanes\n");
		wu(0,sect.sct_own,"attacker\t%1.2f\t%1.2f\t%1.2f\t%1.2f\n",
			af,as,au,ap);
	}

	s_total = total_defense_strength(s_mil,&s_list,ssupport,def);
	a_total = total_attack_strength(troops,&a_list,asupport);

	if (s_total < (int)(1.2*(float)a_total))
		dam = dd(player->cnum, sect.sct_own, landdef((int)sect.sct_type),
			sect.sct_x, sect.sct_y, 0, 1);
	else
		dam=0;

	sf = ((double)dam/100.0);
	ssupport += sf;
	s_total = total_defense_strength(s_mil,&s_list,ssupport,def);

	if (s_total < (int)(1.2*(float)a_total))
		dam = sd(player->cnum, sect.sct_own, landdef((int)sect.sct_type),
			sect.sct_x, sect.sct_y, 0, 1, 0);
	else
		dam=0;

	ss = ((double)dam/100.0);
	ssupport += ss;
	s_total = total_defense_strength(s_mil,&s_list,ssupport,def);

	snxtitem_all(&ni,EF_LAND);
	while(nxtitem(&ni,(s_char *)&land)){
		if (land.lnd_own == 0)
			continue;

		if (s_total >= (int)(1.2*(float)a_total))
			continue;

		rel = getrel(getnatp(land.lnd_own),sect.sct_own);
		rel2 = getrel(getnatp(land.lnd_own),player->cnum);
		if ((land.lnd_own != sect.sct_own) &&
			((rel != ALLIED) || (rel2 != AT_WAR)))
			continue;

		if (lchr[land.lnd_type].l_frg == 0)
			continue;

		/* do we have supplies? */
		if (!has_supply(&land))
			continue;

		/* are we in range? */
		dist=mapdist(land.lnd_x,land.lnd_y,sect.sct_x,sect.sct_y);
		range=techfact((int)land.lnd_tech,
			(double)lchr[land.lnd_type].l_frg);
		range2=roundrange(range);
		if (dist>range2)
			continue;

		use_supply(&land);
		nreport(land.lnd_own, N_FIRE_BACK, player->cnum, 1);
		if (roll(100) > lchr[land.lnd_type].l_acc){
			su += landunitgun(land.lnd_type,land.lnd_effic)/200.0;
			ssupport += landunitgun(land.lnd_type,land.lnd_effic)/200.0;
		}else{
			su += landunitgun(land.lnd_type,land.lnd_effic)/100.0;
			ssupport += landunitgun(land.lnd_type,land.lnd_effic)/100.0;
		}
		if (land.lnd_own != sect.sct_own)
			wu(0,land.lnd_own,"%s #%d supported %s at %s\n",
				lchr[land.lnd_type].l_name, land.lnd_uid,
				cname(sect.sct_own),
				xyas(sect.sct_x,sect.sct_y,land.lnd_own));
		s_total = total_defense_strength(s_mil,&s_list,ssupport,def);
	}

	if (sect.sct_oldown != player->cnum){
		mines = getvar(V_MINE, (s_char *)&sect, EF_SECTOR);
		mines = min(mines,20);
		if (a_engineer)
			mines = ldround(((double)mines/2.0),1);
		if (mines > 0){
			if (sect.sct_own)
				wu(0,sect.sct_own,"Defending mines add %1.2f\n",((double)mines)*0.02);
			pr("Defending mines add %1.2f\n",
				((double)mines)*0.02);
			ssupport += ((double)mines)*0.02;
			s_total = total_defense_strength(s_mil,&s_list,
				ssupport,def);
		}
	}

	/* defender's planes */
	if (s_total < (int)(1.2*(float)a_total))
		dam = def_support(sect.sct_x,sect.sct_y,player->cnum,sect.sct_own);
	else
		dam=0;

	sp = (((double)dam)/100.0);
	ssupport += sp;

	pr("defender\t%1.2f\t%1.2f\t%1.2f\t%1.2f\n\n",sf,ss,su,sp);
	if (sect.sct_own)
		wu(0,sect.sct_own,"defender\t%1.2f\t%1.2f\t%1.2f\t%1.2f\n\n",sf,ss,su,sp);

	s_total = total_defense_strength(s_mil,&s_list,ssupport,def);
	a_total = total_attack_strength(troops,&a_list,asupport);

	pr("Final attacker strength %d\n",a_total);
	pr("Final defender strength %d\n",s_total);

	odds = (double) a_total / (s_total + a_total);

	pr("Your success odds are %.1f%%\n", odds * 100.0);

	a_dead = s_dead = 0;
	while (s_total > 0) {
		if (a_total <= 0)
			break;
		if (chance(odds) == 0) {
			pr("@");
			a_dead += take_attacker_casualty(&troops,&a_list);
			a_total=total_attack_strength(troops,&a_list,asupport);
		} else {
			pr("!");
			s_dead += take_defender_casualty(&s_mil,&s_list,own);
			s_total=total_defense_strength(s_mil,&s_list,ssupport,
				def);
		}
	}
	if (own != 0)
		if(own != 0)
		wu(0, own,
#ifdef	SHIPNAMES
	        "%s (#%d) assaulted %s%s from %s %s(#%d); yours %d, theirs %d\n",
		    cname(player->cnum), player->cnum,
		    a_total>0 ? "(and took) " : " ",
		    xyas(x, y, own), mchr[ship.shp_type].m_name,
		    ship.shp_name, ship.shp_uid, s_dead, a_dead);
#else
	        "%s (#%d) assaulted %s%s from %s #%d; yours %d, theirs %d\n",
		    cname(player->cnum), player->cnum,
		    a_total>0 ? "(and took) " : " ",
		    xyas(x, y, own), mchr[ship.shp_type].m_name,
		    ship.shp_uid, s_dead, a_dead);
#endif	SHIPNAMES
	}
	if (a_total > 0) {
		if (own == player->cnum){
			if (troops > 0){
	pr("\nYou reinforce sector %s with %d troops\n",
					xyas(x,y,player->cnum), troops);
				svec[I_MILIT] += troops;
				if (troops > 0)
					svec[I_FOOD] += roundavg(troops*
						food_per_trooper);
			}
		}else{
#ifdef SNEAK_ATTACK
                if (issneak != AT_WAR && own && (sect.sct_oldown != player->cnum)) {
                        pr("Your sneak attack was successful\n");
                        pr("But it will cost you $5000\n");
                        pr("War has been declared!!!!\n");
                        wu(0,own, "Country %s (#%d) has Sneak Attacked!!\n",
                               cname(player->cnum), player->cnum); 
                        wu(0,own, "Country %s (#%d) has Declared WAR on you!!\n",
                               cname(player->cnum), player->cnum); 
                        player->dolcost += 5000;
                        issneak = MOBILIZATION;
                        nreport(player->cnum, N_DECL_WAR, own, 1);
                        setrel(player->cnum,own,issneak);
                }
#endif /* SNEAK_ATTACK */
		pr("\nYou have taken sector %s\n", xyas(x,y,player->cnum));
		nreport(player->cnum, N_WON_SECT, own, 1);
		troops = takeover(&sect, troops);
		sect.sct_mobil = 0;
		svec[I_MILIT] = troops;
		if (troops>0)
			svec[I_FOOD] += roundavg(troops * food_per_trooper);
		if (sect.sct_type == SCT_CAPIT || sect.sct_type == SCT_MOUNT)
			caploss(&sect, own,
				"which happens to be %s's capitol!\n");
		}
		for (qp=a_list.q_forw;qp!=(&a_list);qp=qp->q_forw){
			llp = (struct llist *)qp;
			llp->land.lnd_x = sect.sct_x;
			llp->land.lnd_y = sect.sct_y;
			pr("%s #%d lands at %s\n",
				llp->lcp->l_name,
				llp->land.lnd_uid,
				xyas(sect.sct_x,sect.sct_y,player->cnum));
			putland(llp->land.lnd_uid,&llp->land);
		}
	} else {
		if (own != player->cnum){
		pr("\nYou have been defeated!\n");
		nreport(player->cnum, N_SCT_LOSE, own, 1);
#ifdef SNEAK_ATTACK
                if (issneak != AT_WAR && own && (sect.sct_oldown != player->cnum)) {
                        pr("Your sneak attack was unsuccessful\n");
                        pr("And it will cost you $5000\n");
                        pr("War has been declared!!!!\n");
                        wu(0,own, "Country %s (#%d) has Sneak Attacked!!\n",
                               cname(player->cnum), player->cnum); 
                        wu(0,own, "Country %s (#%d) has Declared WAR on you!!\n",
                               cname(player->cnum), player->cnum); 
                        player->dolcost += 5000;
                        issneak = MOBILIZATION;
                        nreport(player->cnum, N_DECL_WAR, own, 1);
                        setrel(player->cnum,own,issneak);
                }
#endif /* SNEAK_ATTACK */
		svec[I_MILIT] = s_mil;
		/*
		 * Send reacting defenders who are still
		 * in good order back where they came from.
		 * The ones who retreated end up where they
		 * retreated to.
		 */
		for (qp=s_list.q_forw;qp!=(&s_list);qp=qp->q_forw){
                	llp = (struct llist *)qp;
                	if ((llp->state != LL_RETREATED) &&
				(llp->state != LL_DEAD)){
                        	if ((llp->land.lnd_x != llp->x) ||
                        		(llp->land.lnd_y != llp->y))
                        		wu(0,llp->land.lnd_own,
                                		"%s #%d returns to %s\n",
                                		llp->lcp->l_name,
						llp->land.lnd_uid,
                                		xyas(llp->x,llp->y,
						llp->land.lnd_own));
                        	llp->land.lnd_x = llp->x;
                        	llp->land.lnd_y = llp->y;
                        	putland(llp->land.lnd_uid,&llp->land);
                	}
        	}
		}
	}
	new = sect.sct_effic - (a_dead + s_dead)/10;
	new = (new < 0 ? 0 : new);
	sect.sct_effic = new;
	putvec(VT_ITEM, svec, (s_char *)&sect, EF_SECTOR);
	/* You've touched 'em -- give 'em plague if even you've lost! */
	getvec(VT_COND, vec, (s_char *)&ship, EF_SHIP);
	if (vec[C_PSTAGE] == PLG_INFECT) {
		getvec(VT_COND, pvec, (s_char *)&sect, EF_SECTOR);
		if (pvec[C_PSTAGE] == PLG_HEALTHY) {
			pvec[C_PSTAGE] = PLG_EXPOSED;
			putvec(VT_COND, pvec, (s_char *)&sect, EF_SECTOR);
		}
	}
	putsect(&sect);
	putship(shnu, &ship);
	if (own != player->cnum){
	pr("Casualties :\nYours... %3d\nTheirs.. %3d\n", a_dead, s_dead);
	player->btused += (int) ((s_dead + a_dead) * 0.015 + 0.5);
	}
	/* Deduct mobility from all units in battle, depending on losses */
	/* Mob cost is 10 * % losses. Defenders on reserve pay 1/2 */
	loss_percentage = ((double)a_dead)/((double)a_bodies);
	mcost = ldround((combat_mob * loss_percentage),1);
	for (qp=a_list.q_forw;qp!=(&a_list);qp=qp->q_forw){
		int	new;
		llp = (struct llist *)qp;
		if (llp->state == LL_DEAD)
			continue;
		if (chance(loss_percentage))
			use_supply(&llp->land);
		new = llp->land.lnd_mobil - mcost;
		if (new < -127)
			new = -127;
		llp->land.lnd_mobil = (s_char)new;
		putland(llp->land.lnd_uid,&llp->land);
	}
	loss_percentage = ((double)s_dead)/((double)s_bodies);
	mcost = ldround((combat_mob * loss_percentage),1);
	for (qp=s_list.q_forw;qp!=(&s_list);qp=qp->q_forw){
		int	new;
		llp = (struct llist *)qp;
		if (llp->state == LL_DEAD)
			continue;
		if (chance(loss_percentage))
			use_supply(&llp->land);
		if (land.lnd_mission == MI_RESERVE)
			new = llp->land.lnd_mobil - mcost/2;
		else
			new = llp->land.lnd_mobil - mcost;
		if (new < -127)
			new = -127;
		llp->land.lnd_mobil = (s_char)new;
		putland(llp->land.lnd_uid,&llp->land);
	}
	/* Free up all the lists */
	for(qp=a_list.q_forw;qp!=(&a_list);qp=next){
		next = qp->q_forw;
		free(qp);
	}
	for(qp=s_list.q_forw;qp!=(&s_list);qp=next){
		next = qp->q_forw;
		free(qp);
	}
	return RET_OK;
}

static
total_attack_strength(a_mil,a_list,asupport)
int		a_mil;
struct qelem	*a_list;
double		asupport;
{
	double	a_total;
	struct	qelem *qp;
	struct	llist *llp;

	a_total = a_mil;

	/*
	 * next, add in the attack_values of all
	 * the attacking non-retreated units
	 */

	for (qp = a_list->q_forw; qp != a_list; qp = qp->q_forw){
		llp = (struct llist *)qp;
		if (llp->state == LL_OK){
			if (llp->lcp->l_flags & L_MARINE)
				a_total += attack_val(&llp->land);
			else
				a_total += total_mil(&llp->land)/2;
		}
	}

	a_total *= asupport;

	return (int)a_total;
}

static
total_defense_strength(d_mil,d_list,dsupport,defval)
int		d_mil;
struct qelem	*d_list;
double		dsupport;
double		defval;
{
	double	d_total, d_unit;
	struct	qelem *qp;
	struct	llist *llp;

	d_total = d_mil;

	/*
	 * next, add in the defense_values of all
	 * the defending non-retreating units
	 */

	for (qp = d_list->q_forw; qp != d_list; qp = qp->q_forw){
		llp = (struct llist *)qp;
		d_unit = 0.0;
		if (llp->state == LL_OK)
			d_unit = defense_val(&llp->land);
		else if (llp->state == LL_UNSUPPLIED)
			d_unit = ((double)defense_val(&llp->land)/2.0);
		d_unit *= ((127.0+((double)llp->land.lnd_harden)) / 127.0);
		d_total += d_unit;
	}

	d_total *= defval;
	d_total *= dsupport;

	return (int)d_total;
}

static
take_attacker_casualty(a_mil,a_list)
int *a_mil;
struct qelem *a_list;
{
	int	to_take = CASUALTY_LUMP, cas;
	int	tot_troops, biggest_mil;
	struct	qelem *qp, *biggest;
	struct	llist *llp;

	tot_troops = (*a_mil);

	if (tot_troops)
		to_take -= tot_troops;

	if (to_take >= 0)
		(*a_mil) = 0;
	else{
		(*a_mil) -= CASUALTY_LUMP;
		return CASUALTY_LUMP;
	}

	if (QEMPTY(a_list))
		return (CASUALTY_LUMP - to_take);

	/*
	 *  Need to take some casualties from attacking units
	 *  Procedure: find the biggest unit remaining (in
	 *  terms of mil) and give it the casualties.
	 */
	biggest = (struct qelem *)0;
	biggest_mil = 0;
	for (qp = a_list->q_forw; qp != a_list; qp = qp->q_forw){
		llp = (struct llist *)qp;
		
		if ((llp->state == LL_RETREATED) || (llp->state == LL_DEAD))
			continue;

		if (total_mil(&llp->land) > biggest_mil){
			biggest_mil = total_mil(&llp->land);
			biggest = qp;
		}
	}
	if (biggest == (struct qelem *)0)
		return (CASUALTY_LUMP-to_take);

	llp = (struct llist *)biggest;
	llp->state = take_casualty(llp,to_take,llp->state,&cas,ASSAULTING,player->cnum);
	return (CASUALTY_LUMP-(to_take-cas));
}

static
take_defender_casualty(d_mil,d_list,down)
int *d_mil;
struct qelem *d_list;
natid down;
{
	int	to_take = CASUALTY_LUMP;
	int	biggest_mil, cas;
	struct	qelem *qp, *biggest;
	struct	llist *llp;

	if (*d_mil)
		to_take -= (*d_mil);
		
	if (to_take >= 0)
		(*d_mil) = 0;
	else{
		(*d_mil) -= CASUALTY_LUMP;
		return CASUALTY_LUMP;
	}

	if (QEMPTY(d_list))
		return (CASUALTY_LUMP - to_take);

	/*
	 *  Need to take some casualties from defending units
	 *  Procedure: find the biggest unit remaining (in
	 *  terms of mil) and give it the casualties.
	 */
	biggest = (struct qelem *)0;
	biggest_mil = 0;
	for (qp = d_list->q_forw; qp != d_list; qp = qp->q_forw){
		llp = (struct llist *)qp;
		
		if ((llp->state == LL_RETREATED) || (llp->state == LL_DEAD))
			continue;

		if (total_mil(&llp->land) > biggest_mil){
			biggest_mil = total_mil(&llp->land);
			biggest = qp;
		}
	}
	if (biggest == (struct qelem *)0)
		return (CASUALTY_LUMP-to_take);

	llp = (struct llist *)biggest;
	llp->state = take_casualty(llp,to_take,llp->state,&cas,0,down);
	return (CASUALTY_LUMP-(to_take-cas));
}
