/*
 * trade.h
 *
 * defs for "set/trade" commands
 *
 * from PSL Empire, 1985
 * $Revision: 1.6 $ $Date: 89/09/03 16:52:10 $
 */

struct trdstr {
	s_char	trd_type;
	natid	trd_owner;
	short	trd_unitid;
	long	trd_price;
};

struct genstr {
	coord	trg_x;
	coord	trg_y;
	natid	trg_own;
};

union trdgenstr {
	struct	genstr gen;
	struct	nukstr nuk;
	struct	plnstr pln;
	struct	lndstr lnd;
	struct	shpstr shp;
};

s_char	*trade_nameof();

#define gettrade(n, p) \
	ef_read(EF_TRADE, n, (caddr_t)p)
#define puttrade(n, p) \
	ef_write(EF_TRADE, n, (caddr_t)p)
#define gettradep(n) \
	(struct trdstr *) ef_ptr(EF_TRADE, n)
