#ifndef lint
static char *RCSid = "$Header: randpop.c,v 1.6 90/04/13 12:28:42 mr-frog Exp $";
#endif

#include "misc.h"
#include "nat.h"
#include "sect.h"
#include "var.h"
#include "file.h"

#include <fcntl.h>

int	valid_nats[MAXNOC];
int	nvalid;

char	*program = "randpop";
int	(*leprfunc)();

main()
{
	struct	sctstr *sp;
	struct	natstr *np;
	int	i;
	long	now;
	int	j;
	int	vamt;
	int	vtype;

	time(&now);
	srandom(now);
	ef_open(EF_SECTOR, O_RDWR, EFF_MEM);
	ef_open(EF_NATION, 0, EFF_MEM);
	for (i=0; np = getnatp(i); i++) {
		if (np->nat_stat & STAT_INUSE)
			valid_nats[nvalid++] = i;
	}
	if (nvalid <= 0) {
		printf("No valid nations\n");
		exit(1);
	}
	for (i=0; sp = getsectid(i); i++) {
		if (sp->sct_type == SCT_WATER)
			continue;
		sp->sct_own = valid_nats[random() % nvalid];
		sp->sct_type = 5 + (random() % (SCT_MAXDEF-5));
		sp->sct_effic = random() % 100;
		sp->sct_mobil = random() % 127;
		if (chance(0.10))
			sp->sct_loyal = random() % 100;
		else
			sp->sct_loyal = 0;
		sp->sct_distpath = 0;
		sp->sct_work = random() % 100;
		if ((random() % 10) == 0)
			sp->sct_newtype = 5 + (random() % (SCT_MAXDEF-5));
		else
			sp->sct_newtype = sp->sct_type;
		putvar(V_CIVIL, random() % 300 + 80, sp, EF_SECTOR);
		putvar(V_MILIT, random() % 100 + 20, sp, EF_SECTOR);
		putvar(V_UW, random() % 250, sp, EF_SECTOR);
		putvar(V_FOOD, random() % 800, sp, EF_SECTOR);
		/* item */
		for (j=random() % 4; j >= 0; j--) {
			vtype = V_ITEM(random() % (I_MAX+1));
			vamt = random() % 500 + 100;
			putvar(vtype, vamt, sp, EF_SECTOR);
		}
		/* del */
		for (j=random() % 4; j >= 0; j--) {
			vtype = V_DEL(random() % (I_MAX+1));
			vamt = ((random() % 80 + 50) << 3) | (random() % 7);
			putvar(vtype, vamt, sp, EF_SECTOR);
		}
		if ((random() % 40) == 0) {
			vamt = 5 + (random() % 30) | (sp->sct_own << 8);
			putvar(V_CHE, vamt, sp, EF_SECTOR);
		}
		if ((random() % 30) == 0) {
			putvar(V_PTIME, random() % 30, sp, EF_SECTOR);
			putvar(V_PSTAGE, random() % 4, sp, EF_SECTOR);
		}
	}
	ef_close(EF_SECTOR);
	return 0;
}
