#ifndef lint
static char *RCSid = "$Header: /SRX/empire/EMP/player/commands/reje.c 1.0 90/03/17 10:08:15 bailey Exp $";
#endif /* not lint */

/*
 * reje.c
 *
 * Refuse to accept either telegrams or treaties from individual
 * countries. Adapted from decl.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "news.h"
#include "file.h"

#ifdef	REJECTS

reje()
{
	extern	char *argp[];
	register char *p;
	struct	natstr	*natp;
	int	rel;
	int	oldrel;
	int	n;
	natid	with;
	int	do_undo;

	natp = getnatp(cnum);
	p = getstarg(argp[1], "reject or accept? ");
	switch (*p) {
	case 'r':
		do_undo = 1;
		break;
	case 'a':
		do_undo = 0;
		break;
	default:
		pr("That's not one of the choices!\n");
		return RET_SYN;
	}
	p = getstarg(argp[2], "mail, treaties, or announcements? ");
	switch (*p) {
	case 'a':
		rel = REJ_ANNO;
		break;
	case 'm':
		rel = REJ_TELE;
		break;
	case 't':
		rel = REJ_TREA;
		break;
	default:
		pr("That's not one of the choices!\n");
		return RET_SYN;
	}
	if ((n = natarg(argp[3], "with which country? ")) < 0)
		return RET_SYN;
	with = n;
	setrej(cnum, with, do_undo, rel);
	return RET_OK;
}
#endif	REJECTS
