#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/SUBS/RCS/landgun.c,v 1.1 89/05/17 20:51:58 mr-frog Exp $";
#endif

/*
 * landgun.c
 *
 * return values for land and ship gun firing damages
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "ship.h"
#include "land.h"
#include "sect.h"

double
landgun(effic, guns)
int	effic, guns;
{
	int	g = (double)min(guns,7), d;

	d = ((random() % 30) + 20.0)*(g/7.0);
	d *= ((double)effic);
	d /= 100.0;
	return d;
}

double
seagun(effic, n)
int	effic;
int	n;
{
	double	dam=0.0;

	while(n--)
		dam += 10 + random() % 6;
	dam *= ((double)effic)*0.01;
	return dam;
}

double
landunitgun(type, effic)
int	type;
int	effic;
{
	register int x=lchr[type].l_dam, dam=0;

	while(x--)
		dam += (random() % 6);
	return ((double)dam * 0.01 * (double)effic);
}


int
landdef(type)
int	type;
{
	if (type == SCT_BANK)
		return 320;
	return 160;
}

int
seadef(type)
	int	type;
{
	return mchr[type].m_armor;
}

int
landunitdef(type)
	int	type;
{
	return 320/lchr[type].l_vul;
}


int
shelldam(dam, ac)
	double	dam;
	int	ac;
{
	return (int) ((dam * 100.0) / (ac + dam + 1.0));
}


int
roundrange(r)
	double r;
{
	double f;

	f=r-((int)r);
	if (chance(f))
		return(((int)r)+1);
	else
		return((int)r);
}
