#ifndef lint
static char *RCSid = "$Header: wai.c,v 1.6 90/03/19 11:00:17 mr-frog Exp $";
#endif /* not lint */

/*
 * wai.c
 *
 * continuously wait for telegrams & announcements; print them out when
 * you get them.
 *
 */

#include "misc.h"
#include "nat.h"
#include "tel.h"
#include "file.h"
#include "io.h"

#include <fcntl.h>

wai()
{
	extern	s_char *argp[];
	extern	int aborted;
	extern	iop_t iop, playerio;
	struct	natstr *np;
	s_char	buf[128];

	np = getnatp(cnum);
	io_flush();
#ifdef WIRE
	while ((np->nat_tgms == 0) && (np->nat_ann == 0)) {
		if (io_select(0) <= 0)
			return RET_FAIL;
		if (aborted || io_eof(playerio) || io_eof(iop) ||
		    io_read(playerio, buf, sizeof(buf)) > 0) {
			return RET_OK;
		}
	}
	if (np->nat_ann != 0)
		argp[0] = "wire";
	if (np->nat_tgms != 0)
		argp[0] = "read";
	return rea();
#else
	while (np->nat_tgms == 0) {
		if (io_select(0) <= 0)
			return RET_FAIL;
		if (aborted || io_eof(playerio) || io_eof(iop) ||
		    io_read(playerio, buf, sizeof(buf)) > 0) {
			return RET_OK;
		}
	}
	argp[0] = "read";
	return rea();
#endif /* WIRE */
}
