#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/terr.c,v 1.3 89/08/15 17:44:30 jeffw Exp $";
#endif

/*
 * terr.c
 *
 * designate territory of sectors
 *
 * Edward M. Rynes Esq.
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "file.h"

terr()
{
	extern s_char *argp[];
	struct	sctstr sect;
	s_char   *p;
	int     terr_n;
	struct	nstr_sect nstr;

	if (!snxtsct(&nstr, argp[1]))
		return RET_SYN;
	while (nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
		p = fmt("%s %d%% %s  territory? ", 
	 		xyas(nstr.x, nstr.y, cnum),
                	sect.sct_effic, dchr[sect.sct_type].d_name);
		p = getstarg(argp[2], p);
		if (*p == 0)
			continue;
		terr_n = atoi(p);
		while (terr_n < 0 || terr_n > 99 || *p < '0' || *p > '9') {
			pr("Enter a number between 0 and 99!\n");
			p = fmt("%s %d%% %s  territory? ", 
				xyas(nstr.x, nstr.y, cnum),
				sect.sct_effic, dchr[sect.sct_type].d_name);
			p = getstarg((s_char *)0, p);
			if (*p == 0)
				break;
			terr_n = atoi(p);
		}
		if (*p == 0)
			continue;
		sect.sct_terr = terr_n;
		putsect(&sect);
	}

	return RET_OK;
}
