#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/shi.c,v 1.10 89/07/02 21:03:38 mr-frog Exp $";
#endif /* not lint */

/*
 * retr.c
 *
 */

#include "options.h"
#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "retreat.h"
#include "ship.h"
#include "land.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"
#include "path.h"

#ifdef RETREAT
retr()
{
	extern	s_char *argp[];
	s_char	*pq, *fl;
	int	nships;
	struct	nstr_item ni;
	struct	shpstr ship;
	int	isfleet=0, rflags=(-2),x, zero;

	if (!snxtitem(&ni, EF_SHIP, argp[1]))
		return RET_SYN;
	nships = 0;

	if (argp[1] != (s_char *)0)
		if (isalpha(argp[1][0]))
			isfleet=1;

	if (argp[2] != (s_char *)0)
		pq = getstarg(argp[2], "Retreat path? ");
	else
		pq = (s_char *)0;

	if (pq != (s_char *)0){
		fl = getstarg(argp[3], "Retreat conditions [i|t|s|h|b|d|c]? ");
		rflags=0|isfleet;

		for(x=0;x<strlen(fl);x++)
			switch(*(fl+x)){
				case 'I':
				case 'i': rflags |= RET_INJURED ; break;
				case 'T':
				case 't': rflags |= RET_TORPED ; break;
				case 'S':
				case 's': rflags |= RET_SONARED ; break;
				case 'H':
				case 'h': rflags |= RET_HELPLESS ; break;
				case 'B':
				case 'b': rflags |= RET_BOMBED ; break;
				case 'D':
				case 'd': rflags |= RET_DCHRGED ; break;
				case 'U':
				case 'u': rflags |= RET_BOARDED ; break;
				case 'C':
				case 'c': rflags = -1; break;
				default:  pr(fmt("bad condition\n"));
				case '?': pr(fmt("i\tretreat when injured\n"));
					  pr(fmt("t\tretreat when torped\n"));
					  pr(fmt("s\tretreat when sonared\n"));
					  pr(fmt("h\tretreat when helpless\n"));
					  pr(fmt("b\tretreat when bombed\n"));
					  pr(fmt("d\tretreat when depth-charged\n"));
					  pr(fmt("u\tretreat when boarded\n"));
			}
		if (rflags == isfleet){
			pr("Must give retreat conditions!\n");
			return RET_FAIL;
		}
	}

	if (rflags == -1)
		pq = (s_char *)0;

	zero = (rflags == -1);
	if (zero)
		rflags = 0;

	while (nxtitem(&ni, (s_char *)&ship)) {
		if (!owner || ship.shp_own == 0)
			continue;
		if (ship.shp_type < 0 || ship.shp_type > shp_maxno) {
			pr(fmt("bad ship type %d (#%d)\n",
				ship.shp_type, ni.cur));
			continue;
		}
		if (zero)
			bzero(ship.shp_rpath,RET_LEN);

		if (pq != (s_char *)0){
			bzero(ship.shp_rpath,RET_LEN);
			bcopy(pq,ship.shp_rpath,strlen(pq));
			putship(ship.shp_uid,&ship);
		}
		if (rflags >= 0){	
			ship.shp_rflags = rflags;
			putship(ship.shp_uid,&ship);
		}
		if (nships++ == 0) {
			if (god)
				pr("own ");
				pr("shp#     ship type       x,y   fl path       as flt? flags\n");
		}
		if (god)
			pr(fmt("%3d ", ship.shp_own));
		pr(fmt("%4d ", ni.cur));
		pr(fmt("%-16.16s ", mchr[ship.shp_type].m_name));
		pr(fmt("%s ", xyfmt("%4d,%-4d", ship.shp_x,
			ship.shp_y, cnum)));
		pr(fmt("%1c", ship.shp_fleet));
		pr(fmt(" %-11s", ship.shp_rpath));
		if (ship.shp_rflags & RET_GROUP)
			pr("Yes     ");
		else
			pr("        ");
		if (ship.shp_rflags & RET_INJURED)
			pr("I");
		if (ship.shp_rflags & RET_TORPED)
			pr("T");
		if (ship.shp_rflags & RET_SONARED)
			pr("S");
		if (ship.shp_rflags & RET_HELPLESS)
			pr("H");
		if (ship.shp_rflags & RET_BOMBED)
			pr("B");
		if (ship.shp_rflags & RET_DCHRGED)
			pr("D");
		if (ship.shp_rflags & RET_BOARDED)
			pr("U");
		pr("\n");
	}
	if (nships == 0) {
		if (argp[1])
			pr(fmt("%s: No ship(s)\n", argp[1]));
		else
			pr(fmt("%s: No ship(s)\n", ""));
		return RET_FAIL;
	}else
		pr(fmt("%d ship%s\n", nships, splur(nships)));
	return RET_OK;
}

lretr()
{
	extern	s_char *argp[];
	s_char	*pq, *fl;
	int	nunits;
	struct	nstr_item ni;
	struct	lndstr land;
	int	isarmy=0, rflags=(-2),x, zero;

	if (!snxtitem(&ni, EF_LAND, argp[1]))
		return RET_SYN;

	nunits = 0;

	if (argp[1] != (s_char *)0)
		if (isalpha(argp[1][0]))
			isarmy=1;

	if (argp[2] != (s_char *)0)
		pq = getstarg(argp[2], "Retreat path? ");
	else
		pq = (s_char *)0;

	if (pq != (s_char *)0){
		fl = getstarg(argp[3], "Retreat conditions [i|h|b|c]? ");
		rflags=0|isarmy;

		for(x=0;x<strlen(fl);x++)
			switch(*(fl+x)){
				case 'I':
				case 'i': rflags |= RET_INJURED ; break;
				case 'H':
				case 'h': rflags |= RET_HELPLESS ; break;
				case 'B':
				case 'b': rflags |= RET_BOMBED ; break;
				case 'C':
				case 'c': rflags = -1; break;
				default:  pr(fmt("bad condition\n"));
				case '?': pr(fmt("i\tretreat when injured\n"));
					  pr(fmt("h\tretreat when helpless\n"));
					  pr(fmt("b\tretreat when bombed\n"));
			}
		if (rflags == isarmy){
			pr("Must give retreat conditions!\n");
			return RET_FAIL;
		}
	}

	if (rflags == -1)
		pq = (s_char *)0;

	zero = (rflags == -1);
	if (zero)
		rflags = 0;

	while (nxtitem(&ni, (s_char *)&land)) {
		if (!owner || land.lnd_own == 0)
			continue;
		if (land.lnd_type < 0 || land.lnd_type > lnd_maxno) {
			pr(fmt("bad unit type %d (#%d)\n",
				land.lnd_type, ni.cur));
			continue;
		}
		if (zero)
			bzero(land.lnd_rpath,RET_LEN);

		if (pq != (s_char *)0){
			bzero(land.lnd_rpath,RET_LEN);
			bcopy(pq,land.lnd_rpath,strlen(pq));
			putland(land.lnd_uid,&land);
		}
		if (rflags >= 0){	
			land.lnd_rflags = rflags;
			putland(land.lnd_uid,&land);
		}

		if (nunits++ == 0) {
			if (god)
				pr("own ");
				pr("lnd#     unit type       x,y   ar path       as army? flags\n");
		}
		if (god)
			pr(fmt("%3d ", land.lnd_own));
		pr(fmt("%4d ", ni.cur));
		pr(fmt("%-16.16s ", lchr[land.lnd_type].l_name));
		pr(fmt("%s ", xyfmt("%4d,%-4d", land.lnd_x,
			land.lnd_y, cnum)));
		pr(fmt("%1c", land.lnd_army));
		pr(fmt(" %-11s", land.lnd_rpath));
		if (land.lnd_rflags & RET_GROUP)
			pr("Yes      ");
		else
			pr("         ");
		if (land.lnd_rflags & RET_INJURED)
			pr("I");
		if (land.lnd_rflags & RET_TORPED)
			pr("T");
		if (land.lnd_rflags & RET_SONARED)
			pr("S");
		if (land.lnd_rflags & RET_HELPLESS)
			pr("H");
		if (land.lnd_rflags & RET_BOMBED)
			pr("B");
		if (land.lnd_rflags & RET_DCHRGED)
			pr("D");
		if (land.lnd_rflags & RET_BOARDED)
			pr("U");
		pr("\n");
	}
	if (nunits == 0) {
		if (argp[1])
			pr(fmt("%s: No unit(s)\n", argp[1]));
		else
			pr(fmt("%s: No unit(s)\n", ""));
		return RET_FAIL;
	}
	pr(fmt("%d unit%s\n", nunits, splur(nunits)));
	return RET_OK;
}
#endif /* RETREAT */
