#ifndef lint
static char *RCSid = "$Header: /SRX/empire/EMP/player/commands/reje.c 1.0 90/03/17 10:08:15 bailey Exp $";
#endif /* not lint */

/*
 * reje.c
 *
 * Refuse to accept either telegrams or treaties from individual
 * countries. Adapted from decl.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "news.h"
#include "file.h"
#include "xy.h"
#include "nsc.h"

#ifdef	REJECTS

reje()
{
	extern	s_char *argp[];
	register s_char *p;
	int	rel;
	int	do_undo;
#ifdef MERC
	struct	natstr nat;
	struct	nstr_item ni;
#endif

	p = getstarg(argp[1], "reject or accept? ");
	switch (*p) {
	case 'r':
		do_undo = 1;
		break;
	case 'a':
		do_undo = 0;
		break;
	default:
		pr("That's not one of the choices!\n");
		return RET_SYN;
	}
#ifdef MERC
	p = getstarg(argp[2], "mail, treaties, loans, or announcements? ");
#else
	p = getstarg(argp[2], "mail, treaties, or announcements? ");
#endif
	switch (*p) {
	case 'a':
		rel = REJ_ANNO;
		break;
#ifdef MERC
	case 'l':
		rel = REJ_LOAN;
		break;
#endif
	case 'm':
		rel = REJ_TELE;
		break;
	case 't':
		rel = REJ_TREA;
		break;
	default:
		pr("That's not one of the choices!\n");
		return RET_SYN;
	}
#ifdef MERC
	if (!snxtitem(&ni, EF_NATION, argp[3]))
		return RET_SYN;
	while (nxtitem(&ni, (s_char *) &nat)) {
		if (nat.nat_stat & STAT_NORM == 0)
			continue;
		switch(rel){
			case REJ_ANNO: pr(fmt("%s annos from %s\n",(do_undo == 1 ? "Rejecting" : "Accepting"),nat.nat_cnam));
					break;
			case REJ_LOAN: pr(fmt("%s loans from %s\n",(do_undo == 1 ? "Rejecting" : "Accepting"),nat.nat_cnam));
					break;
			case REJ_TELE: pr(fmt("%s teles from %s\n",(do_undo == 1 ? "Rejecting" : "Accepting"),nat.nat_cnam));
					break;
			case REJ_TREA: pr(fmt("%s treaties from %s\n",(do_undo == 1 ? "Rejecting" : "Accepting"),nat.nat_cnam));
					break;
			}
		setrej(cnum, (natid)ni.cur, do_undo, rel);
	}
#else
	if ((n = natarg(argp[3], "with which country? ")) < 0)
		return RET_SYN;
	with = n;
	setrej(cnum, with, do_undo, rel);
	switch(rel){
		case REJ_ANNO: pr(fmt("%s annos from %s\n",(do_undo == 1 ? "Rejecting" : "Accepting"),nat.nat_cnam));
				break;
		case REJ_LOAN: pr(fmt("%s loans from %s\n",(do_undo == 1 ? "Rejecting" : "Accepting"),nat.nat_cnam));
				break;
		case REJ_TELE: pr(fmt("%s teles from %s\n",(do_undo == 1 ? "Rejecting" : "Accepting"),nat.nat_cnam));
				break;
		case REJ_TREA: pr(fmt("%s treaties from %s\n",(do_undo == 1 ? "Rejecting" : "Accepting"),nat.nat_cnam));
				break;
		}
#endif
	return RET_OK;
}
#endif	REJECTS
