#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/reco.c,v 1.3 89/08/17 21:51:04 williams Exp $";
#endif

/*
 * reco.c
 *
 * Fly a recon 
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "item.h"
#include "plane.h"
#include "nuke.h"
#include "xy.h"
#include "nsc.h"
#include "news.h"
#include "file.h"
#include "nat.h"
#include "path.h"

reco()
{
	extern	s_char *argp[];
	s_char	*p;
	int	mission_flags;
	int	tech;
	coord	tx, ty;
	coord	ax, ay;
	int	ap_to_target;
	s_char	flightpath[256];
	int	cno;
	struct	nstr_item ni_bomb;
	struct	nstr_item ni_esc;
	coord	x, y;
	struct	sctstr target;
	struct	qelem bomb_list;
	struct	qelem esc_list;
	int	wantflags;
	struct	sctstr ap_sect;

	wantflags = 0;
	if (!snxtitem(&ni_bomb, EF_PLANE, argp[1]))
		return RET_SYN;
	if (!snxtitem(&ni_esc, EF_PLANE, argp[2]))
		pr("No escorts...\n");
	if ((p = getstarg(argp[3], "assembly point? ")) == 0 || *p == 0)
		return RET_SYN;
	if (!sarg_xy(p, &x, &y) || !getsect(x, y, &ap_sect))
		return RET_SYN;
	if (ap_sect.sct_own && ap_sect.sct_own != cnum) {
		pr("Assembly point not owned by you!\n");
		return RET_SYN;
	}
	ax = x;
	ay = y;
	if ((p = getpath(argp[4], ax, ay, 0, 0, 0, P_FLYING)) == 0 || *p == 0)
		return RET_SYN;
	(void)strcpy(flightpath, p);
	tx = ax;
	ty = ay;
	(void) pathtoxy(flightpath, &tx, &ty, fcost);
	pr(fmt("target is %s\n", xyas(tx, ty, cnum)));
	getsect(tx, ty, &target);
	cno = -1;
	mission_flags = 0;
	if (pln_onewaymission(&target, &cno, &wantflags) < 0)
		return RET_SYN;
	ap_to_target = strlen(flightpath);
	if (*(flightpath+strlen(flightpath)-1) == 'h')
		ap_to_target--;
	pr(fmt("range to target is %d\n", ap_to_target));
	/*
	 * select planes within range
	 */
	pln_sel(&ni_bomb, &bomb_list, &ap_sect, ap_to_target,
		1, wantflags, P_M|P_O);
	if (QEMPTY(&bomb_list)) {
		pr("No planes could be equipped for the mission.\n");
		return RET_FAIL;
	}
	wantflags |= P_F;
	wantflags |= P_ESC;
	pln_sel(&ni_esc, &esc_list, &ap_sect, ap_to_target,
		1, wantflags, P_M|P_O);
	/*
	 * now arm and equip the bombers, transports, whatever.
	 */
	tech=0;
	mission_flags |= P_X;		/* stealth (shhh) */
#ifdef CHOPPER_STEALTH
	mission_flags |= P_H; /* gets turned off if not all choppers */
#endif /* CHOPPER_STEALTH */
#ifdef ASW_PLANES
	mission_flags |= P_A;
#endif /* ASW_PLANES */
	mission_flags = pln_arm(&bomb_list, 'r', 0, P_S|P_I, mission_flags,&tech);
	if (QEMPTY(&bomb_list)) {
		pr("No planes could be equipped for the mission.\n");
		return RET_FAIL;
	}
	mission_flags = pln_arm(&esc_list, 'r', 0, P_F, mission_flags,&tech);
	mission_flags |= PM_R;

	if (*argp[0] == 's')
		mission_flags |= PM_S;

	ac_encounter(&bomb_list,&esc_list,ax,ay,flightpath,mission_flags,0);
	if (QEMPTY(&bomb_list)) {
		pr(fmt("No planes got through fighter defenses\n"));
	} else {
		getsect(tx, ty, &target);
		pln_newlanding(&bomb_list, tx, ty, cno);
		pln_newlanding(&esc_list, tx, ty, cno);
	}
	pln_put(&bomb_list);
	pln_put(&esc_list);
	return RET_OK;
}
