#ifndef lint
static char *RCSid = "$Header: navi.c,v 1.1 89/12/14 08:20:15 jay Exp $";
#endif

/*
 * navi.c
 *
 * navigate ships and such.
 *
 * from PSL Empire, 1985
 */

#include <ctype.h>
#include "misc.h"
#include "var.h"
#include "ship.h"
#include "sect.h"
#include "news.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "path.h"
#include "deity.h"
#include "file.h"
#include "map.h"

static void ship_mess();
static int check_nav();
 /* return codes from check_nav */
#define CN_LANDLOCKED	(1)
#define CN_CONSTRUCTION	(2)
#define CN_ERROR	(-1)
#define CN_NAVIGABLE	(0)

navi()
{
	register int n;
	extern	double techfact();
	extern	s_char *argp[];
	struct	sctstr sect, fsect, d_sect;
	int	non_sub=0, has_sub;
	s_char	*cp;
	int	dam, dam2;
	int	alive;
	int     dir;
	int     nships, moved;
	coord     newx;
	coord     newy;
	coord     dx;
	coord     dy;
	coord     destx;
	coord     desty;
	coord     allx;
	coord     ally;
	int	first=1, together=1;
	s_char	*bestownedpath();
	int     stopping;
	int     viewing;
	int     snums[NS_LSIZE];
	int	trange;
	double  mobcost, range, range2, guneff;
	double  mobils[NS_LSIZE];
	double  minmob, keepmob;
	struct nstr_item nb;
	struct nstr_sect ns;
	struct shpstr ships[NS_LSIZE];
	struct shpstr *shpq;
	struct shpstr *shpp;
	struct mchrstr *mcp;
	int	vec[I_MAX+1];
	int	time_to_stop, skip=0;

	if (!snxtitem(&nb, EF_SHIP, argp[1]))
		return RET_SYN;
	minmob = 9999.0;
	n = 0;
	while (nxtitem(&nb, (s_char *)&ships[n])) {
		if (!owner)
			continue;
#ifdef	SAIL
		if (*ships[n].shp_path) /* can't nav a ship that's sailin, bad things happend */
		  {
		    ship_mess("has a sail path, `sail <#> -' to reset",ships[n].shp_uid,ships+n);
		    continue;
		  }
#endif	SAIL
		snums[n] = ships[n].shp_uid;
		shpp = &ships[n];
		mobils[n] = (double) shpp->shp_mobil;
		if (mobils[n] < minmob)
			minmob = mobils[n];
		/* check crew - uws don't count */
		getvec(VT_ITEM, vec, (s_char *)&ships[n], EF_SHIP);
		if (vec[I_MILIT] == 0 && vec[I_CIVIL] == 0) {
			ship_mess("crewless", snums[n], shpp);
			continue;
		}
		if (!getsect(shpp->shp_x, shpp->shp_y, &sect))
			return RET_SYN;
		switch (check_nav(&sect)) {
		case CN_CONSTRUCTION:
			ship_mess("caught in a construction zone",
				snums[n], shpp);
			continue;
		case CN_LANDLOCKED:
			ship_mess("landlocked", snums[n], shpp);
			continue;
			/*NOTREACHED*/
		case CN_NAVIGABLE:
#ifdef RETREAT
			shpp->shp_rflags = 0;
			bzero(shpp->shp_rpath,RET_LEN);
#endif /* RETREAT */
			break;
		case CN_ERROR:
		default:
			ship_mess("subject to an empire error", snums[n],
					  shpp);
			continue;
			/*NOTREACHED*/
		}
		/* when you nav, your mission goes away */
		ships[n].shp_mission = 0;
		putship(ships[n].shp_uid,&ships[n]);
		if (!(mchr[ships[n].shp_type].m_flags & M_SUB))
			non_sub = 1;
		if (mchr[ships[n].shp_type].m_flags & M_SUB)
			has_sub = 1;
		n++;			    /* good ship - keep it */

		if (first){
			allx = shpp->shp_x;
			ally = shpp->shp_y;
			first=0;
		}
		if (shpp->shp_x != allx)
			together = 0;
		if (shpp->shp_y != ally)
			together = 0;
	}
	if (n == 0) {
		pr("No ships\n");
		return RET_SYN;
	}
	nships = n;
	shpq = ships;
	stopping = 0;
	time_to_stop = 0;
	if (argp[2] && sarg_xy(argp[2], &destx, &desty) &&
		getsect(destx, desty, &d_sect)){
		if (!together){
			pr("Cannot go to a destination sector if not all starting in the same sector\n");
			return RET_FAIL;
		}

		cp = bestownedpath(allx,ally,d_sect.sct_x,d_sect.sct_y,".=h",
			cnum,1);
                if (cp == (s_char *)0){
                	pr(fmt("No all-sea path from %s to %s!\n",
                		xyas(allx,ally,cnum),
                		xyas(d_sect.sct_x,d_sect.sct_y,cnum)));
			return RET_FAIL;
		}
		pr(fmt("Using path '%s'\n",cp));
	}else
		cp = argp[2];

	while (!stopping) {
		s_char    *bp,dp[80];

		non_sub = 0;
		has_sub = 0;
		for (n = 0; n < nships; n++){
			if (!(mchr[ships[n].shp_type].m_flags & M_SUB))
				non_sub = 1;
			if (mchr[ships[n].shp_type].m_flags & M_SUB)
				has_sub = 1;
		}
		dx = dy = viewing = 0;
		if (cp == 0 || *cp == 0){
			if (!skip)
				nav_map(shpq->shp_x, shpq->shp_y,
					(*mchr[shpq->shp_type].m_name) & ~0x20);
			else
				skip=0;
			cp = getstring(fmt("<%.1f:%.1f: %s> ", mobils[0],
				minmob, xyas(shpq->shp_x, shpq->shp_y, cnum)));
		}
		if (cp == 0 || *cp == 0)
			cp = &dirch[DIR_STOP];
		if (*cp == 'r' || *cp == 'l' || *cp == 's' || *cp == 'm') {
			if (*cp == 'r')
				skip=1;
			argp[1] = ++cp;
			argp[1] = 0;
			for (n = 0; n < nships; n++)
				if (snums[n] != -1)
					putship(snums[n], &ships[n]);
			/* Make it default to the current ship, but */
			/* Malso allow them to specify the ship on the */
			/* same line */
			bp=cp;
			while((*bp != ' ') && (*bp)) bp++;
			while((*bp == ' ') && (*bp)) bp++;
			if ((bp != (s_char *)0) && (*bp))
				argp[1] = bp;
			else{
				sprintf(dp,"%d",snums[0]);
				argp[1] = dp;
			}
			if (cp[-1] == 'r') {
				rada();
				NAT_DELTA(nat_btu, cnum, -1);
			} else if (cp[-1] == 'l') {
				look();
				NAT_DELTA(nat_btu, cnum, -1);
			} else if (cp[-1] == 's') {
				sona();
				NAT_DELTA(nat_btu, cnum, -1);
			} else {
				struct	nstr_item ni;
				struct	shpstr shp, *sp;
				int	z;

				if (!snxtitem(&ni, EF_SHIP, argp[1]))
					continue;
				while (nxtitem(&ni, (s_char *)&shp)) {
					struct	mchrstr *mcp;
					int	shpnum=(-1);

					for (z = 0; z < nships; z++)
						if (snums[z] == shp.shp_uid){
							sp = &ships[z];
							shpnum=z;
						}

					if (shpnum < 0)
						continue;

					mcp = &mchr[sp->shp_type];
					if (!(mcp->m_flags & M_SWEEP)){
						pr(fmt("%s #%d is not a minesweeper!\n",
							mcp->m_name,
							sp->shp_uid));
						continue;
					}
					if (sp->shp_mobil < 0){
						pr(fmt("%s #%d is out of mobility!\n",
							mcp->m_name,
							sp->shp_uid));
						continue;
					}
					/* minesweeping costs 1 sects mob */
					mobcost = sp->shp_effic * 0.01 *
						mcp->m_speed;
					mobcost = 480.0 / (mobcost +
						techfact(sp->shp_tech,mobcost));

					sp->shp_mobil -= mobcost;
					mobils[shpnum] -= mobcost;
					if (mobils[shpnum] < minmob)
						minmob = mobils[shpnum];

					putship(sp->shp_uid,sp);
					sweep_mines(sp);
					if (check_mines(sp,snums,shpnum,
						&time_to_stop))
						cp = 0;
				}
			}
			cp = 0;
			continue;
		} else {
			dir = chkdir(*cp++, DIR_STOP, DIR_VIEW);
			if (dir == -1) {
				pr(fmt("\"%c\" is not legal...", cp[-1]));
				direrr("`%c' to stop", " & `%c' to view\n", 0);
				cp = "";
				continue;
			}
			if (dir == DIR_VIEW)
				viewing++;
			else if (dir == DIR_STOP)
				stopping++;
			else {
				dx = diroff[dir][0];
				dy = diroff[dir][1];
			}
		}
		moved = 0;
		keepmob = minmob;
		minmob = 9999.0;
		for (n = 0; n < nships; n++) {
			if (snums[n] == -1)
				continue;
			shpp = &ships[n];
			mcp = &mchr[shpp->shp_type];
			newx = xnorm(shpp->shp_x + dx);
			newy = ynorm(shpp->shp_y + dy);
			if (viewing || stopping || god)
				mobcost = 0.0;
			else {
				if (mobils[n] <= 0.0) {
					if (mobils[n] < minmob)
						minmob = mobils[n];
					ship_mess("out of mobility", snums[n], shpp);
					continue;
				}
				mobcost = shpp->shp_effic * 0.01 * mcp->m_speed;
				mobcost = 480.0 /
				    (mobcost + techfact(shpp->shp_tech, mobcost));
			}
			getsect(newx, newy, &sect);
			if (check_nav(&sect) != CN_NAVIGABLE ||
			    (sect.sct_own && !owner &&
			     getrel(getnatp(sect.sct_own), cnum) != ALLIED)) {
#ifdef	SHIPNAMES
				pr(fmt("%s %s(#%d) can't go to %s\n",
				       mcp->m_name, shpp->shp_name, snums[n], 
#else
				pr(fmt("%s #%d can't go to %s\n",
				       mcp->m_name, snums[n], 
#endif	SHIPNAMES
				       xyas(newx, newy, cnum)));
				cp = 0;
				if (mobils[n] < minmob)
					minmob = mobils[n];
				continue;
			}
			if (viewing) {
				if (mcp->m_flags & M_FOOD)
					pr(fmt("[fert:%d] ", sect.sct_fertil));
				if (mcp->m_flags & M_OIL)
					pr(fmt("[oil:%d] ", sect.sct_oil));
#ifdef	SHIPNAMES
				pr(fmt("%s %s(#%d) @ %s %d%% %s\n", mcp->m_name,
				       shpp->shp_name, snums[n],
				       xyas(newx, newy, cnum),
#else
				pr(fmt("%s #%d @ %s %d%% %s\n", mcp->m_name,
				       snums[n], xyas(newx, newy, cnum),
#endif	SHIPNAMES
				       sect.sct_effic,
				       dchr[sect.sct_type].d_name));
			}
#ifdef	AUTONAV
			if (n == 0) {
				radmapnopr(newx, newy, (int)shpp->shp_effic, 
				  (int)techfact(shpp->shp_tech,
				  (double) mchr[shpp->shp_type].m_vrnge),
				  (double)((mchr[shpp->shp_type].m_flags 
				    & M_SONAR)
				      ? techfact(shpp->shp_tech, 1.0) : 0.0));
			}
#endif	AUTONAV
			if ((shpp->shp_x != newx) || (shpp->shp_y != newy))
				moved = 1;
			shpp->shp_x = newx;
			shpp->shp_y = newy;
			mobils[n] -= mobcost;
			shpp->shp_mobil = (int) mobils[n];
			if (mobils[n] <= 0.0 || stopping) {
#ifdef	SHIPNAMES
				pr(fmt("%s %s(#%d) stopped at %s\n",
				mcp->m_name, shpp->shp_name,
#else
				pr(fmt("%s #%d stopped at %s\n", mcp->m_name,
#endif	SHIPNAMES
				       snums[n],
				       xyas(shpp->shp_x, shpp->shp_y, cnum)));
				shpp->shp_mobil = (int) mobils[n];
				putship(snums[n], shpp);
				snums[n] = -1;
				time_to_stop = 1;
				cp = &dirch[DIR_STOP];
			}
			if (mobils[n] < minmob)
				minmob = mobils[n];
			if (viewing || stopping)
				continue;

			sweep_mines(shpp);
			if (check_mines(shpp,snums,n,&time_to_stop))
				cp = 0;
		}
		if (time_to_stop)
			stopping = 1;

		for (n = 0; n < nships; n++)
			if (snums[n] != -1)
				putship(snums[n], &ships[n]);

		/*
		 * Check and see if anyone will interdict us
		 * Only if we're not all subs
		 */
		if (non_sub && (keepmob != 9999.0) && (keepmob>0) && moved){
			extern int fort_max_interdiction_range;
			dam = 0;
			snxtsct_dist(&ns,newx,newy,fort_max_interdiction_range);
			while (nxtsct(&ns,&fsect)){
				int	rel, shell, gun;
				if (fsect.sct_type != SCT_FORTR)
					continue;
				if (fsect.sct_own == 0)
					continue;
				if (fsect.sct_own == cnum)
					continue;
				gun=getvar(V_GUN,(s_char *)&fsect,EF_SECTOR);
				if (gun < 1)
					continue;
				range = tfact(fsect.sct_own,(double)min(gun,7));
				if (fsect.sct_effic > 59)
					range++;
				range2 = roundrange(range);
				trange = mapdist(newx, newy,
					fsect.sct_x, fsect.sct_y);
				if (trange > range2)
					continue;
				rel = getrel(getnatp(fsect.sct_own),cnum);
				if ((rel == ALLIED) || (rel == NEUTRAL))
					continue;
				if (getvar(V_MILIT,(s_char *)&fsect,EF_SECTOR)<5)
					continue;
				shell=getvar(V_SHELL,(s_char *)&fsect,EF_SECTOR);
				if (shell < 1)
					shell += supply_commod(fsect.sct_own,
						fsect.sct_x,fsect.sct_y,I_SHELL,
						1);

				if (shell < 1)
					continue;
				shell--;
				putvar(V_SHELL,shell,(s_char *)&fsect,EF_SECTOR);
				putsect(&fsect);
				if (gun>7)
					gun=7;
				guneff = landgun((int)fsect.sct_effic, gun);
				dam2 = shelldam((double)guneff, 127);
				dam += dam2;
				pr(fmt("%s fires at you for %d!\n",
					xyas(fsect.sct_x,fsect.sct_y,cnum),
					dam2));
				wu(0,fsect.sct_own,
					fmt("%s fires at %s ships at %s!\n",
					xyas(fsect.sct_x,fsect.sct_y,
					fsect.sct_own),
					cname(cnum),
					xyas(newx,newy,fsect.sct_own)));
				nreport(fsect.sct_own, N_SHP_SHELL, cnum, 1);
			}
			dam += interdict(newx,newy,cnum,"ships");
			if (dam > 0){
                                int     mydam, nnn=0;

				cp=0;
				for (n = 0; n < nships; n++)
					if ((!(mchr[ships[n].shp_type].m_flags
						& M_SUB)) &&
						(snums[n] != -1) &&
						(ships[n].shp_x == newx) &&
						(ships[n].shp_x == newx))
						nnn++;
                                mydam = ldround(((double)dam/(double)nnn),1);
				for (n = 0; n < nships; n++){
					if ((snums[n] != -1) && 
						(ships[n].shp_x == newx) &&
						(ships[n].shp_x == newx) &&
						!(mchr[ships[n].shp_type].m_flags & M_SUB)){

						shipdamage(&ships[n],mydam);
						putship(snums[n], &ships[n]);
						if (ships[n].shp_own == 0)
							snums[n] = -1;
					}
				}
			}
		}
		/*
		 * Check and see if anyone will interdict us
		 * Only if we have subs with us
		 */
		if (has_sub && (minmob != 9999.0) && (keepmob > 0) && moved){
			dam = sub_interdict(newx,newy,cnum,"subs");
			if (dam > 0){
                                int     mydam, nnn=0, escape[NS_LSIZE];

				cp=0;
				bzero(escape, NS_LSIZE*sizeof(int));
				for (n = 0; n < nships; n++)
					if ((mchr[ships[n].shp_type].m_flags
						& M_SUB) &&
						(ships[n].shp_x == newx) &&
						(ships[n].shp_y == newy) &&
						(snums[n] != -1)){

						double escape_chance;
						escape_chance = (4.0-(double)mchr[ships[n].shp_type].m_visib)*10.0;
						escape_chance -= ((100 - ships[n].shp_effic)/5);
						escape_chance /= 100.0;
						if (chance(escape_chance)){
							escape[n] = 1;
							pr(fmt("%s #%d escapes damage!\n",mchr[ships[n].shp_type].m_name,ships[n].shp_uid));
						} else
							nnn++;
					}
                                mydam = ldround(((double)dam/(double)nnn),1);
				for (n = 0; n < nships; n++){
					if ((mchr[ships[n].shp_type].m_flags
						& M_SUB) &&
						(ships[n].shp_x == newx) &&
						(ships[n].shp_y == newy) &&
						(snums[n] != -1)){
						/* Subs get hit */
						if (escape[n])
							continue;
						shipdamage(&ships[n],mydam);
						putship(snums[n], &ships[n]);
						if (ships[n].shp_own == 0)
							snums[n] = -1;
					}
				}
			}
		}
		alive = 0;
		for (n = 0; n < nships; n++)
			if (snums[n] != -1)
				alive = 1;
		if (!alive)
			stopping = 1;
	}
	for (n = 0; n < nships; n++) {
		if (snums[n] == -1)
			continue;
		shpp = &ships[n];
		if (shpp->shp_own == 0)
			continue;
		mcp = &mchr[shpp->shp_type];
#ifdef	SHIPNAMES
		pr(fmt("%s %s(#%d) stopped at %s\n", mcp->m_name,
			shpp->shp_name, snums[n],
#else
		pr(fmt("%s #%d stopped at %s\n", mcp->m_name, snums[n],
#endif	SHIPNAMES
		       xyas(shpp->shp_x, shpp->shp_y, cnum)));
		if (mobils[n] < 0)
			mobils[n] = 0;
		shpp->shp_mobil = mobils[n];
		putship(snums[n], shpp);
	}
	return RET_OK;
}

static void 
ship_mess(str, n, shp)
	s_char   *str;
	int     n;
	struct shpstr *shp;
{
	extern struct mchrstr mchr[];

#ifdef	SHIPNAMES
	pr(fmt("%s %s(#%d) is %s & stays in %s\n",
	       mchr[shp->shp_type].m_name, shp->shp_name, n,
#else
	pr(fmt("%s #%d is %s & stays in %s\n",
	       mchr[shp->shp_type].m_name, n,
#endif	SHIPNAMES
	       str, xyas(shp->shp_x, shp->shp_y, shp->shp_own)));
}

static int 
check_nav(sect)
	struct	sctstr *sect;
{
	extern struct dchrstr dchr[];

	switch (dchr[sect->sct_type].d_flg & 03) {
	case NAVOK:
		break;

	case NAV_02:
		if (sect->sct_effic < 2)
			return CN_CONSTRUCTION;
		break;
	case NAV_60:
		if (sect->sct_effic < 60)
			return CN_CONSTRUCTION;
		break;
	default:
		return CN_LANDLOCKED;
	}
	return CN_NAVIGABLE;
}


nav_map(x,y,c)
int	x,y;
s_char	c;
{
	register s_char *ptr;
	struct	nstr_sect ns;
	struct	natstr *np;
	struct	sctstr sect;
	struct	range range;
	int	i;
	u_char	bitmap[WORLD_X*WORLD_Y/8];
	s_char	wmap[WORLD_Y][MAPWIDTH(1)];
	s_char	what[64];
	extern  s_char getbigmap();

	np = getnatp(cnum);
	sprintf(what, "%d:%d,%d:%d",xrel(np,x-2),xrel(np,x+2),yrel(np,y-1),
		yrel(np,y+1));

	if (!snxtsct(&ns, what))
		return RET_FAIL;

	bzero((s_char *)bitmap, sizeof(bitmap));

	/* zap any conditionals */
	ns.ncond = 0;

	xyrelrange(np, &ns.range, &range);
	blankfill((s_char *)wmap, &ns.range, 1);

	while (nxtsct(&ns, &sect)){
		ptr = &wmap[ns.dy][ns.dx];
		if (sect.sct_type > SCT_MAXDEF)
			*ptr = '?';
		else {
			*ptr = dchr[sect.sct_type].d_mnem;
			switch (sect.sct_type) {
			case SCT_WATER:
			case SCT_RURAL:
			case SCT_MOUNT:
			case SCT_WASTE:
				break;
			default:
				if (sect.sct_own != cnum)
					*ptr = '?';
				break;
			}
#if	defined(BMAP) || defined(AUTONAV)
			setbigmap(sect.sct_x, sect.sct_y, *ptr);
#endif
			/*
			 * We do it this way so that 'x' and 'X'
			 * bdesignations will show up. This can
			 * be used to mark mined sectors. So, the
			 * player will see the current des, UNLESS
			 * they've marked the sector 'x' or 'X',
			 * in which case they'll see that.
			 * --ts
			 */
			*ptr = getbigmap(sect.sct_x, sect.sct_y);
		}
	}
#if	defined(BMAP) || defined(AUTONAV)
	writebigmap();
#endif
        wmap[1][2] = c; /* Put in ship letter */
        for (i=0; i < ns.range.height; i++)
                pr(fmt("%s\n", wmap[i]));

	return RET_OK;
}

sweep_mines(sp)
struct	shpstr *sp;
{
	struct	sctstr sect;
	int	mines, m, max, shells;
	struct	mchrstr *mcp;

	mcp = &mchr[sp->shp_type];

	if (!(mcp->m_flags & M_SWEEP))
		return;

	getsect(sp->shp_x, sp->shp_y, &sect);
	mines = getvar(V_MINE, (s_char *)&sect, EF_SECTOR);
	if (mines > 0 && !owner) {
		max = vl_find(V_SHELL, mcp->m_vtype,
			mcp->m_vamt, (int) mcp->m_nv);
		shells = getvar(V_SHELL, (s_char *)sp, EF_SHIP);
		for (m=0; mines > 0 && m < 5; m++) {
			if (chance(0.66)) {
				pr("Sweep...\n");
				mines--;
				shells = min(max, shells + 1);
			}
		}
		putvar(V_MINE, mines, (s_char *)&sect, EF_SECTOR);
		putvar(V_SHELL, shells, (s_char *)sp, EF_SHIP);
		putsect(&sect);
	}
	putship(sp->shp_uid,sp);
}

hit_mine(sp)
struct shpstr *sp;
{
	struct	mchrstr *mcp;
	double	m;

	mcp = &mchr[sp->shp_type];

#ifdef	SHIPNAMES
	pr(fmt("\007Kawhomp! Mine detected by %s %s(#%d) in %s!\n",
		mcp->m_name, sp->shp_name, sp->shp_uid,
#else
	pr(fmt("\007Kawhomp! Mine detected by %s #%d in %s!\n",
		mcp->m_name, sp->shp_uid,
#endif	SHIPNAMES
		xyas(sp->shp_x, sp->shp_y, cnum)));

	nreport(cnum, N_HIT_MINE, 0, 1);
	if ((mcp->m_glim) || (mcp->m_flags & M_TORP) ||
		(mcp->m_flags & M_MSL) ||
		(mcp->m_flags & M_SUB) ||
		(mcp->m_flags & M_FLY))
		m=15.0+(1350.0/(double)mcp->m_armor);
	else
		m=2100.0/(double)(mcp->m_vrnge*mcp->m_visib);

	m += (double)(random() % 21);
	if (mcp->m_flags & M_SWEEP)
		m /= 2.0;

	shipdamage(sp, ldround(m,1));

	return (int)m;
}
check_mines(sp,snums,n,time_to_stop)
struct	shpstr *sp;
int     snums[NS_LSIZE];
int	n;
int	*time_to_stop;
{
	struct	sctstr sect;
	int	mines, m;

	getsect(sp->shp_x,sp->shp_y,&sect);
	mines = getvar(V_MINE, (s_char *)&sect, EF_SECTOR);
	if (mines > 0 && !owner &&chance(((double)mines/((double)mines+50.0)))){
		m=hit_mine(sp);
		mines--;
		putvar(V_MINE,mines,(s_char *)&sect,EF_SECTOR);
		putsect(&sect);
		if (sp->shp_effic < SHIP_MINEFF) {
			*time_to_stop = 1;
			snums[n] = -1;
		}
		putship(sp->shp_uid, (s_char *)sp);
		pr(fmt("%d%% damage sustained\n",m));

		return 1;
	}
	return 0;
}
