#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/enli.c,v 1.2 89/05/29 14:26:38 emp-src Exp $";
#endif /* not lint */

/*
 * enli.c
 *
 * enlist some military
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "treaty.h"
#include "file.h"

enli()
{
	extern	s_char *argp[];
	struct	nstr_sect nstr;
	struct	sctstr sect;
	struct	natstr *natp;
	int	btused;
	int	civ;
	int	mil;
	int	newmil;
	int	milwant;
	int	totalmil;
	long	reserve;
	s_char	*p;
	int	quota;

	if (!snxtsct(&nstr, argp[1]))
		return RET_SYN;
	if (!trechk(cnum, 0, TRTENL))
		return RET_FAIL;
	natp = getnatp(cnum);
	newmil = 500;
	if ((p = getstarg(argp[2], fmt("Number to enlist (max %d) : ",
				       newmil))) == 0)
		return RET_SYN;
	if ((milwant = atoi(p)) > newmil)
		milwant = newmil;
	if (quota = (milwant < 0))
		milwant = -milwant;
	totalmil = 0;
	reserve = natp->nat_reserve;
	if (reserve <= 0) {
		pr("No military reserves left\n");
		return RET_OK;
	}
	while (nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
		if (sect.sct_oldown != cnum)
			continue;
		civ = getvar(V_CIVIL, (s_char *)&sect, EF_SECTOR);
		if (civ == 0)
			continue;
		if (sect.sct_loyal > 70) {
			pr(fmt("civilians refuse to report in %s!\n",
			       xyas(sect.sct_x, sect.sct_y, cnum)));
			continue;
		}
		mil = getvar(V_MILIT, (s_char *)&sect, EF_SECTOR);
		newmil = civ * 0.5;
		if (quota) {
			if (newmil > milwant - mil)
				newmil = milwant - mil;
			if (newmil > 500)
				newmil = 500;
		} else if (newmil > milwant)
			newmil = milwant;
		if (newmil > 999 - mil)
			newmil = 999 - mil;
		if (newmil <= 0)
			continue;
		if (newmil > reserve)
			newmil = reserve;
		if (!putvar(V_MILIT, newmil + mil, (s_char *)&sect, EF_SECTOR)) {
			pr(fmt("No room for military in %s\n",
			       xyas(sect.sct_x, sect.sct_y, cnum)));
			continue;
		}
		reserve -= newmil;
		totalmil += newmil;
		putvar(V_CIVIL, civ - newmil, (s_char *)&sect, EF_SECTOR);
		pr(fmt("%3d enlisted in %s (%d)\n", newmil,
		       xyas(sect.sct_x, sect.sct_y, cnum), mil + newmil));
		sect.sct_mobil = (u_char)((float)sect.sct_mobil *
					  (1.0 - (float)newmil / (float)civ));
		putsect(&sect);
		if (totalmil >= 10000) {
			pr("Rioting in induction center interrupts enlistment\n");
			break;
		}
		if (reserve == 0) {
			pr("Military reserve exhausted\n");
			break;
		}
	}
	pr(fmt("Total new enlistment : %d\n", totalmil));
	pr(fmt("Military reserves stand at %d\n", reserve));
	NAT_DELTA(nat_reserve, cnum, -totalmil);
	if ((btused = roundavg((float)totalmil * 0.02)) > 0)
		pr(fmt("Paperwork at recruiting stations ... %d\n", btused));
	NAT_DELTA(nat_btu, cnum, -btused);
	return RET_OK;
}
