static char *RCSid = "$Header: /sequent2/empire/EMP/lib/global/RCS/ship.c,v 1.2 89/09/10 21:37:57 mr-frog Exp $";

/*
 * ship.c
 *
 * marine characteristics -- ship capabilities descriptions
 * 
 */

#include "misc.h"
#include "var.h"
#include "ship.h"

struct  mchrstr mchr[]  = {
/*          a   s   v  v   f       E  K   f  f       		    	      */
/*          r   p   i  r   r   g   |  |   u  u       		    	      */
/* l   h    m   e   s  n   n   l   x  V   e  e       		    	      */
/* c   c    o   e   i  g   g   i   p  p   l  l       		    	      */
/* m   m    r   d   b  e   e   m   l  l   c  u  name                tech  Cost*/

{ 25, 15,  10, 10, 15, 2,  0,  0,
#ifdef XLIGHT
                                   0,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                                "fishing boat 1",      0,  180,
    M_FOOD,  0, 0, 4,
    { V_CIVIL, V_MILIT, V_FOOD, V_UW },
    {     300,      10,    900,   15 }, },

{ 60, 40,  20, 10, 35, 3,  0,  0,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                                "cargo ship 1",         0,  300,
#ifdef XLIGHT
    M_SUPPLY|M_XLIGHT,  0, 0, 8,
#else
    M_SUPPLY,  0, 0, 8,
#endif /* XLIGHT */
    { V_CIVIL, V_MILIT, V_SHELL, V_GUN, V_FOOD, V_LCM, V_HCM, V_UW },
    {     600,      50,     300,    50,    900,  1400,   900,  250 }, },

{ 60, 40,  20, 10, 35, 3,  0,  0,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                                "ore ship 1",           0,  300,
#ifdef XLIGHT
    M_XLIGHT,  0, 0, 7,
#else
    0,  0, 0, 7,
#endif /* XLIGHT */
    { V_CIVIL, V_MILIT, V_IRON, V_DUST, V_FOOD, V_UW, V_RAD },
    {      30,       5,    990,    990,    200,   45,   990 }, },

{ 60, 40,  20, 10, 35, 3,  0,  0,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                                "slave ship",           0,  300,
#ifdef XLIGHT
    M_XLIGHT,  0, 0, 4,
#else
    0,  0, 0, 4,
#endif /* XLIGHT */
    { V_CIVIL, V_MILIT, V_FOOD, V_UW },
    {      20,      80,    200, 1200 }, },

#ifdef TRADESHIPS
{ 200, 100,  20, 10, 35, 3,  0,  0,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                                "trade ship 1",         0, 2500,
    M_TRADE,  0, 0, 3,
    { V_CIVIL, V_MILIT, V_FOOD },
    {      50,      50,    100 }, },
#endif /* TRADESHIPS */

{ 30, 30,  50, 25, 25, 3,  1,  1,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                                "frigate",              0,  600,
#ifdef SEMILAND
    M_SEMILAND,  0, 2, 4,
#else
    0,  0, 2, 4,
#endif /* SEMILAND */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      60,      10,     2,     60 }, },

{ 50, 50,  60, 20, 35, 3,  1,  2,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                                "battleship 1",         0,  800,
#ifdef XLIGHT
#ifdef SEMILAND
    M_XLIGHT|M_SEMILAND,  0, 2, 4,
#else
    M_XLIGHT,  0, 2, 4,
#endif /* SEMILAND */
#else
#ifdef SEMILAND
    M_SEMILAND,  0, 2, 4,
#else
    0,  0, 2, 4,
#endif /* SEMILAND */
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     120,      20,     4,    120 }, },

{ 25, 15,  10, 25, 15, 2,  0,  0,
#ifdef XLIGHT
                                   0,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         20, 1,
#endif /* FUEL */
                                                "fishing boat 2",      40,  300,
    M_FOOD,  0, 0, 4,
    { V_CIVIL, V_MILIT, V_FOOD, V_UW },
    {     300,      10,    900,   15 }, },

{ 60, 40,  20, 25, 35, 3,  0,  0,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         30, 1,
#endif /* FUEL */
                                                "cargo ship 2",        40,  500,
#ifdef XLIGHT
    M_SUPPLY|M_XLIGHT, 0, 2, 8,
#else
    M_SUPPLY,  0, 0, 8,
#endif /* XLIGHT */
    { V_CIVIL, V_MILIT, V_SHELL, V_GUN, V_FOOD, V_LCM, V_HCM, V_UW },
    {     600,      50,     300,    50,    900,  1400,   900,  250 }, },

{ 60, 40,  20, 25, 35, 3,  0,  0,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         30, 1,
#endif /* FUEL */
                                                "ore ship 2",          40,  500,
#ifdef XLIGHT
    M_XLIGHT,  0, 0, 7,
#else
    0,  0, 0, 7,
#endif /* XLIGHT */
    { V_CIVIL, V_MILIT, V_IRON, V_DUST, V_FOOD, V_UW, V_RAD },
    {      30,       5,    990,    990,    200,   45,   990 }, },

#ifdef TRADESHIPS
{ 200, 100,  20, 25, 35, 3,  0,  0,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         30, 1,
#endif /* FUEL */
                                                "trade ship 2",        40, 2500,
#ifdef XLIGHT
    M_XLIGHT|M_TRADE,  0, 0, 3,
#else
    M_TRADE,  0, 0, 3,
#endif /* XLIGHT */
    { V_CIVIL, V_MILIT, V_FOOD },
    {      50,      50,    100 }, },
#endif /* TRADESHIPS */

{ 25, 15,  10, 25, 15, 2,  0,  0,
#ifdef XLIGHT
                                   0,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         20, 1,
#endif /* FUEL */
                                                "oil exploration boat", 40, 800,
    M_OIL,  0, 0, 4,
    { V_CIVIL, V_MILIT, V_FOOD, V_OIL },
    {      10,       5,    100,     1 }, },

{ 60, 60,  40, 10, 65, 3,  0,  0,
#ifdef XLIGHT
                                   2,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                                "oil derrick 1",       40, 1000,
#ifdef XLIGHT
    M_XLIGHT|M_OIL,  0, 0, 5,
#else
    M_OIL,  0, 0, 5,
#endif /* XLIGHT */
    { V_CIVIL, V_MILIT, V_FOOD, V_OIL, V_UW },
    {     500,      80,    300,   990,  500 }, },

{ 20, 10,  10, 40, 10, 2,  2,  1,
#ifdef XLIGHT
                                   0,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          4, 1,
#endif /* FUEL */
                                                "torpedo boat",        40,  300,
    M_TORP,  0, 0, 4,
    { V_MILIT, V_GUN, V_SHELL, V_FOOD },
    {       2,     2,      12,      5 }, },

{ 30, 40,  50, 30, 30, 5,  8,  3,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         40, 1,
#endif /* FUEL */
                                                "light cruiser 1",     40,  800,
#ifdef XLIGHT
    M_XLIGHT|M_MINE,  0, 2, 4,
#else
    M_MINE,  0, 0, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     100,      40,     5,    100 }, },

{ 40, 50,  70, 30, 30, 5, 10,  4,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         30, 1,
#endif /* FUEL */
                                                "heavy cruiser 1",     40, 1100,
#ifdef XLIGHT
    M_XLIGHT,  0, 4, 4,
#else
    0,  0, 0, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     120,     100,     6,    200 }, },

{ 50, 70,  90, 25, 35, 6, 12,  5,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         50, 2,
#endif /* FUEL */
                                                "battleship 2",        40, 1500,
#ifdef XLIGHT
    M_XLIGHT,  0, 2, 4,
#else
    0,  0, 0, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     200,     200,     8,    900 }, },

{ 60, 40,  80, 25, 45, 3,  0,  0,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         30, 1,
#endif /* FUEL */
                                                "tanker",              40,  600,
#ifdef FUEL
#ifdef XLIGHT
    M_OILER|M_XLIGHT|M_SUPPLY,  0, 0, 6,
#else
    M_OILER|M_SUPPLY,  0, 0, 6,
#endif /* XLIGHT */
#else
#ifdef XLIGHT
    M_XLIGHT,  0, 0, 6,
#else
    0,  0, 0, 6,
#endif /* XLIGHT */
#endif /* FUEL */
    { V_CIVIL, V_MILIT, V_PETROL, V_FOOD, V_OIL, V_UW },
    {      30,       5,      990,    200,   990,   25 }, },

{ 25, 15,  10, 25, 15, 2,  0,  0,
#ifdef XLIGHT
                                   0,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         20, 1,
#endif /* FUEL */
                                                "minesweeper",         40,  400,
    M_MINE|M_SWEEP,  0, 0, 3,
    { V_MILIT, V_FOOD, V_SHELL },
    {      10,     90,     100 }, },

{ 30, 30,  35, 40, 20, 3,  6,  2,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         25, 1,
#endif /* FUEL */
                                                "destroyer 1",         60,  500,
#ifdef XLIGHT
    M_XLIGHT|M_TORP,  0, 0, 4,
#else
    M_TORP,  0, 0, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      40,      20,     4,     40 }, },

{ 20, 30,  30, 25,  5, 2,  2,  2,
#ifdef XLIGHT
                                   0,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         15, 1,
#endif /* FUEL */
                                                "submarine 1",         60,  600,
    M_TORP|M_SUB,  0, 0, 4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {       5,      24,     4,     80 }, },

{ 30, 30,  35, 30,  4, 3,  4,  3,
#ifdef XLIGHT
                                   0,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         25, 1,
#endif /* FUEL */
                                                "submarine 2",        100,  700,
    M_TORP|M_SUB|M_MINE|M_SONAR,  0, 0, 4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      25,      24,     4,     80 }, },

{ 30, 40,  60, 35, 30, 5, 10,  4,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         40, 1,
#endif /* FUEL */
                                                "light cruiser 2",    100,  900,
#ifdef XLIGHT
    M_XLIGHT|M_MINE,  0, 2, 4,
#else
    M_MINE,  0, 2, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     100,      40,     6,    100 }, },

{ 40, 50,  80, 35, 30, 5, 12,  5,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         30, 1,
#endif /* FUEL */
                                                "heavy cruiser 2",    100, 1200,
#ifdef XLIGHT
    M_XLIGHT,  0, 4, 4,
#else
    0,  0, 0, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     120,     100,     8,    200 }, },

{ 50, 70, 100, 30, 35, 6, 14,  6,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                        50, 2,
#endif /* FUEL */
                                                "battleship 3",       100, 1600,
#ifdef XLIGHT
    M_XLIGHT,  0, 2, 4,
#else
    0,  0, 0, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     200,     200,     8,    900 }, },

{ 60, 40,  40, 25, 40, 4,  2,  2,
#ifdef XLIGHT
                                   2,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      8,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         40, 2,
#endif /* FUEL */
                                                "escort carrier",     100, 1200,
#ifdef SHIPCHOPPERS
#ifdef XLIGHT
    M_CHOPPER|M_XLIGHT|M_FLY,  8, 0, 5,
#else
    M_CHOPPER|M_FLY,  8, 0, 5,
#endif /* XLIGHT */
#else
#ifdef XLIGHT
    M_XLIGHT|M_FLY,  8, 0, 5,
#else
    M_FLY,  8, 0, 5,
#endif /* XLIGHT */
#endif /* SHIPCHOPPERS */
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {      50,     100,     4,      150,    180 }, },

{ 60, 60,  30, 15, 65, 3,  0,  0,
#ifdef XLIGHT
                                   2,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                                "oil derrick 2",      100, 1500,
#ifdef XLIGHT
    M_XLIGHT|M_OIL,  0, 0, 5,
#else
    M_OIL,  0, 0, 5,
#endif /* XLIGHT */
    { V_CIVIL, V_MILIT, V_FOOD, V_OIL, V_UW },
    {     990,      80,   990,    990,  990 }, },

{ 50, 60,  60, 35, 35, 6, 14,  6,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                        60, 2,
#endif /* FUEL */
                                                "battlecruiser",      100, 1500,
#ifdef XLIGHT
    M_XLIGHT,  0, 2, 4,
#else
    0,  0, 2, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     180,     100,     8,    400 }, },

{ 30, 30,  45, 35, 20, 4,  8,  2,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         30, 1,
#endif /* FUEL */
                                                "destroyer 2",        100,  600,
#ifdef XLIGHT
    M_MINE|M_XLIGHT|M_DCH|M_SONAR,  0, 1, 4,
#else
    M_MINE|M_DCH|M_SONAR,  0, 1, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      60,      40,     4,     80 }, },

{ 50, 60,  60, 30, 40, 5,  2,  2,
#ifdef XLIGHT
                                   4,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      20,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         50, 2,
#endif /* FUEL */
                                                "light carrier",      140, 2000,
#ifdef SHIPCHOPPERS
#ifdef XLIGHT
    M_CHOPPER|M_XLIGHT|M_FLY, 20, 0, 5,
#else
    M_CHOPPER|M_FLY, 20, 0, 5,
#endif /* XLIGHT */
#else
#ifdef XLIGHT
    M_XLIGHT|M_FLY, 20, 0, 5,
#else
    M_FLY, 20, 0, 5,
#endif /* XLIGHT */
#endif /* SHIPCHOPPERS */
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {     175,     250,     4,      300,    180 }, },

{ 50, 70, 120, 35, 35, 6, 16,  7,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         50, 2,
#endif /* FUEL */
                                                "battleship 4",       150, 1800,
#ifdef XLIGHT
    M_XLIGHT,  0, 2, 4,
#else
    0,  0, 0, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     200,     200,    10,    900 }, },

{ 40, 40,  50, 30,  2, 3,  0,  0,
#ifdef XLIGHT
                                   0,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         50, 2,
#endif /* FUEL */
                                                "cargo submarine",    160, 1200,
#ifdef FUEL
    M_SUPPLY|M_OILER|M_SUB|M_SONAR,  0, 0, 8,
#else
    M_SUPPLY|M_SUB|M_SONAR,  0, 0, 8,
#endif /* FUEL */
    { V_CIVIL, V_MILIT, V_SHELL, V_GUN, V_FOOD, V_LCM, V_HCM, V_PETROL },
    {       5,      10,     104,    20,    900,   500,   300,      100 }, },

{ 30, 30,  35, 30,  3, 4,  5,  3,
#ifdef XLIGHT
                                   0,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         30, 1,
#endif /* FUEL */
                                                "submarine 3",        160,  700,
    M_TORP|M_SUB|M_MINE|M_SONAR,  0, 0, 4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      25,      36,     5,     80 }, },

{ 60, 40,  40, 30, 30, 2,  0,  0,
#ifdef XLIGHT
                                   2,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         30, 1,
#endif /* FUEL */
                                                "landing ship",       160, 1000,
#ifdef XLIGHT
    M_XLIGHT|M_LAND,  0, 6, 2,
#else
    M_LAND,  0, 0, 2,
#endif /* XLIGHT */
    { V_MILIT, V_FOOD },
    {     400,    300 }, },

{ 60, 70,  80, 35, 40, 7,  2,  2,
#ifdef XLIGHT
                                   10,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      40,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                        120, 3,
#endif /* FUEL */
                                                "aircraft carrier",   160, 3000,
#ifdef SHIPCHOPPERS
#ifdef XLIGHT
    M_CHOPPER|M_XLIGHT|M_FLY, 40, 0, 5,
#else
    M_CHOPPER|M_FLY, 40, 0, 5,
#endif /* XLIGHT */
#else
#ifdef XLIGHT
    M_XLIGHT|M_FLY, 40, 0, 5,
#else
    M_FLY, 40, 0, 5,
#endif /* XLIGHT */
#endif /* SHIPCHOPPERS */
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {     350,     500,     4,      500,    900 }, },

{ 60, 40,  80, 35, 45, 3,  0,  0,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         30, 1,
#endif /* FUEL */
                                                "fast tanker",        160,  700,
#ifdef FUEL
#ifdef XLIGHT
    M_OILER|M_XLIGHT|M_SUPPLY,  0, 0, 6,
#else
    M_OILER|M_SUPPLY,  0, 0, 6,
#endif /* XLIGHT */
#else
#ifdef XLIGHT
    M_XLIGHT,  0, 0, 6,
#else
    0,  0, 0, 6,
#endif /* XLIGHT */
#endif /* FUEL */
    { V_CIVIL, V_MILIT, V_PETROL, V_FOOD, V_OIL, V_UW },
    {      30,       5,      990,    200,   990,   25 }, },

{ 50, 60,  80, 35, 30, 6,  1, 10,
#ifdef XLIGHT
                                   1,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         60, 2,
#endif /* FUEL */
                                                "aa cruiser",       150, 1500,
#ifdef XLIGHT
    M_XLIGHT,  0, 4, 4,
#else
    0,  0, 0, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     100,      50,    15,    200 }, },

{ 40, 30,  50, 35, 30, 5,  2,  2,
#ifdef XLIGHT
                                   4,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         40, 1,
#endif /* FUEL */
                                                "asw frigate 1",      220,  800,
#ifdef XLIGHT
    M_XLIGHT|M_DCH|M_SONAR,  0, 0, 4,
#else
    M_DCH|M_SONAR,  0, 0, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      60,      60,     4,    120 }, },

{ 30, 40,  45, 40,  3, 6,  5,  3,
#ifdef XLIGHT
                                   0,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                                "nuc attack sub 1",   230, 1200,
    M_TORP|M_SUB|M_MINE|M_SONAR|M_SUBT,  0, 0, 4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      25,      60,     6,    500 }, },

{ 30, 30,  35, 30,  3, 3,  0,  0,
#ifdef XLIGHT
                                   0,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         30, 1,
#endif /* FUEL */
                                                "missile sub",   240, 1200,
    M_SUB|M_SONAR|M_MSL, 10, 0, 3,
    { V_MILIT, V_SHELL, V_FOOD },
    {      25,     100,    500 }, },

{ 40, 40,  60, 35, 35, 6,  8,  3,
#ifdef XLIGHT
                                  10,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      2,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                        80, 2,
#endif /* FUEL */
                                                "asw destroyer 1",    240, 1500,
#ifdef SHIPCHOPPERS
#ifdef XLIGHT
    M_CHOPPER|M_XLIGHT|M_DCH|M_SONAR,  0, 0, 5,
#else
    M_CHOPPER|M_DCH|M_SONAR,  0, 0, 5,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {     100,      80,     6,       40,    500 }, },
#else
#ifdef XLIGHT
    M_XLIGHT|M_DCH|M_SONAR,  0, 0, 4,
#else
    M_DCH|M_SONAR,  0, 0, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     100,      30,     6,    500 }, },
#endif /* SHIPCHOPPERS */

{ 30, 40,  55, 35,  2, 6,  0,  0,
#ifdef XLIGHT
                                   0,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                                "nuc miss sub 1",     280, 1500,
    M_SUB|M_SONAR|M_MSL, 20, 0, 3,
    { V_MILIT, V_SHELL, V_FOOD },
    {      25,     200,    500 }, },

{ 20, 20,  15, 40, 15, 3,  2,  2,
#ifdef XLIGHT
                                   0,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          7, 1,
#endif /* FUEL */
                                                "missile boat",       280,  500,
    M_MSL, 10, 0, 4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {       5,     100,     3,    500 }, },

{ 40, 30,  50, 35, 30, 5,  2,  2,
#ifdef XLIGHT
                                   2,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         30, 1,
#endif /* FUEL */
                                                "missile frigate",    280, 1000,
#ifdef XLIGHT
    M_XLIGHT|M_MSL, 20, 0, 4,
#else
    M_MSL, 20, 0, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      60,     220,     4,    120 }, },

{ 40, 30,  55, 35, 30, 7,  2,  2,
#ifdef XLIGHT
                                   8,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      1,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         40, 1,
#endif /* FUEL */
                                                "asw frigate 2",      280, 1000,
#ifdef SHIPCHOPPERS
#ifdef XLIGHT
    M_CHOPPER|M_XLIGHT|M_TORP|M_SUBT|M_DCH|M_SONAR,  0, 0, 5,
#else
    M_CHOPPER|M_TORP|M_SUBT|M_DCH|M_SONAR,  0, 0, 5,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {      60,      60,     4,       20,    120 }, },
#else
#ifdef XLIGHT
    M_XLIGHT|M_TORP|M_SUBT|M_DCH|M_SONAR,  0, 0, 4,
#else
    M_TORP|M_SUBT|M_DCH|M_SONAR,  0, 0, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      60,      20,     4,    120 }, },
#endif /* SHIPCHOPPERS */

{ 50, 50,  70, 35, 35, 8, 10,  4,
#ifdef XLIGHT
                                   8,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      8,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         35, 1,
#endif /* FUEL */
                                                "missile cruiser",    290, 1500,
#ifdef SHIPCHOPPERS
#ifdef XLIGHT
    M_CHOPPER|M_XLIGHT|M_MSL, 40, 0, 5,
#else
    M_CHOPPER|M_MSL, 40, 0, 5,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {     120,     500,     6,      160,    200 }, },
#else
#ifdef XLIGHT
    M_XLIGHT|M_MSL, 40, 0, 4,
#else
    M_MSL, 40, 0, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     120,     500,     6,    200 }, },
#endif /* SHIPCHOPPERS */

{ 40, 40,  65, 35, 35, 8, 10,  4,
#ifdef XLIGHT
                                  10,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      4,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         80, 2,
#endif /* FUEL */
                                                "asw destroyer 2",    290, 1500,
#ifdef SHIPCHOPPERS
#ifdef XLIGHT
    M_CHOPPER|M_XLIGHT|M_TORP|M_SUBT|M_DCH|M_SONAR,  0, 0, 5,
#else
    M_CHOPPER|M_TORP|M_SUBT|M_DCH|M_SONAR,  0, 0, 5,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {     100,      80,     6,       80,    500 }, },
#else
#ifdef XLIGHT
    M_XLIGHT|M_TORP|M_SUBT|M_DCH|M_SONAR,  0, 0, 4,
#else
    M_TORP|M_SUBT|M_DCH|M_SONAR,  0, 0, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     100,      30,     6,    500 }, },
#endif /* SHIPCHOPPERS */

{ 30, 40,  50, 50,  1, 8,  5,  3,
#ifdef XLIGHT
                                   0,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                                "nuc attack sub 2",   310, 1500,
    M_TORP|M_SUB|M_MINE|M_SONAR|M_SUBT,  0, 0, 4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      25,      90,     6,    500 }, },

{ 30, 40,  60, 45,  1, 8,  0,  0,
#ifdef XLIGHT
                                   0,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                                "nuc miss sub 2",     310, 1500,
    M_SUB|M_SONAR|M_MSL, 40, 0, 3,
    { V_MILIT, V_SHELL, V_FOOD },
    {      25,     400,    500 }, },

{ 40, 30,  55, 40, 30, 9,  2,  2,
#ifdef XLIGHT
                                   10,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      2,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                         50, 1,
#endif /* FUEL */
                                                "asw frigate 3",      310, 1200,
#ifdef SHIPCHOPPERS
#ifdef XLIGHT
    M_CHOPPER|M_XLIGHT|M_TORP|M_SUBT|M_DCH|M_SONAR, 0, 0, 5,
#else
    M_CHOPPER|M_TORP|M_SUBT|M_DCH|M_SONAR, 0, 0, 5,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {      60,      60,     4,       40,    120 }, },
#else
#ifdef XLIGHT
    M_XLIGHT|M_TORP|M_SUBT|M_DCH|M_SONAR, 0, 0, 4,
#else
    M_TORP|M_SUBT|M_DCH|M_SONAR, 0, 0, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      60,      20,     4,    120 }, },
#endif /* SHIPCHOPPERS */

{ 70, 80, 100, 45, 40, 9,  2,  2,
#ifdef XLIGHT
                                   20,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      4,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                                "nuc carrier",        320, 4000,
#ifdef FUEL
#ifdef SHIPCHOPPERS
#ifdef XLIGHT
    M_OILER|M_CHOPPER|M_XLIGHT|M_FLY|M_SUPPLY, 60, 0, 5,
#else
    M_OILER|M_CHOPPER|M_FLY|M_SUPPLY, 60, 0, 5,
#endif /* XLIGHT */
#else
#ifdef XLIGHT
    M_OILER|M_XLIGHT|M_FLY|M_SUPPLY, 60, 0, 5,
#else
    M_OILER|M_FLY|M_SUPPLY, 60, 0, 5,
#endif /* XLIGHT */
#endif /* SHIPCHOPPERS */
#else
#ifdef SHIPCHOPPERS
#ifdef XLIGHT
    M_CHOPPER|M_XLIGHT|M_FLY, 60, 0, 5,
#else
    M_CHOPPER|M_FLY, 60, 0, 5,
#endif /* XLIGHT */
#else
#ifdef XLIGHT
    M_XLIGHT|M_FLY, 60, 0, 5,
#else
    M_FLY, 60, 0, 5,
#endif /* XLIGHT */
#endif /* SHIPCHOPPERS */
#endif /* FUEL */
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {     350,     999,     4,      999,    900 }, },

{ 50, 50, 100, 45, 35, 6, 16,  4,
#ifdef XLIGHT
                                  10,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      2,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                                "nuc cruiser",        320, 1800,
#ifdef SHIPCHOPPERS
#ifdef XLIGHT
    M_CHOPPER|M_XLIGHT|M_MSL, 20, 0, 5,
#else
    M_CHOPPER|M_MSL, 20, 0, 5,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {     200,     400,     8,       40,    900 }, },
#else
#ifdef XLIGHT
    M_XLIGHT|M_MSL, 20, 0, 4,
#else
    M_MSL, 20, 0, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     200,     400,     8,    900 }, },
#endif /* SHIPCHOPPERS */

{ 50, 60,  80, 35, 30, 6,  1, 20,
#ifdef XLIGHT
                                   30,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      2,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                                "aegis cruiser",    150, 4000,
#ifdef SHIPCHOPPERS
#ifdef XLIGHT
    M_CHOPPER|M_XLIGHT|M_MSL, 32, 0, 5,
#else
    M_CHOPPER|M_MSL, 32, 0, 5,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {     200,     400,    25,       40,    900 }, },
#else
#ifdef XLIGHT
    M_XLIGHT|M_MSL, 32, 0, 4,
#else
    M_MSL, 32, 0, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     200,     400,     8,    900 }, },
#endif /* SHIPCHOPPERS */

{ 50, 50,  80, 45, 35, 9, 12,  4,
#ifdef XLIGHT
                                  25,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      8,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                                "nuc asw cruiser",    320, 1800,
#ifdef SHIPCHOPPERS
#ifdef XLIGHT
    M_CHOPPER|M_XLIGHT|M_TORP|M_SUBT|M_DCH|M_SONAR,  0, 0, 5,
#else
    M_CHOPPER|M_TORP|M_SUBT|M_DCH|M_SONAR,  0, 0, 5,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {     200,     120,     6,      160,    500 }, },
#else
#ifdef XLIGHT
    M_XLIGHT|M_TORP|M_SUBT|M_DCH|M_SONAR,  0, 0, 4,
#else
    M_TORP|M_SUBT|M_DCH|M_SONAR,  0, 0, 4,
#endif /* XLIGHT */
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     200,      80,     6,    500 }, },
#endif /* SHIPCHOPPERS */

{ 30, 40,  65, 50,  0,10,  0,  0,
#ifdef XLIGHT
                                   0,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                                "nuc miss sub 3",     380, 1800,
    M_SUB|M_SONAR|M_MSL, 50, 0, 3,
    { V_MILIT, V_SHELL, V_FOOD },
    {      25,     400,    500 }, },

{ 60, 40,  40, 45, 35, 6,  0,  0,
#ifdef XLIGHT
                                  10,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      2,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                               "nuc supply ship",     380, 1500,
#ifdef SHIPCHOPPERS
#ifdef XLIGHT
    M_CHOPPER|M_XLIGHT,0,2, 8,
#else
    M_CHOPPER,0,2, 8,
#endif /* XLIGHT */
#else
#ifdef XLIGHT
    M_XLIGHT,0,0, 8,
#else
    0,0,0, 8,
#endif /* XLIGHT */
#endif /* SHIPCHOPPERS */
  { V_CIVIL, V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD, V_LCM, V_HCM },
  {      50,      50,     600,    50,     999,     999,  1500,   900  }, },

{  0,  0,   0,  0,  0, 0,  0,  0,
#ifdef XLIGHT
                                   0,
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                                      0,
#endif /* SHIPCHOPPERS */
#ifdef FUEL
                                          0, 0,
#endif /* FUEL */
                                                "",                    0,    0,
    0, 0, 0, 0, 
    { 0 },
    { 0 }, }
};

int	shp_maxno = (sizeof(mchr) / sizeof(struct mchrstr)) - 1;
