#ifndef lint
static char *RCSid = "$Header: snxtitem.c,v 1.15 89/12/01 20:30:53 mr-frog Exp $";
#endif

/*
 * snxtitem.c
 *
 * arrange item selection using one of many different
 * criteria.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "file.h"

snxtitem_area(np, type, range)
	register struct nstr_item *np;
	int	type;
	struct	range *range;
{
	bzero(np, sizeof(*np));
	np->cur = -1;
	np->type = type;
	np->sel = NS_AREA;
	np->index = -1;
	np->range = *range;
	np->read = ef_read;
	np->flags = ef_flags(type);
	xysize_range(&np->range);
	ef_zapcache(type);
}

snxtitem_dist(np, type, cx, cy, dist)
	register struct nstr_item *np;
	int	type;
	int	cx, cy;
	int	dist;
{
	struct	range range;

	bzero(np, sizeof(*np));
	xydist_range(cx, cy, dist, &range);
	np->cur = -1;
	np->type = type;
	np->sel = NS_DIST;
	np->cx = cx;
	np->cy = cy;
	np->index = -1;
	np->range = range;
	np->dist = dist;
	np->read = ef_read;
	np->flags = ef_flags(type);
#if 0
	/* This is no longer proper. */
	/* It did the wrong thing for small, hitech worlds. */
	xysize_range(&np->range);
#endif
	ef_zapcache(type);
}

snxtitem_xy(np, type, x, y)
	register struct nstr_item *np;
	int	type;
	coord	x, y;
{
	bzero(np, sizeof(*np));
	np->cur = -1;
	np->type = type;
	np->sel = NS_XY;
	np->cx = xnorm(x);
	np->cy = ynorm(y);
	np->index = -1;
	np->dist = 0;
	np->read = ef_read;
	np->flags = ef_flags(type);
	ef_zapcache(type);
}

snxtitem_all(np, type)
	register struct nstr_item *np;
	int	type;
{
	bzero(np, sizeof(*np));
	np->cur = -1;
	np->sel = NS_ALL;
	np->type = type;
	np->index = -1;
	np->read = ef_read;
	np->flags = ef_flags(type);
	xysize_range(&np->range);
	ef_zapcache(type);
}

snxtitem_group(np, type, group)
	register struct nstr_item *np;
	int	type;
	s_char	group;
{
	if (group == '~')
		group = ' ';
	bzero(np, sizeof(*np));
	np->cur = -1;
	np->sel = NS_GROUP;
	np->group = group;
	np->type = type;
	np->index = -1;
	np->read = ef_read;
	np->flags = ef_flags(type);
	xysize_range(&np->range);
	ef_zapcache(type);
}

snxtitem_rewind(np)
	struct	nstr_item *np;
{
	np->cur = -1;
	np->index = -1;
	ef_zapcache(np->type);
}

int
snxtitem_list(np, type, list, len)
	register struct nstr_item *np;
	int	type;
	int	*list;
	int	len;
{
	int	i;

	bzero(np, sizeof(*np));
	np->cur = -1;
	np->type = type;
	np->sel = NS_LIST;
	np->index = -1;
	np->read = ef_read;
	np->flags = ef_flags(type);
	if (len <= 0 || len > NS_LSIZE)
		return 0;
	for (i=0; i<len; i++)
		np->list[i] = list[i];
	np->size = len;
	ef_zapcache(type);
	return 1;
}
