#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/lib/common/RCS/damage.c,v 1.3 89/09/17 22:31:18 mr-frog Exp $";
#endif

/*
 * damage.c
 *
 * damage a sector, ship, or plane.
 *
 * Should probably do this in some regular fashion, but
 * we don't yet have a list of fields we can iterate through
 * and find the "damageable" ones.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "land.h"
#include "plane.h"
#include "nuke.h"
#include "xy.h"
#include "nsc.h"
#ifdef EASY_BRIDGES
#include "file.h"
#endif /* EASY_BRIDGES */

sectdamage(sp, dam)
	register struct sctstr *sp;
	int	dam;
{
	extern	double unit_damage;
	struct	nstr_item ni;
	struct	lndstr land;
	double	real_dam;
        struct	plnstr *pp;
        struct  plnstr p;
        int     n,old=sp->sct_own;
        int     mines;

	if (dam <= 0)
		return;
	if (dam > 100)
		dam = 100;

	/* Some sectors are harder/easier to kill..   */
	/* Average sector has a dstr of 2, so adjust  */
	/* the damage accordingly. Makes forts a pain */
	real_dam = (double)dam;
	real_dam *= (2.0/((double)dchr[sp->sct_type].d_dstr));
	dam = ldround(real_dam,1);

	if (dam <= 0)
		return;
	if (dam > 100)
		dam = 100;

	sp->sct_effic = damage((int)sp->sct_effic, dam);
	sp->sct_mobil = damage((int)sp->sct_mobil, dam);
	sp->sct_nv = vl_damage(dam, sp->sct_vtype, sp->sct_vamt,
		(int)sp->sct_nv);
#ifndef EASY_BRIDGES
	if (sp->sct_effic < 20 && sp->sct_type == SCT_BHEAD)
		bridgefall(sp);
#else
	if (sp->sct_effic < 20 && sp->sct_type == SCT_BSPAN){
		wu(0, sp->sct_own, fmt("Crumble... SCREEEECH!  Splash! Bridge falls at %s!\n",
                                xyas(sp->sct_x, sp->sct_y, sp->sct_own)));
		sp->sct_type = SCT_WATER;
		sp->sct_newtype = SCT_WATER;
		sp->sct_own = 0;
		sp->sct_oldown = 0;
		for (n=0; ef_read(EF_LAND, n, (s_char *)&land); n++) {
			if(land.lnd_x != sp->sct_x || land.lnd_y != sp->sct_y)
				continue;
			wu(0, old, fmt("     \07AARGH! %s #%d tumbles to its doom!\n",
				lchr[land.lnd_type].l_name, land.lnd_uid));
			land.lnd_own = 0;
			putland(n, &land);
		}
		pp = &p;
		for (n=0; ef_read(EF_PLANE, n, (s_char *)pp); n++) {
			if(pp->pln_x != sp->sct_x || pp->pln_y != sp->sct_y)
				continue;
			wu(0, old, fmt("     \07AARGH! %s #%d tumbles to its doom!\n",
				plchr[pp->pln_type].pl_name,pp->pln_uid));
			pp->pln_own = 0;
			putplane(n, pp);
		}
		/*
		 * save only the mines; zero the rest of the
		 * commodities.
		 */
		mines = getvar(V_MINE, (caddr_t)sp, EF_SECTOR);
		sp->sct_nv = 0;
		if (mines > 0)
			(void) putvar(V_MINE, mines, (caddr_t)sp, EF_SECTOR);
		(void) putsect(sp);
	}
#endif /* EASY_BRIDGES */

	/* Damage all the land units in the sector */
	/* Units don't take full damage */
	dam = ldround(((double)dam * unit_damage),1);
	snxtitem_xy(&ni,EF_LAND,sp->sct_x,sp->sct_y);
	while(nxtitem(&ni,(s_char *)&land)){
		landdamage(&land,dam);
		putland(land.lnd_uid,&land);
	}
}
