#ifndef lint
static char *RCSid = "$Header: nstr.c,v 1.2 89/10/26 23:57:04 mr-frog Exp $";
#endif

/*
 * nstr.c
 *
 * compile and execute the item selections
 * on sectors.
 *
 * Dave Pare, 1989
 */

#include <ctype.h>
#include "struct.h"
#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "match.h"
#include "file.h"

/*
 * return true if the conditions on this item
 * are all true.
 */
int
nstr_exec(conds, ncond, ptr, type)
	struct	nscstr *conds;
	register int ncond;
	caddr_t	ptr;
	int	type;
{
	register struct nscstr *nsc;
	register int op;
	register int lhs;
	register int rhs;

	for (nsc=conds; --ncond >= 0; nsc++) {
		lhs = decode(nsc->fld1, ptr, type);
		rhs = decode(nsc->fld2, ptr, type);
		op = nsc->oper;
		if ((op == '<' && lhs >= rhs) ||
		    (op == '=' && lhs != rhs) ||
		    (op == '>' && lhs <= rhs) ||
		    (op == '#' && lhs == rhs))
			return 0;
	}
	return 1;
}

int
decode(code, addr, type)
	register long code;
	register s_char *addr;
	int	type;
{
	register int val;
	register int nsc_code;

	val = (code & ~NSC_MASK) & 0xffff;
	nsc_code = code & NSC_CMASK;
	if (nsc_code == NSC_VAR) {
		val = getvar(val, addr, type);
	} else if (nsc_code == NSC_OFF) {
		/*
		 * add offset to value
		 */
		addr += val;
		switch (code & NSC_TMASK) {
		case NSC_CHAR:
			val = *((s_char *) addr);
			break;
		case NSC_UCHAR:
			val = (int) *((unsigned char *) addr);
			break;
		case NSC_SHORT:
			val = *((short *) addr);
			break;
		case NSC_LONG:
			val = *((long *) addr);
			break;
		default:
			logerror(fmt("bad type in decode: %x!\n",
				code & NSC_TMASK));
			val = 0;
			break;
		}
	}
	return val;
}
