#include <stdio.h>
#include "as.h"
#include "misc.h"

#if !defined(lint) && !defined(SABER)
static	char	sccsid[] = "@(#)as_hash.c	1.2	11/13/90";
#endif /* not lint */

extern	s_char *calloc();

/*
 * Return a pointer to the as_queue structure associated with
 * this coordinate if the coordinate is in the queue.
 */
struct as_queue *
as_iscinq(adp, c)
	struct as_data	*adp;
	struct as_coord	c;
{
	int		hashval;
	struct as_hash	*hp;

	hashval = (*adp->hash)(c) % adp->hashsize;

	for (hp = adp->hashtab[hashval]; hp; hp = hp->next)
		if (hp->c.x == c.x && hp->c.y == c.y)
				return (hp->qp);

	return (NULL);
}

/*
 * Set the queue structure associated with this coordinate.
 */
void
as_setcinq(adp, c, qp)
	struct as_data	*adp;
	struct as_coord	c;
	struct as_queue	*qp;
{
	int		hashval;
	struct as_hash	*hp;
	struct as_hash	*new;

	new = (struct as_hash *) calloc(1, sizeof(*new));
	new->c = c;
	new->qp = qp;

	hashval = (*adp->hash)(c) % adp->hashsize;
	hp = adp->hashtab[hashval];

	new->next = (hp) ? hp : NULL;
	adp->hashtab[hashval] = new;
}

/*
 * Walk down the hash table array, freeing the chains and zeroing
 * the chain pointers.
 */
void
as_free_hashtab(adp)
	struct as_data	*adp;
{
	int		i;
	struct as_hash	*hp, *hp2;

	for (i = 0; i < adp->hashsize; i++) {
		for (hp = adp->hashtab[i]; hp; hp = hp2) {
			hp2 = hp->next;
			free((char *)hp);
		}
		adp->hashtab[i] = NULL;
	}
}
