#include "as.h"

#if !defined(lint) && !defined(SABER)
static	char	sccsid[] = "@(#)as_costcomp.c	1.4	11/13/90";
#endif / not lint*/

/*
 * Compare the lower bound costs of two nodes.  If the two nodes have
 * equal lower bound costs, sort on the secondary field.
 * Used as comparision function for qsort.
 */
int
as_costcomp(n1, n2)
	struct as_node	**n1;
	struct as_node	**n2;
{
	double		diff;

	diff = (*n1)->lbcost - (*n2)->lbcost;
	if (diff < -0.0001)
		return (-1);
	if (diff > 0.0001)
		return (1);

	/* equal, check secondary cost */
	diff = (*n1)->seccost - (*n2)->seccost;
	if (diff < -0.0001)
		return (-1);
	if (diff > 0.0001)
		return (1);
	return (0);
}
