#ifndef lint
static char *RCSid = "$Header: trdsub.c,v 1.4 90/03/19 10:55:54 mr-frog Exp $";
#endif /* not lint */

/*
 * trdsub.c
 *
 * trade helper routines
 *
 * St Phil, 1989
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "item.h"
#include "ship.h"
#include "nuke.h"
#include "plane.h"
#include "trade.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"


s_char *
trade_nameof(tp, tgp)
	struct	trdstr *tp;
	union	trdgenstr *tgp;
{
	switch (tp->trd_type) {
	case EF_NUKE:
		return "nuclear stockpile";
	case EF_PLANE:
		return plchr[tgp->pln.pln_type].pl_name;
	case EF_SHIP:
		return mchr[tgp->shp.shp_type].m_name;
	}
	return "Bad trade type, get help";
}

/*
 * Describe an item up for sale.  "tgp" is a union containing
 * the details of the generic item.
 * Return 1 on success, 0 on error
 */
trade_desc(tp, tgp)
	struct	trdstr *tp;
	union	trdgenstr *tgp;
{
	int	i;
	float	price;
	struct	sctstr sect;
	struct	nukstr *np;
	struct	shpstr *sp;
	struct	plnstr *pp;
	struct	natstr *natp;
	int	needcomma;
#ifdef	SHOWPLANE
	struct  nstr_item ni;
	struct  plnstr plane;
#endif	SHOWPLANE

	price = multread(tp->trd_owner, cnum) * tp->trd_price;
	switch (tp->trd_type) {
	case EF_NUKE:
		np = &tgp->nuk;
		if (!getsect(np->nuk_x, np->nuk_y, &sect))
			return 0;
		tp->trd_owner = sect.sct_own;
		natp = getnatp(tp->trd_owner);
		pr(fmt("(#%3d)  %8.8s  %10.2f   ",
			sect.sct_own,
			natp->nat_cnam,
			price));
		needcomma = 0;
		for (i = 0; i < N_MAXNUKE; i++) {
			if (np->nuk_types[i]) {
				if (needcomma)
					pr(",");
				pr(fmt("%dx%s", np->nuk_types[i],
					nchr[i].n_name));
				needcomma = 1;
			}
		}
		break;
	case EF_SHIP:
		sp = &tgp->shp;
		tp->trd_owner = sp->shp_own;
#ifdef	SHIPNAMES
		pr(fmt("(#%3d)  %8.8s  %10.2f   tech %d %d%% %s [",
#else
		pr(fmt("(#%3d)  %8.8s  %10.2f   tech %d %d%% %s %s [",
#endif	SHIPNAMES
			tp->trd_owner, cname(tp->trd_owner),
			price,
			sp->shp_tech,
			sp->shp_effic,
#ifdef	SHIPNAMES
			mchr[sp->shp_type].m_name, sp->shp_name));
#else
			mchr[sp->shp_type].m_name));
#endif	SHIPNAMES
		for (i = 0; i < sp->shp_nv; i++) {
			pr(fmt("%c:%d ",
				ichr[sp->shp_vtype[i] & ~VT_TYPE].i_mnem,
				sp->shp_vamt[i]));
		}
		pr(fmt("] #%d", tp->trd_unitid));
#ifdef	SHOWPLANE
		snxtitem_all(&ni, EF_PLANE);
		while (nxtitem(&ni, (s_char *)&plane))
		{
		    if (plane.pln_ship == sp->shp_uid)
		    {
			pr(fmt("\n\t\t\t\t    tech %3d %3d%% %s #%d",
			    plane.pln_tech,
			    plane.pln_effic,
			    plchr[plane.pln_type].pl_name,
			    plane.pln_uid));
			if (plane.pln_nuketype && plane.pln_nukeamt)
			{
			    pr(fmt("(%dx%s)",plane.pln_nukeamt,
				nchr[plane.pln_nuketype].n_name));
			}
		    }
		}
#endif	SHOWPLANE
		getsect(sp->shp_x, sp->shp_y, &sect);
		if (sect.sct_type != SCT_WATER)
			pr(fmt(" in a %s %s", cname(sect.sct_own),
				dchr[sect.sct_type].d_name));
		else
			pr(" at sea");
		break;
	case EF_PLANE:
		pp = &tgp->pln;
		tp->trd_owner = pp->pln_own;
		pr(fmt("(#%3d)  %8.8s  %10.2f   tech %d %d%% %s #%d",
			tp->trd_owner, cname(tp->trd_owner),
			price,
			pp->pln_tech,
			pp->pln_effic,
			plchr[pp->pln_type].pl_name,
			tp->trd_unitid));
		if (pp->pln_nuketype && pp->pln_nukeamt) {
			pr(fmt("(%dx%s)", pp->pln_nukeamt,
				nchr[pp->pln_nuketype].n_name));
		}
		break;
	default:
		pr(fmt("flaky unit type %d", tp->trd_type));
		break;
	}
	return 1;
}

int
trade_getitem(tp, tgp)
	struct	trdstr *tp;
	union	trdgenstr *tgp;
{
	if (!ef_nbread(tp->trd_type, tp->trd_unitid, (s_char *)tgp))
		return 0;
	return 1;
}
