#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/subs/RCS/show.c,v 1.6 89/09/17 21:26:20 mr-frog Exp $";
#endif

/*
 * show.c
 *
 * general routines that are callable to give info on things.
 * currently, planes, ships, nukes and bridges. Tanks & regiments one day?
 *
 * Added nuke_flags to be consistent. Jeff Bailey 12/15/90 (bailey@mcs.kent.edu)
 *
 * Julian Onions, 1988
 */

#include "misc.h"
#include "nuke.h"
#include "var.h"
#include "ship.h"
#include "item.h"
#include "plane.h"

/*
 * This cruft really belongs in the empglb.c file.
 * Yuck.
 */

struct lookup {
	int	key;
	s_char	*value;
};

struct lookup  ship_flags[] = {
	M_FOOD, "fish",
	M_TORP, "torp",
	M_DCH, "dchrg",
	M_FLY, "plane",
	M_MSL, "miss",
	M_OIL, "oil",
	M_SONAR, "sonar",
	M_MINE, "mine",
	M_SWEEP, "sweep",
	M_SUB, "sub",
	M_SPY, "spy",
	M_LAND, "land",
#ifdef NEWSUBS
	M_SUBT, "sub-torp",
#endif /* NEWSUBS */
#ifdef TRADESHIPS
	M_TRADE, "trade",
#endif /* TRADESHIPS */
#ifdef SEMILAND
	M_SEMILAND, "semi-land",
#endif /* SEMILAND */
#ifdef FUEL
	M_OILER, "oiler",
#endif /* FUEL */
	0, 0
};

struct lookup  plane_flags[] = {
	P_T, "tactical",
	P_B, "bomber",
	P_F, "intercept",
	P_C, "cargo",
	P_V, "VTOL",
	P_M, "missile",
	P_L, "light",
	P_S, "spy",
	P_I, "image",
	P_O, "satellite",
	P_X, "stealth",
#ifdef	ABM
	P_N, "SDI",
#endif	ABM
#ifdef	CHOPPER_STEALTH
	P_H, "half-stealth",
#endif	/* CHOPPER_STEALTH */
#ifdef	XLIGHT
	P_E, "x-light",
#endif	/* XLIGHT */
#ifdef	SHIPCHOPPERS
	P_K, "helo",
#endif	/* SHIPCHOPPERS */
#ifdef	ASW_PLANES
	P_A, "ASW",
#endif	/* ASW_PLANES */
#ifdef	PARAFLAG
	P_P, "para",
#endif	/* PARAFLAG */
	P_ESC, "escort",
#ifdef MINE_PLANES
	P_MINE, "mine",
#endif /* MINE_PLANES */
#ifdef SWEEP_PLANES
	P_SWEEP, "sweep",
#endif /* SWEEP_PLANES */
	0, 0
};

struct lookup nuke_flags[] = {
#ifdef	NEUTRON
	N_NEUT,	"neutron",
#endif	NEUTRON
	0,	0
};

static
s_char *
lookup(key, table)
	int     key;
	struct lookup *table;
{
	int	match;

	if ((match = intmatch(key, &table->key, sizeof(*table))) < 0)
		return 0;
	return table[match].value;
}

show_bridge(tlev)
	int     tlev;
{
	extern double buil_bt, buil_bc;
	extern int buil_bh;

	if (tlev < buil_bt)
		return;
	pr(fmt("Bridges require %g tech, %d hcm, %d workers,\n",
	       buil_bt, buil_bh, buil_bh * 2));
	pr(fmt("%d available workforce, and cost $%g\n",
		1 + (buil_bh * 40 / 100), buil_bc));
}

show_nuke_build(tlev)
	int     tlev;
{
	register struct nchrstr *np;
	register int n;
	register int avail;

	pr(fmt("%13s lcm hcm  oil  rad avail tech $\n", ""));
	for (np = nchr, n = 0; n < N_MAXNUKE; np++, n++) {
		avail = 1 +
		     (np->n_rad + np->n_oil + np->n_lcm + np->n_hcm * 2)*20/100;
		if (np->n_tech > tlev) 
			continue;
		if (np->n_name == 0 || np->n_name[0] == '\0')
			continue;
		pr(fmt("%-13.13s %3d %3d %4d %4d %5d %4d $%6d\n",
		       np->n_name, np->n_lcm, np->n_hcm, np->n_oil, np->n_rad,
		       avail, np->n_tech, np->n_cost));
	}
}

show_nuke_capab(tlev)
	int     tlev;
{
	register struct nchrstr *np;
	register int i,j,n;
	s_char	*p;

	pr(fmt("%13s blst dam lbs tech $%7s abilities\n", "",""));
	for (np = nchr, n = 0; n < N_MAXNUKE; np++, n++) {
		if (np->n_tech > tlev)
			continue;
		if (np->n_name == 0 || np->n_name[0] == '\0')
			continue;
		pr(fmt("%-13.13s %4d %3d %3d %4d $%7d ",
		       np->n_name, np->n_blast, np->n_dam,
		       np->n_weight, np->n_tech, np->n_cost));
		for (i = j = 0; i < 32; i++) {
			if (!(np->n_flags & bit(i)))
				continue;
			if (p = lookup(bit(i), nuke_flags)) {
				if (j++ > 0)
					pr(" ");
				pr(p);
			}
		}
		pr("\n");
	}
}

show_ship_build(tlev)
	int     tlev;
{
	register struct mchrstr *mp;
	register int n;

	pr(fmt("%25s lcm hcm avail tech $\n", ""));
	for (mp = mchr, n = 0; n < shp_maxno; n++, mp++) {
		if (mp->m_tech > tlev)
			continue;
		if (mp->m_name == 0 || mp->m_name[0] == '\0')
			continue;
		pr(fmt("%-25.25s %3d %3d %5d %4d $%d\n",
		       mp->m_name, mp->m_lcm, mp->m_hcm,
		       (int) (1 + (2 * mp->m_hcm + mp->m_lcm) * 20 / 100),
		       mp->m_tech, mp->m_cost));
	}
}

show_ship_capab(tlev)
	int     tlev;
{
	register struct mchrstr *mp;
	register u_short *ap;
	register u_char *type;
	register int i;
	register int it;
	int	scount;
	int	n;
	s_char	c;
	s_char	*p;

#ifdef SHIPCHOPPERS
#ifdef XLIGHT
#ifndef FUEL
	pr(fmt("%13s      s  v s  r  f  h  x  p \n", ""));
	pr(fmt("%13s      p  i p  n  i  e  p  l \n", ""));
	pr(fmt("%13s def  d  s y  g  r  l  l  n   cargoes & abilities\n", ""));
#else
	pr(fmt("%13s      s  v s  r  f  h  x  p fuel\n", ""));
	pr(fmt("%13s      p  i p  n  i  e  p  l  c/u\n", ""));
	pr(fmt("%13s def  d  s y  g  r  l  l  n      cargoes & abilities\n", ""));
#endif /* FUEL */
#else /* XLIGHT */
#ifndef FUEL
	pr(fmt("%13s      s  v s  r  f  h  p \n", ""));
	pr(fmt("%13s      p  i p  n  i  e  l \n", ""));
	pr(fmt("%13s def  d  s y  g  r  l  n    cargoes & abilities\n", ""));
#else
	pr(fmt("%13s      s  v s  r  f  h  p fuel\n", ""));
	pr(fmt("%13s      p  i p  n  i  e  l  c/u\n", ""));
	pr(fmt("%13s def  d  s y  g  r  l  n        cargoes & abilities\n", ""));
#endif /* FUEL */
#endif /* XLIGHT */
#else /* SHIPCHOPPERS */
#ifdef XLIGHT
#ifndef FUEL
	pr(fmt("%13s      s  v s  r  f  x  p \n", ""));
	pr(fmt("%13s      p  i p  n  i  p  l \n", ""));
	pr(fmt("%13s def  d  s y  g  r  l  n cargoes & abilities\n", ""));
#else
	pr(fmt("%13s      s  v s  r  f  x  p fuel\n", ""));
	pr(fmt("%13s      p  i p  n  i  p  l  c/u\n", ""));
	pr(fmt("%13s def  d  s y  g  r  l  n      cargoes & abilities\n", ""));
#endif /* FUEL */
#else /* XLIGHT */
#ifndef FUEL
	pr(fmt("%13s      s  v s  r  f  p \n", ""));
	pr(fmt("%13s      p  i p  n  i  l \n", ""));
	pr(fmt("%13s def  d  s y  g  r  n cargoes & abilities\n", ""));
#else
	pr(fmt("%13s      s  v s  r  f  p fuel\n", ""));
	pr(fmt("%13s      p  i p  n  i  l  c/u\n", ""));
	pr(fmt("%13s def  d  s y  g  r  n      cargoes & abilities\n", ""));
#endif /* FUEL */
#endif /* XLIGHT */
#endif /* SHIPCHOPPERS */
	for (mp = mchr, scount = 0; scount < shp_maxno; scount++, mp++) {
		if (mp->m_tech > tlev)
			continue;
		if (mp->m_name == 0 || mp->m_name[0] == '\0')
			continue;
		pr(fmt("%-13.13s %3d %2d %2d %1d %2d %2d ",
		       mp->m_name, mp->m_armor, mp->m_speed,
		       mp->m_visib, mp->m_vrnge, mp->m_frnge,
		       mp->m_glim));

#ifdef SHIPCHOPPERS
		pr(fmt("%2d ", mp->m_nchoppers));
#endif /* SHIPCHOPPERS */
#ifdef XLIGHT
		pr(fmt("%2d ", mp->m_nxlight));
#endif /* XLIGHT */
		pr(fmt("%2d ", mp->m_nplanes));
#ifdef FUEL
		pr(fmt("%3d/%1d ", mp->m_fuelc,mp->m_fuelu));
#endif /* FUEL */
		/*
		 * should use vector stuff
		 */
		for (ap = mp->m_vamt, type = mp->m_vtype, i = 0;
		     i < mp->m_nv; i++, ap++, type++) {
			it = unitem((int) *type);
			if (it > 0 && it <= I_MAX && ichr[it].i_name != 0)
				c = ichr[it].i_name[0];
			else
				c = '?';
			pr(fmt(" %d%c", *ap, c));
		}
		pr(" ");
		for (i = n = 0; i < 32; i++) {
			if (!(mp->m_flags & bit(i)))
				continue;
			if (p = lookup(bit(i), ship_flags)) {
				if (n++ > 0)
					pr(" ");
				pr(p);
			}
		}
		pr("\n");
	}
}

show_plane_capab(tlev)
	int     tlev;
{
	register struct plchrstr *pp;
	register int i;
	int	pcount;
	int	n;
	s_char	*p;

#ifdef STEALTHV
	pr(fmt("%18s acc load att def ran fuel stlth abilites\n", ""));
#else
	pr(fmt("%18s acc load att def ran fuel abilites\n", ""));
#endif /* STEALTHV */
	for (pp = plchr, pcount = 0; pcount < pln_maxno; pcount++, pp++) {
		if (pp->pl_tech > tlev)
			continue;
		if (pp->pl_name == 0 || pp->pl_name[0] == '\0')
			continue;
		pr(fmt("%-18.18s %3d %4d %3d %3d %3d %4d ",
		       pp->pl_name, pp->pl_acc, pp->pl_load,
		       pp->pl_att, pp->pl_def, pp->pl_range,
		       pp->pl_fuel));
#ifdef STEALTHV
		pr(fmt("%4d%% ",pp->pl_stealth));
#endif /* STEALTHV */
		for (i = n = 0; i < 32; i++) {
			if (!(pp->pl_flags & bit(i)))
				continue;
			if (p = lookup(bit(i), plane_flags)) {
				if (n++ > 0)
					pr(" ");
				pr(p);
			}
		}
		pr("\n");
	}
}

show_plane_build(tlev)
	int     tlev;
{
	register struct plchrstr *pp;
	register int n;

	pr(fmt("%25s lcm hcm crew avail tech  $\n", ""));
	for (pp = plchr, n = 0; n < pln_maxno; n++, pp++) {
		if (pp->pl_tech > tlev)
			continue;
		if (pp->pl_name == 0 || pp->pl_name[0] == '\0')
			continue;
		pr(fmt("%-25.25s %3d %3d %3d %5d %4d $%d\n",
		       pp->pl_name, pp->pl_lcm,
		       pp->pl_hcm, pp->pl_crew,
		       (int) (1 + (2 * pp->pl_hcm + pp->pl_lcm) * 50 / 100),
		       pp->pl_tech, pp->pl_cost));
	}
}
