static char *RCSid = "$Header: recvclient.c,v 1.7 90/04/13 12:24:30 mr-frog Exp $";

/*
 * sendclient.c
 *
 * send and recieve commands
 *
 * Dave Pare, 1986
 */

#include <stdio.h>
#include "misc.h"
#include "bit.h"
#include "io.h"

#include <errno.h>

int	aborted;

int
recvclient(cmd, size)
	s_char	*cmd;
	int	size;
{
	extern	int errno;
	extern	iop_t playerio;
	extern	iop_t iop;
	int	n;
	int	count;

	if (aborted)
		return -2; 
	count = io_gets(playerio, cmd, size);
	while (!aborted && count < 0) {
		io_flush();
		n = io_select(0);
		if (n < 0) {
			/* treat an error like a ^D */
			break;
		}
		if (io_error(iop) || io_eof(iop) || io_error(playerio)) {
			aborted++;
			break;
		}
		if (io_eof(playerio))
			return -1;
		count = io_gets(playerio, cmd, size);
	}
	if (count > 0) {
		if (strcmp(cmd, "ctld") == 0)
			return -1;
		if (strcmp(cmd, "aborted") == 0)
			aborted = 1;
	}
	if (aborted)
		return -2;
	return count;
}
