#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/thre.c,v 1.5 89/08/05 03:26:35 jeffw Exp $";
#endif /* not lint */

/*
 * thre.c
 *
 * describe threshold for given commodity in a sector
 * just like deliver...except this is used for distribution
 * sectors.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "item.h"
#include "nsc.h"
#include "nat.h"
#include "file.h"

/*
 * threshold <COMM> <SECTS> <THRESH>
 */
thre()
{
	extern	int aborted;
	extern	struct ichrstr *whatitem();
	extern	s_char *argp[];
	struct	sctstr sect;
	struct	nstr_sect nstr;
	int	val;
	struct	ichrstr *ip;
	s_char	*p;
	int	thresh;
	int	type;

	if ((ip = whatitem(argp[1], "What commodity? ")) == 0)
		return RET_SYN;
	if (ip->i_vtype == V_CIVIL || ip->i_vtype == V_MILIT) {
		pr("You can't distribute people!\n");
		return RET_SYN;
	}
	if (!snxtsct(&nstr, argp[2]))
		return RET_SYN;
	type = V_DIST(ip->i_vtype & ~VT_TYPE);
	if (argp[3] && *argp[3] && (*argp[3] < '0' || *argp[3] > '9')) {
		pr ("Threshold must be a number\n");
		return RET_SYN;
	}
	while (!aborted && nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
		val = getvar(type, (s_char *)&sect, EF_SECTOR);
		if (val > 0)
			p = fmt("%s %s  old threshold %d new? ",
				xyas(nstr.x, nstr.y, cnum),
				dchr[sect.sct_type].d_name, val);
		else
			p = fmt("%s %s  threshold? ",
				xyas(nstr.x, nstr.y, cnum),
				dchr[sect.sct_type].d_name);
		if ((p = getstarg(argp[3], p)) == 0)
			continue;
		if (*p == '\0' || *p == '-')
			continue;
		thresh = atoi(p);
		if (thresh > 10000)
			thresh = 10000;
		if (val > 0 && (argp[3] != 0 && *argp[3] != 0))
			pr(fmt("%s old threshold %d\n",
				xyas(nstr.x, nstr.y, cnum),
				val));
		if (putvar(type, thresh, (s_char *)&sect, EF_SECTOR) < 0)
			pr(fmt("No room for threshold in %s\n",
				xyas(nstr.x, nstr.y, cnum)));
		putsect(&sect);
	}
	return RET_OK;
}
