#ifndef lint
static char *RCSid = "$Header: shoo.c,v 1.7 89/11/15 11:30:31 mr-frog Exp $";
#endif

/*
 * shoo.c
 *
 * shoot some conquered populace or pigeons.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "xy.h"
#include "var.h"
#include "sect.h"
#include "news.h"
#include "item.h"
#include "path.h"
#include "nat.h"
#include "file.h"
#include "nsc.h"

shoo()
{
	extern s_char *argp[];
	struct sctstr sect;
	struct	nstr_sect nstr;
	int     nshot;
	int     mob_cost;
	int	item;
	struct	ichrstr *ip;
	int	targets;
	s_char	*p;
	int	vec[I_MAX+1];

	if (!snxtsct(&nstr, argp[1]))
		return RET_SYN;
	ip = whatitem(argp[2], "Shoot what <civ or uw> ");
	if (ip == 0 || (ip->i_vtype != V_CIVIL && ip->i_vtype != V_UW))
		return RET_SYN;
	item = ip - ichr;
	p = getstarg(argp[3], fmt("number of %s to shoot (max 999)? ",
		ip->i_name));
	if (p == 0 || (targets = atoi(p)) <= 0)
		return RET_SYN;
	if (targets > 999)
		targets = 999;
	while (nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
		if (getvec(VT_ITEM, vec, (s_char *) &sect, EF_SECTOR) <= 0)
			continue;
		if (vec[item] == 0 || vec[I_CIVIL] > vec[I_MILIT] * 10)
			continue;
		nshot = vec[item] > targets ? targets : vec[item];
		mob_cost = (nshot + 4) / 5;
		if (mob_cost > sect.sct_mobil) {
			nshot = sect.sct_mobil * 5;
			mob_cost = sect.sct_mobil;
		}
		if (nshot <= 0)
			continue;
		sect.sct_mobil -= mob_cost;
		vec[item] -= nshot;
		pr(fmt("BANG!! (thump) %d %s shot in %s!\n",
		       nshot, ip->i_name, 
		       xyas(sect.sct_x, sect.sct_y,cnum)));
		if (vec[item] <= 0 && ip->i_vtype == V_CIVIL &&
		    (sect.sct_own != sect.sct_oldown)) {
			sect.sct_oldown = sect.sct_own;
			pr(fmt("  %s is now completely yours\n",
			       xyas(sect.sct_x, sect.sct_y,cnum)));
		}
		if (chance(nshot / 100.0))
			nreport(cnum, N_SHOOT_CIV, sect.sct_oldown, 1);
		putvar(ip->i_vtype, vec[item], (s_char *)&sect, EF_SECTOR);
		putsect(&sect);
	}
	return RET_OK;
}
