#ifndef lint
static char *RCSid = "$Header: news.c,v 1.5 89/06/04 21:27:26 mr-frog Exp $";
#endif /* not lint */

/*
 * news
 *
 * Show the current empire news
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "news.h"
#include "file.h"
#include "xy.h"
#include "nsc.h"

static	preport();

news()
{
	extern	s_char *argp[];
	struct	natstr *natp;
	long	now;
	int	page;
	time_t	delta;
	long	then;
	struct	nwsstr nws;
	struct	nstr_item nstr;

	(void) head();
	(void) time(&now);
	natp = getnatp(cnum);
	if (argp[1] != 0 && *argp[1] != 0) {
		then = days(atoi(argp[1]));
		delta = now - then;
	} else
		delta = natp->nat_newstim;
	NAT_SET(nat_newstim, cnum, now);
	if (delta < now - days(3))
		delta = now - days(3);
	snxtitem(&nstr, EF_NEWS, "*");
	pr(fmt("\nThe details of Empire news since %s", ctime(&delta)));
	for (page = 1; page <= 3; page++) {
		pr(fmt("\n\t === page %d ===\n", page));
		while (nxtitem(&nstr, (s_char *)&nws)) {
			if (rpt[nws.nws_vrb].r_newspage != page)
				continue;
			if (nws.nws_when < delta)
				continue;
			if (nws.nws_ntm == 0)
				nws.nws_ntm = 1;
			preport(&nws);
		}
		if (page < 3)
			snxtitem_rewind(&nstr);
	}
	return 0;
}

static
preport(np)
	register struct nwsstr *np;
{
	register s_char *cp;
	register int i;
	s_char	buf[255];
	s_char	*ptr;

	cp = buf;
	*cp = 0;
	cp = copy(fmt("%-16.16s  ", ctime(&np->nws_when)), cp);
	ptr = numstr(np->nws_ntm);
	/*
	 * vary the order of the printing of "%d times "
	 */
	if ((random() & 3) == 0 && np->nws_ntm > 1) {
		cp = copy(fmt("%s times ", ptr), cp);
		np->nws_ntm = 1;
	}
	cp = copy(cname(np->nws_ano), cp);
	*cp++ = ' ';
	if (np->nws_vrb < 1 || np->nws_vrb > N_MAX_VERB)
		np->nws_vrb = 0;
	cp = copy(fmt(rpt[np->nws_vrb].r_newstory[random() % NUM_RPTS],
		cname(np->nws_vno)), cp);
	if (np->nws_ntm != 1)
		cp = copy(fmt(" %s times", ptr), cp);
	*cp = 0;
	if (*buf >= 'a' && *buf <= 'z')
		*buf += 'A' - 'a';
	if (cp - buf > 80) {
		for (i=80; --i > 60; )
			if (buf[i] == ' ') break;
		buf[i] = '\0';
		pr(fmt("%s\n\t\t  %s\n", buf, &buf[i+1]));
	} else {
		pr(fmt("%s\n", buf));
	}
	np->nws_ntm = 0;
	return;
}
