/*
 * mobq.c
 *
 * set the sailing mobility quota for a ship
 *
 * hacked by Robert Forsman <thoth@beach.cis.ufl.edu>
 * by staring at flee.c
 */

#include <ctype.h>
#include "misc.h"
#include "var.h"
#include "ship.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"
#include "nat.h"

#ifdef	SAIL

mobq()
{
	extern	s_char *argp[];
	extern int ship_mob_max,ship_mob_scale,etu_per_update;

	struct shpstr ship;
	s_char	*cp,*s,*oldmq;
	s_char	c;
	int	good,mobquota,count=0;
	struct	nstr_item nstr;

/*	getstarg(argp[1], "ships? ");*/
	if (!snxtitem(&nstr, EF_SHIP, argp[1]))
		return RET_SYN;
	oldmq = argp[2];
	if (oldmq)
	  {
	    good = sscanf(oldmq,"%d",&mobquota);
	    if  (!good)
	      return RET_SYN;
	    if (mobquota<0 || mobquota>ship_mob_max)
	      {
		pr(fmt("Bad mobility quota value %d.\n",mobquota));
		return RET_SYN;
	      }
	    if (mobquota+ship_mob_scale*etu_per_update > ship_mob_max)
	      {
		pr(fmt("warning: %d less than optimal",mobquota));
	      }
	  }
	while (nxtitem(&nstr, (s_char *)&ship)) {
	  if (!owner)
	    continue;
	  if (!oldmq)
	    pr(fmt("Ship #%d at %s.  Old value %d.\n",ship.shp_uid,xyas(ship.shp_x,ship.shp_y,ship.shp_own),ship.shp_mobquota));
	  cp = getstarg(argp[2],"mobility quota?");
	  good = sscanf(cp,"%d",&mobquota);
	    if  (!good)
	      {
		pr(fmt("Huh?\n"));
		continue;
	      }
	  if (!oldmq)
	    {
	      if (mobquota<0 || mobquota>ship_mob_max)
		{
		  pr(fmt("Bad mobility quota value %d.\n",mobquota));
		  continue;
		}
	      if (mobquota+ship_mob_scale*etu_per_update > ship_mob_max)
		{
		  pr(fmt("warning: %d less than optimal",mobquota));
		}
	    }
	  ship.shp_mobquota = mobquota;
	  count ++;
	  putship(nstr.cur, &ship);
	}
	if (count == 0) {
		if (argp[1])
			pr(fmt("%s: No ship(s)\n", argp[1]));
		else
			pr(fmt("%s: No ship(s)\n", ""));
		return RET_FAIL;
	}else
		pr(fmt("%d ship%s\n", count, splur(count)));
	return RET_OK;
}
#endif	SAIL
