#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/mark.c,v 1.10 89/07/19 22:00:04 jeffw Exp $";
#endif /* not lint */

/*
 * mark.c
 *
 * World market report for commodities.
 * displays only the "best prices" for all the
 * commodities available for trading.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "nat.h"
#include "var.h"
#include "item.h"
#include "deity.h"

mark()
{
	extern	s_char *argp[];
	struct	ichrstr *ip;
	int	product;
	int	sellers;
	natid	seller;
	float	price;
	float	bestprice;
	int	amt;
	int	n;
	natid	cn;

	if (commread() < 0) {
		pr("Unable to read commodity file; get help!\n");
		return RET_SYS;
	}
	if (argp[1] && *argp[1]) {
		ip = whatitem(argp[1], "Commodity: ");
		if (ip == 0)
			return RET_OK;
		if (ip->i_sell == 0) {
			pr(fmt("%s cannot be traded!\n", ip->i_name));
			return RET_OK;
		}
		product = ip->i_vtype & ~VT_TYPE;
		sellers = 0;
		for (cn = 0; cn < MAXNOC; cn++) {
			if ((amt = commamt(cn, product, &price)) == 0)
				continue;
			if (sellers == 0) {
				pr(fmt("Trade report: %s\n", ip->i_name));
				pr(" cnum       country   amount  item price\n");
			}
			pr(fmt("(#%3d) %12.12s %7d %7.2f", cn, cname(cn),
			       amt, price));
			if (cn == cnum && !god)
				pr(" (your own lot)\n");
			else
				pr("\n");
			sellers++;
		}
		if (sellers == 0) {
			pr(fmt("No countries are selling %s\n", ip->i_name));
			return RET_OK;
		}
		return RET_OK;
	}
	pr("      -= World Commodity Market Report =-\n");
	pr("            -= Today's Best Buys =-\n");
	pr("            ");
	prdate();
	pr(" item          cnum      country     qty  $/unit\n");
	bestprice = 0;
	for (ip = &ichr[1]; ip->i_name != 0; ip++) {
		if (ip->i_sell == 0)
			continue;
		seller = 0;
		product = ip->i_vtype & ~VT_TYPE;
		for (cn = 1; cn < MAXNOC; cn++) {
			if (cn == cnum && !god)
				continue;
			if ((n = commamt(cn, product, &price)) <= 0)
				continue;
			if (seller == 0 || (bestprice >= price)) {
				if ((bestprice == price) && (amt >= n))
					continue;
				bestprice = price;
				amt = n;
				seller = cn;
			}
		}
		if (seller)
			pr(fmt("%-12.12s (#%3d) %12.12s %7d %7.2f\n",
			       ip->i_name, seller, cname(seller), amt,
			       bestprice));
	}
	return RET_OK;
}
