#ifndef lint
static char *RCSid = "$Header: cens.c,v 1.13 89/08/04 20:10:39 jeffw Exp $";
#endif /* not lint */

/*
 * cens.c
 *
 * do a census report
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "deity.h"
#include "path.h"
#include "file.h"

static	cens_hdr();

cens()
{
	extern	s_char *argp[];
	struct	sctstr sect;
	int	nsect;
	int	n;
	struct	nstr_sect nstr;
	s_char	dirstr[20];
	int	vec[I_MAX+1];

	if (!snxtsct(&nstr, argp[1]))
		return RET_SYN;
	prdate();
	for (n = 1; n <= 6; n++)
		dirstr[n] = dirch[n];
	dirstr[0] = '.';
	dirstr[7] = '$';
	dirstr[8] = '\0';
	nsect = 0;
	while (nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
		if (nsect++ == 0)
			cens_hdr();
		if (god)
			pr(fmt("%3d ", sect.sct_own));
		pr(xyfmt("%4d,%-4d", nstr.x, nstr.y, cnum));
		pr(fmt(" %c", dchr[sect.sct_type].d_mnem));
		if (sect.sct_newtype != sect.sct_type)
			pr(fmt("%c", dchr[sect.sct_newtype].d_mnem));
		else
			pr(" ");
		pr(fmt("%4d%%", sect.sct_effic));
		pr(fmt("%4d", sect.sct_mobil));

		getvec(VT_DEL, vec, (s_char *)&sect, EF_SECTOR);
		pr(fmt(" %c", dirstr[vec[I_UW] & 0x7]));
		pr(fmt("%c", dirstr[vec[I_FOOD] & 0x7]));

		getvec(VT_DIST, vec, (s_char *)&sect, EF_SECTOR);
		n = vec[I_UW] % 1000;
		pr(fmt(" %c", n == 0 ? '.' : '0'+ (n/100)));
		n = vec[I_FOOD] % 1000;
		pr(fmt("%c ", n == 0 ? '.' : '0'+ (n/100)));
		pr(fmt("%c", sect.sct_own != sect.sct_oldown ? '*' : ' '));

		getvec(VT_ITEM, vec, (s_char *)&sect, EF_SECTOR);
		pr(fmt("%5d", vec[I_CIVIL]));
		pr(fmt("%5d", vec[I_MILIT]));
		pr(fmt("%5d", vec[I_UW]));
		pr(fmt("%5d", vec[I_FOOD]));
		pr(fmt("%4d%%", sect.sct_work));
		pr(fmt("%5d", sect.sct_avail));
#ifdef	FALLOUT
		if (!god)
#else
		if (!god && sect.sct_terr > 0)
#endif	FALLOUT
			pr(fmt("%4d", sect.sct_terr));
#ifdef	FALLOUT
		getvec(VT_COND, vec, (void *)&sect, EF_SECTOR);
		pr(fmt("%4d",vec[C_FALLOUT]));
#endif	FALLOUT
		pr("\n");
	}
	if (nsect == 0) {
		if (argp[1])
			pr(fmt("%s: No sector(s)\n", argp[1]));
		else
			pr(fmt("%s: No sector(s)\n", ""));
		return RET_FAIL;
	}else
		pr(fmt("%d sector%s\n", nsect, splur(nsect)));
	return 0;
}

static
cens_hdr()
{
	if (god)
		pr("    ");
	pr("CENSUS               del dst\n");
	if (god)
		pr("own ");
	pr("  sect        eff mob uf uf *  civ  mil   uw food work avail ");
	if (!god)
		pr("ter");
#ifdef	FALLOUT
	pr(" fallout ");
#endif	FALLOUT
	pr("\n");
}
