#ifndef lint
static char *RCSid = "$Header: /SRX/empire/EMP/player/commands/reje.c 1.0 90/03/17 10:08:15 bailey Exp $";
#endif /* not lint */

/*
 * reje.c
 *
 * Refuse to accept either telegrams or treaties from individual
 * countries. Adapted from decl.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "news.h"
#include "file.h"
#include "xy.h"
#include "nsc.h"

#ifdef	REJECTS

reje()
{
	extern	char *argp[];
	register char *p;
	struct	natstr	*natp;
	int	rel;
	int	oldrel;
	int	n;
	natid	with;
	int	do_undo;
#ifdef MERC
	struct	natstr nat;
	struct	nstr_item ni;
#endif

	natp = getnatp(cnum);
	p = getstarg(argp[1], "reject or accept? ");
	switch (*p) {
	case 'r':
		do_undo = 1;
		break;
	case 'a':
		do_undo = 0;
		break;
	default:
		pr("That's not one of the choices!\n");
		return RET_SYN;
	}
#ifdef MERC
	p = getstarg(argp[2], "mail, treaties, loans, or announcements? ");
#else
	p = getstarg(argp[2], "mail, treaties, or announcements? ");
#endif
	switch (*p) {
	case 'a':
		rel = REJ_ANNO;
		break;
#ifdef MERC
	case 'l':
		rel = REJ_LOAN;
		break;
#endif
	case 'm':
		rel = REJ_TELE;
		break;
	case 't':
		rel = REJ_TREA;
		break;
	default:
		pr("That's not one of the choices!\n");
		return RET_SYN;
	}
#ifdef MERC
	if (!snxtitem(&ni, EF_NATION, argp[3]))
		return RET_SYN;
	natp = getnatp(cnum);
	while (nxtitem(&ni, (char *) &nat)) {
		if ((nat.nat_stat & STAT_NORM) == 0)
			continue;
		setrej(cnum, (natid)ni.cur, do_undo, rel);
	}
#else
	if ((n = natarg(argp[3], "with which country? ")) < 0)
		return RET_SYN;
	with = n;
	setrej(cnum, with, do_undo, rel);
#endif
	return RET_OK;
}
#endif	REJECTS
