static char *RCSid = "$Header: tm_news.c,v 1.4 90/03/19 11:25:34 mr-frog Exp $";

/*
 * tm_news.c
 *
 * Send a news report to the tm.
 * This is more efficient because each client
 * doesn't have to spend time looking for an unused
 * news file entry (which can be very tedious).
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "tm.h"
#include "news.h"
#include "nat.h"
#include "deity.h"
#include "file.h"
#include "io.h"

nreport(actor, event, victim, times)
	natid	actor;
	int	event;
	natid	victim;
	int	times;
{
	int	nice;
	int	rel;
	char	*status;
	struct	natstr *np;

	sendreport(actor, event, victim, times);
	/*
	 * this is probably pretty expensive, but hopefully we
	 * don't fire zillions of these things off every second.
	 */
	if (victim == 0 || (nice = rpt[event].r_good_will) >= 0)
		return;
	/*
	 * Pretty schlocky to put it here, but
	 * I guess it can't go anywhere else.
	 */
	if (!chance((double)-nice * times/20.0))
		return;
	if ((np = getnatp(victim)) == 0)
		return;
	rel = getrel(np, actor);
	if ((rel <= HOSTILE) && (actor != victim)) {
		rel++;
		if (rel < HOSTILE)
			rel = HOSTILE;
		setrel(victim, actor, rel);
		status = (rel == HOSTILE ? "hostile" : "at war");
		wu(0, victim,
			fmt("Diplomatic relations with %s downgraded to \"%s\"",
				cname(actor), status));
		wu(0, actor, 
			fmt("%s status changed to \"%s\"",
			cname(victim), status));
		if (rel == AT_WAR)
			sendreport(victim, N_DECL_WAR, actor, 1);
	}
}

sendreport(actor, event, victim, times)
	int	actor;
	int	event;
	int	victim;
	int	times;
{
	extern	iop_t iop;
	extern	int tm_seq;
	char buf[80];

	(void) sprintf(buf, "%d %d %d %d %d %d\n", C_NEWS, tm_seq,
		actor, event, victim, times);
	io_puts(iop, buf);
}
