#ifndef lint
static char *RCSid = "$Header: serverio.c 1.3 89/06/09 $";
#endif /* not lint */

/*
 * serverio.c
 *
 * handle input from server
 */

#include "misc.h"
#include "queue.h"
#include "ioqueue.h"

#include <stdio.h>

int
serverio(s, ioq)
	int	s;
	struct	ioqueue *ioq;
{
	extern	char *realloc();
	char	*buf;
	int	n;

	if ((buf = malloc(ioq->bsize)) == 0) {
		fprintf(stderr, "malloc server i/o failed\n");
		return 0;
	}
	n = read(s, buf, ioq->bsize);
	if (n < 0) {
		perror("server i/o read");
		free(buf);
		return 0;
	}
	if (n == 0) {
		fprintf(stderr, "Server EOF\n");
		(void) close(s);
		return 0;
	}
	if (n != ioq->bsize)
		buf = realloc(buf, n);
	ioq_write(ioq, buf, n);
	return 1;
}
